/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.network.client.TerminalState;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.BlockPos;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class MonitorClientMessage
implements NetworkMessage {
    private int x;
    private int y;
    private int z;
    private TerminalState state;

    public MonitorClientMessage() {
    }

    public MonitorClientMessage(BlockPos pos, TerminalState state) {
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        this.state = state;
    }

    public void encodeToUniversalPacket(@NotNull UniversalPacket packet) {
        packet.writeInt(this.x);
        packet.writeInt(this.y);
        packet.writeInt(this.z);
        this.state.write(packet);
    }

    public void decodeFromUniversalPacket(@NotNull UniversalPacket packet) {
        this.x = packet.readInt();
        this.y = packet.readInt();
        this.z = packet.readInt();
        this.state.write(packet);
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (!Helper.isServerEnvironment()) {
            this.clientHandler(context);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void clientHandler(NetworkMessage.NetworkContext context) {
        Player player = context.player;
        if (player == null || player.world == null) {
            return;
        }
        TileEntity te = player.world.getTileEntity(this.x, this.y, this.z);
        if (!(te instanceof TileMonitor)) {
            return;
        }
        ((TileMonitor)te).read(this.state);
    }
}

