/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.gui.GuiComputer;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class OpenGuiComputerClientMessage
implements NetworkMessage {
    private int instanceId;
    private ComputerFamily family;
    private int width;
    private int height;

    public OpenGuiComputerClientMessage(int instanceId, ComputerFamily family, int width, int height) {
        this.instanceId = instanceId;
        this.family = family;
        this.width = width;
        this.height = height;
    }

    public OpenGuiComputerClientMessage() {
    }

    public void encodeToUniversalPacket(@Nonnull UniversalPacket buf) {
        buf.writeInt(this.instanceId);
        buf.writeEnumConstant((Enum)this.family);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
    }

    public void decodeFromUniversalPacket(@Nonnull UniversalPacket buf) {
        this.instanceId = buf.readInt();
        this.family = (ComputerFamily)buf.readEnumConstant(ComputerFamily.class);
        this.width = buf.readInt();
        this.height = buf.readInt();
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (!Helper.isServerEnvironment()) {
            this.clientHandler();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void clientHandler() {
        ContainerComputerBase container = new ContainerComputerBase(this.instanceId, this.family);
        Minecraft.getMinecraft().displayScreen(new GuiComputer<ContainerComputerBase>(container, this.width, this.height));
    }
}

