/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.client.gui.GuiPrintout;
import dan200.computercraft.fabric.Helper;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.core.item.ItemStack;
import turniplabs.halplibe.helper.network.NetworkMessage;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class OpenGuiPrintoutClientMessage
implements NetworkMessage {
    public int itemID;
    public int itemMeta;
    public CompoundTag itemData;

    public OpenGuiPrintoutClientMessage(ItemStack stack) {
        if (stack == null) {
            this.itemID = -1;
            this.itemMeta = 0;
            this.itemData = new CompoundTag();
        } else {
            this.itemID = stack.itemID;
            this.itemMeta = stack.getMetadata();
            this.itemData = stack.getData();
        }
    }

    public OpenGuiPrintoutClientMessage() {
    }

    public void encodeToUniversalPacket(@Nonnull UniversalPacket buf) {
        buf.writeShort((short)this.itemID);
        buf.writeShort((short)this.itemMeta);
        buf.writeCompoundTag(this.itemData);
    }

    public void decodeFromUniversalPacket(@Nonnull UniversalPacket buf) {
        this.itemID = buf.readShort();
        this.itemMeta = buf.readShort();
        this.itemData = buf.readCompoundTag();
    }

    public void handle(NetworkMessage.NetworkContext context) {
        if (!Helper.isServerEnvironment()) {
            this.clientHandler();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void clientHandler() {
        if (this.itemID < 0) {
            return;
        }
        Minecraft.getMinecraft().displayScreen((Screen)new GuiPrintout(new ItemStack(this.itemID, 1, this.itemMeta, this.itemData)));
    }
}

