/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.network.client.OpenGuiContainerMessage;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.inventory.MenuTurtle;
import dan200.computercraft.shared.turtle.inventory.ScreenTurtle;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.Screen;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerInventory;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class OpenGuiTurtleClientMessage
extends OpenGuiContainerMessage<TileTurtle> {
    private int instanceId;
    private ComputerFamily family;
    private int width;
    private int height;

    public OpenGuiTurtleClientMessage(TileTurtle container, int instanceId, ComputerFamily family, int width, int height) {
        super(container);
        this.instanceId = instanceId;
        this.family = family;
        this.width = width;
        this.height = height;
    }

    public OpenGuiTurtleClientMessage() {
        super(new TileTurtle());
    }

    @Override
    public void encodeToUniversalPacket(@Nonnull UniversalPacket buf) {
        super.encodeToUniversalPacket(buf);
        buf.writeInt(this.instanceId);
        buf.writeEnumConstant((Enum)this.family);
        buf.writeInt(this.width);
        buf.writeInt(this.height);
    }

    @Override
    public void decodeFromUniversalPacket(@Nonnull UniversalPacket buf) {
        super.decodeFromUniversalPacket(buf);
        this.instanceId = buf.readInt();
        this.family = (ComputerFamily)buf.readEnumConstant(ComputerFamily.class);
        this.width = buf.readInt();
        this.height = buf.readInt();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected Screen getScreenInstance(ContainerInventory playerInventory, TileTurtle container) {
        ContainerComputerBase containerComputerBase = new ContainerComputerBase(this.instanceId, this.family);
        return new ScreenTurtle<ContainerComputerBase>(containerComputerBase, this.width, this.height, playerInventory, container);
    }

    @Override
    protected MenuAbstract getMenuInstance(Container playerInventory, TileTurtle container) {
        return new MenuTurtle(playerInventory, container);
    }
}

