/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.util.IoUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import turniplabs.halplibe.helper.network.UniversalPacket;

public class TerminalState {
    public final boolean colour;
    public final int width;
    public final int height;
    public final int selectedSlot;
    private final boolean compress;
    @Nullable
    private final ByteBuf buffer;
    private ByteBuf compressed;

    public TerminalState(boolean colour, @Nullable Terminal terminal, int selectedSlot) {
        this(colour, terminal, selectedSlot, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalState(boolean colour, @Nullable Terminal terminal, int selectedSlot, boolean compress) {
        this.colour = colour;
        this.selectedSlot = selectedSlot;
        this.compress = compress;
        if (terminal == null) {
            this.height = 0;
            this.width = 0;
            this.buffer = null;
        } else {
            this.width = terminal.getWidth();
            this.height = terminal.getHeight();
            UniversalPacket packet = new UniversalPacket();
            terminal.write(packet);
            this.buffer = Unpooled.buffer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            try {
                try {
                    packet.rawWrite(dos);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    dos.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                byte[] bytes = baos.toByteArray();
                this.buffer.writeBytes(bytes);
            }
            finally {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public TerminalState(UniversalPacket buf) {
        this.colour = buf.readBoolean();
        this.selectedSlot = buf.readByte();
        this.compress = buf.readBoolean();
        if (buf.readBoolean()) {
            this.width = buf.readInt();
            this.height = buf.readInt();
            int length = buf.readInt();
            this.buffer = TerminalState.readCompressed(buf, length, this.compress);
        } else {
            this.height = 0;
            this.width = 0;
            this.buffer = null;
        }
    }

    private static ByteBuf readCompressed(UniversalPacket buf, int length, boolean compress) {
        block5: {
            if (!compress) break block5;
            ByteBuf buffer = Unpooled.buffer();
            GZIPInputStream stream = null;
            try {
                int bytes;
                stream = new GZIPInputStream(buf.readBytesAsStream(length));
                byte[] swap = new byte[8192];
                while ((bytes = ((InputStream)stream).read(swap)) != -1) {
                    buffer.writeBytes(swap, 0, bytes);
                }
            }
            catch (IOException e) {
                try {
                    throw new UncheckedIOException(e);
                }
                catch (Throwable throwable) {
                    IoUtil.closeQuietly(stream);
                    throw throwable;
                }
            }
            IoUtil.closeQuietly(stream);
            return buffer;
        }
        ByteBuf buffer = Unpooled.buffer(length);
        buf.readBytes(buffer.array(), length);
        return buffer;
    }

    public void write(UniversalPacket buf) {
        buf.writeBoolean(this.colour);
        buf.writeByte((byte)this.selectedSlot);
        buf.writeBoolean(this.compress);
        buf.writeBoolean(this.buffer != null);
        if (this.buffer != null) {
            buf.writeInt(this.width);
            buf.writeInt(this.height);
            ByteBuf sendBuffer = this.getCompressed();
            int length = sendBuffer.readableBytes();
            buf.writeInt(length);
            byte[] byteArray = new byte[sendBuffer.readableBytes()];
            sendBuffer.readBytes(byteArray);
            buf.writeBytes(byteArray);
            buf.writeBytes(new int[]{sendBuffer.readerIndex(), sendBuffer.readableBytes()});
            sendBuffer.release();
            this.compressed = null;
        }
    }

    private ByteBuf getCompressed() {
        if (this.buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (!this.compress) {
            return this.buffer;
        }
        if (this.compressed != null) {
            return this.compressed;
        }
        ByteBuf compressed = Unpooled.directBuffer();
        GZIPOutputStream stream = null;
        try {
            stream = new GZIPOutputStream(new ByteBufOutputStream(compressed));
            ((OutputStream)stream).write(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.readableBytes());
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(stream);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(stream);
        this.compressed = compressed;
        return this.compressed;
    }

    public boolean hasTerminal() {
        return this.buffer != null;
    }

    public int size() {
        return this.buffer == null ? 0 : this.buffer.readableBytes();
    }

    public void apply(Terminal terminal) {
        if (this.buffer == null) {
            throw new NullPointerException("buffer");
        }
        UniversalPacket packet = new UniversalPacket();
        byte[] byteArray = new byte[this.buffer.readableBytes()];
        this.buffer.readBytes(byteArray);
        packet.writeBytes(byteArray);
        terminal.read(packet);
    }
}

