/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.diskdrive;

import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import net.minecraft.client.render.block.model.BlockModelHorizontalRotation;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import net.minecraft.core.world.WorldSource;

public class BlockModelDiskDrive<T extends BlockLogic>
extends BlockModelHorizontalRotation<T> {
    public BlockModelDiskDrive(Block<T> block) {
        super(block);
    }

    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int currentMetadata = blockAccess.getBlockMetadata(x, y, z);
        int index = Sides.orientationLookUpHorizontal[6 * Math.min(currentMetadata & 7, 5) + side.getId()];
        if (index >= Sides.orientationLookUpHorizontal.length) {
            return this.blockTextures.get(Side.BOTTOM);
        }
        if (index == Side.NORTH.getId()) {
            IconCoordinate originalFront = this.blockTextures.get(Side.NORTH);
            DiskDriveState currentState = ((DiskDriveState[])DiskDriveState.class.getEnumConstants())[currentMetadata >> 3 & 3];
            switch (currentState) {
                case FULL: {
                    return TextureRegistry.getTexture((String)(originalFront.namespaceId.namespace() + ":block/" + originalFront.namespaceId.value() + "_accepted"));
                }
                case INVALID: {
                    return TextureRegistry.getTexture((String)(originalFront.namespaceId.namespace() + ":block/" + originalFront.namespaceId.value() + "_rejected"));
                }
            }
            return originalFront;
        }
        return this.blockTextures.get(Side.getSideById((int)index));
    }
}

