/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.asm.NamedMethod;
import dan200.computercraft.core.asm.PeripheralMethod;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.peripheral.generic.SaturatedMethod;
import dan200.computercraft.shared.util.BlockPos;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public class GenericPeripheralProvider {
    @Nullable
    public static IPeripheral getPeripheral(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        TileEntity tile = world.getTileEntity(pos.x, pos.y, pos.z);
        if (tile == null) {
            return null;
        }
        ArrayList<SaturatedMethod> saturated = new ArrayList<SaturatedMethod>(0);
        List<NamedMethod<PeripheralMethod>> tileMethods = PeripheralMethod.GENERATOR.getMethods(tile.getClass());
        if (!tileMethods.isEmpty()) {
            GenericPeripheralProvider.addSaturated(saturated, tile, tileMethods);
        }
        return saturated.isEmpty() ? null : new GenericPeripheral(tile, saturated);
    }

    private static void addSaturated(ArrayList<SaturatedMethod> saturated, Object target, List<NamedMethod<PeripheralMethod>> methods) {
        saturated.ensureCapacity(saturated.size() + methods.size());
        for (NamedMethod<PeripheralMethod> method : methods) {
            saturated.add(new SaturatedMethod(target, method));
        }
    }
}

