/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.data;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import dan200.computercraft.shared.peripheral.generic.data.DataHelpers;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.item.tag.ItemTags;

public class ItemData {
    @Nonnull
    public static <T extends Map<? super String, Object>> T fillBasicSafe(@Nonnull T data, @Nonnull ItemStack stack) {
        data.put((String)"id", DataHelpers.getId(stack.getItem()));
        data.put((String)"metadata", stack.getMetadata());
        data.put((String)"name", (String)stack.getItem().namespaceID.toString());
        data.put((String)"count", stack.stackSize);
        return data;
    }

    @Nonnull
    public static <T extends Map<? super String, Object>> T fillBasic(@Nonnull T data, @Nonnull ItemStack stack) {
        ItemData.fillBasicSafe(data, stack);
        String hash = NBTUtil.getNBTHash(stack.getData());
        if (hash != null) {
            data.put((String)"nbt", (String)hash);
        }
        return data;
    }

    @Nonnull
    public static <T extends Map<? super String, Object>> T fill(@Nonnull T data, ItemStack stack) {
        CompoundTag displayTag;
        if (stack == null) {
            return data;
        }
        ItemData.fillBasic(data, stack);
        if (stack.hasCustomName()) {
            data.put((String)"displayName", (String)stack.getCustomName());
        } else {
            data.put((String)"displayName", (String)stack.getDisplayName());
        }
        data.put((String)"maxCount", stack.getMaxStackSize());
        if (stack.isItemStackDamageable()) {
            data.put((String)"damage", stack.getItemDamageForDisplay());
            data.put((String)"maxDamage", stack.getMaxDamage());
        }
        if (stack.isItemDamaged()) {
            data.put((String)"durability", (double)stack.getItemDamageForDisplay() / (double)stack.getMaxDamage());
        }
        HashMap<String, Boolean> tagsTable = new HashMap<String, Boolean>();
        Item item = stack.getItem();
        for (Tag itemTag : ItemTags.TAG_LIST) {
            if (!item.hasTag(itemTag)) continue;
            tagsTable.put(itemTag.getName(), true);
        }
        if (item instanceof ItemBlock) {
            for (Object blockTag : BlockTags.TAG_LIST) {
                if (!((ItemBlock)item).getBlock().hasTag((Tag)blockTag)) continue;
                tagsTable.put(blockTag.getName(), true);
            }
        }
        data.put((String)"tags", tagsTable);
        HashMap<String, Boolean> groupsTable = new HashMap<String, Boolean>();
        for (List itemGroup : Registries.ITEM_GROUPS) {
            for (ItemStack itemStack : itemGroup) {
                if (!itemStack.getItem().equals(item)) continue;
                String key = Registries.ITEM_GROUPS.getKey((Object)itemGroup);
                groupsTable.put(key, true);
            }
        }
        data.put((String)"groups", groupsTable);
        CompoundTag tag = stack.getData();
        if (tag.containsKey("display") && (displayTag = tag.getCompound("display")).containsKey("Lore")) {
            ListTag loreTag = displayTag.getList("Lore");
            data.put((String)"lore", ((List)loreTag.getValue()).stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList()));
        }
        int hideFlags = tag.getInteger("HideFlags");
        if (tag.getBoolean("Unbreakable") && (hideFlags & 4) == 0) {
            data.put((String)"unbreakable", true);
        }
        return data;
    }
}

