/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.methods;

import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.generic.data.ItemData;
import dan200.computercraft.shared.peripheral.generic.methods.ArgumentHelpers;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;

public class InventoryMethods
implements GenericSource {
    @LuaFunction(mainThread=true)
    public static int size(Container inventory) {
        return InventoryMethods.extractHandler(inventory).size();
    }

    @LuaFunction(mainThread=true)
    public static String name(Container inventory) {
        return inventory.getNameTranslationKey();
    }

    @LuaFunction(mainThread=true)
    public static Map<Integer, Map<String, ?>> list(Container inventory) {
        ItemStorage itemStorage = InventoryMethods.extractHandler(inventory);
        HashMap result = new HashMap();
        int size = itemStorage.size();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = itemStorage.getStack(i);
            if (stack == null) continue;
            result.put(i + 1, ItemData.fillBasic(new HashMap(4), stack));
        }
        return result;
    }

    @Nullable
    @LuaFunction(mainThread=true)
    public static Map<String, ?> getItemDetail(Container inventory, int slot) throws LuaException {
        ItemStorage itemStorage = InventoryMethods.extractHandler(inventory);
        ArgumentHelpers.assertBetween(slot, 1, itemStorage.size(), "Slot out of range (%s)");
        ItemStack stack = itemStorage.getStack(slot - 1);
        return stack == null ? null : ItemData.fill(new HashMap(), stack);
    }

    @LuaFunction(mainThread=true)
    public static int getItemLimit(Container inventory, int slot) throws LuaException {
        ArgumentHelpers.assertBetween(slot, 1, inventory.getContainerSize(), "Slot out of range (%s)");
        return inventory.getMaxStackSize();
    }

    @LuaFunction(mainThread=true)
    public static int pushItems(Container from, IComputerAccess computer, String toName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        ItemStorage fromStorage = InventoryMethods.extractHandler(from);
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        ItemStorage toStorage = InventoryMethods.extractHandler(location.getTarget());
        if (toStorage == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween(fromSlot, 1, fromStorage.size(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween(toSlot.get(), 1, toStorage.size(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return InventoryMethods.moveItem(fromStorage, fromSlot - 1, toStorage, toSlot.orElse(0) - 1, actualLimit);
    }

    @LuaFunction(mainThread=true)
    public static int pullItems(Container to, IComputerAccess computer, String fromName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        ItemStorage toStorage = InventoryMethods.extractHandler(to);
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        ItemStorage fromStorage = InventoryMethods.extractHandler(location.getTarget());
        if (fromStorage == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween(fromSlot, 1, fromStorage.size(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween(toSlot.get(), 1, toStorage.size(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return InventoryMethods.moveItem(fromStorage, fromSlot - 1, toStorage, toSlot.orElse(0) - 1, actualLimit);
    }

    @Nullable
    private static ItemStorage extractHandler(@Nullable Object object) {
        if (object instanceof TileEntity) {
            Container inventory = InventoryUtil.getInventory((TileEntity)object);
            if (inventory != null) {
                return ItemStorage.wrap(inventory);
            }
        } else if (object instanceof Container) {
            return ItemStorage.wrap((Container)object);
        }
        return null;
    }

    private static int moveItem(ItemStorage from, int fromSlot, ItemStorage to, int toSlot, int limit) {
        if (limit == 0) {
            return 0;
        }
        ItemStack stack = InventoryUtil.takeItems(limit, from, fromSlot, 1, fromSlot);
        if (stack == null) {
            return 0;
        }
        int stackCount = stack.stackSize;
        ItemStack remainder = toSlot < 0 ? InventoryUtil.storeItems(stack, to) : InventoryUtil.storeItems(stack, to, toSlot, 1, toSlot);
        if (remainder == null) {
            return stackCount;
        }
        int count = stackCount - remainder.stackSize;
        InventoryUtil.storeItems(remainder, from, fromSlot, 1, fromSlot);
        return count;
    }

    @Override
    @Nonnull
    public String id() {
        return "computercraft:inventory";
    }
}

