/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem;

import dan200.computercraft.api.lua.LuaException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class ModemState {
    private final Runnable onChanged;
    private final AtomicBoolean changed = new AtomicBoolean(true);
    private final Set<Integer> channels = new HashSet<Integer>();
    private boolean open = false;

    public ModemState() {
        this.onChanged = null;
    }

    public ModemState(Runnable onChanged) {
        this.onChanged = onChanged;
    }

    public boolean pollChanged() {
        return this.changed.getAndSet(false);
    }

    public boolean isOpen() {
        return this.open;
    }

    private void setOpen(boolean open) {
        if (this.open == open) {
            return;
        }
        this.open = open;
        if (!this.changed.getAndSet(true) && this.onChanged != null) {
            this.onChanged.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen(int channel) {
        Set<Integer> set = this.channels;
        synchronized (set) {
            return this.channels.contains(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(int channel) throws LuaException {
        Set<Integer> set = this.channels;
        synchronized (set) {
            if (!this.channels.contains(channel)) {
                if (this.channels.size() >= 128) {
                    throw new LuaException("Too many open channels");
                }
                this.channels.add(channel);
                this.setOpen(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int channel) {
        Set<Integer> set = this.channels;
        synchronized (set) {
            this.channels.remove(channel);
            if (this.channels.isEmpty()) {
                this.setOpen(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        Set<Integer> set = this.channels;
        synchronized (set) {
            this.channels.clear();
            this.setOpen(false);
        }
    }
}

