/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.common.ComputerCraftItems;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.BlockLogicCable;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.PortableTickScheduler;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class TileCable
extends TileGeneric
implements IPeripheralTile {
    private static final String NBT_PERIPHERAL_ENABLED = "PeripheralAccess";
    private final WiredModemLocalPeripheral peripheral = new WiredModemLocalPeripheral();
    private final WiredModemElement cable = new CableElement();
    private final IWiredNode node = this.cable.getNode();
    public CableModemVariant blockStateModem = CableModemVariant.None;
    public boolean blockStateCable = false;
    public boolean blockStateNorth = false;
    public boolean blockStateSouth = false;
    public boolean blockStateEast = false;
    public boolean blockStateWest = false;
    public boolean blockStateUp = false;
    public boolean blockStateDown = false;
    protected PortableTickScheduler portableTickScheduler = new PortableTickScheduler();
    private boolean peripheralAccessAllowed;
    private final boolean destroyed = false;
    private Direction modemDirection = Direction.NORTH;
    private final WiredModemPeripheral modem = new WiredModemPeripheral(new ModemState(() -> TickScheduler.schedule(this)), this.cable){

        @Override
        @Nonnull
        protected WiredModemLocalPeripheral getLocalPeripheral() {
            return TileCable.this.peripheral;
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            BlockPos pos = TileCable.this.getPos().offset(TileCable.this.modemDirection);
            return Vec3.getPermanentVec3((double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5));
        }

        @Override
        @Nonnull
        public Object getTarget() {
            return TileCable.this;
        }
    };
    private boolean hasModemDirection = false;
    private boolean connectionsFormed = false;

    private BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.onRemove();
    }

    private void onRemove() {
        if (this.worldObj == null || !Helper.isClientWorld()) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    public boolean onBlockRightClicked(Player player, Side side, double xPlaced, double yPlaced) {
        if (player.isSneaking()) {
            return true;
        }
        if (!this.canAttachPeripheral()) {
            return false;
        }
        if (Helper.isClientWorld()) {
            return true;
        }
        String oldName = this.peripheral.getConnectedName();
        this.togglePeripheralAccess();
        String newName = this.peripheral.getConnectedName();
        if (!Objects.equals(newName, oldName)) {
            I18n i18n = I18n.getInstance();
            if (oldName != null) {
                player.sendMessage(i18n.translateKeyAndFormat("chat.computercraft.wired_modem.peripheral_disconnected", new Object[]{oldName}));
            }
            if (newName != null) {
                player.sendMessage(i18n.translateKeyAndFormat("chat.computercraft.wired_modem.peripheral_connected", new Object[]{newName}));
            }
        }
        return true;
    }

    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        if (this.hasModem() && !this.getBlock().getLogic().canPlaceBlockAt(this.worldObj, this.x, this.y, this.z)) {
            if (this.hasCable()) {
                this.worldObj.dropItem(this.x, this.y, this.z, new ItemStack((Item)ComputerCraftItems.WIRED_MODEM, 1));
                this.blockStateModem = CableModemVariant.None;
                this.modemChanged();
                this.connectionsChanged();
            } else {
                this.worldObj.dropItem(this.x, this.y, this.z, new ItemStack((Item)ComputerCraftItems.WIRED_MODEM, 1));
                this.worldObj.setBlockWithNotify(this.x, this.y, this.z, 0);
            }
            return;
        }
        if (Helper.isServerEnvironment() || Helper.isSinglePlayer()) {
            this.portableTickScheduler.scheduleOnNextEndTick(() -> this.onNeighbourTileEntityChange(neighbour));
        }
    }

    @Nonnull
    private Direction getDirection() {
        this.refreshDirection();
        return this.modemDirection == null ? Direction.NORTH : this.modemDirection;
    }

    public boolean hasModem() {
        return this.blockStateModem != CableModemVariant.None;
    }

    boolean hasCable() {
        return this.blockStateCable;
    }

    void modemChanged() {
        if (Helper.isClientWorld()) {
            return;
        }
        if (!this.canAttachPeripheral() && this.peripheralAccessAllowed) {
            this.peripheralAccessAllowed = false;
            this.peripheral.detach();
            this.node.updatePeripherals(Collections.emptyMap());
            this.updateBlockState();
        }
    }

    void connectionsChanged() {
        if (Helper.isClientWorld()) {
            return;
        }
        World world = this.worldObj;
        BlockPos current = this.getPos();
        for (Direction facing : DirectionUtil.FACINGS) {
            IWiredNode node;
            IWiredElement element;
            BlockPos offset = current.offset(facing);
            if (!world.isChunkLoaded(Math.floorDiv(offset.x, 16), Math.floorDiv(offset.z, 16)) || (element = ComputerCraftAPI.getWiredElementAt(world, offset, facing.getOpposite())) == null || (node = element.getNode()) == null || this.node == null) continue;
            if (BlockLogicCable.canConnectIn(this, facing)) {
                this.node.connectTo(node);
                continue;
            }
            if (this.node.getNetwork() != node.getNetwork()) continue;
            this.node.disconnectFrom(node);
        }
        this.updatePlacementState();
    }

    public void updatePlacementState() {
        BlockLogicCable.correctConnections(this.worldObj, this.getPos(), this);
        BlockLogic logic = Helper.getBlockLogic(this.worldObj, this.x, this.y, this.z);
        if (logic instanceof BlockLogicCable) {
            ((BlockLogicCable)logic).updateBlockBoundsFromState((WorldSource)this.worldObj, this.x, this.y, this.z);
            this.worldObj.markBlockNeedsUpdate(this.x, this.y, this.z);
        }
    }

    private boolean canAttachPeripheral() {
        return this.hasCable() && this.hasModem();
    }

    private void updateBlockState() {
        CableModemVariant oldVariant = this.blockStateModem;
        CableModemVariant newVariant = CableModemVariant.from(oldVariant.getFacing(), this.modem.getModemState().isOpen(), this.peripheralAccessAllowed);
        if (oldVariant != newVariant) {
            this.blockStateModem = newVariant;
            this.worldObj.notifyBlockChange(this.x, this.y, this.z, this.getBlockId());
        }
    }

    private void refreshPeripheral() {
        if (this.worldObj != null && !this.isInvalid() && this.peripheral.attach(this.worldObj, this.getPos(), this.getDirection())) {
            this.updateConnectedPeripherals();
        }
    }

    private void updateConnectedPeripherals() {
        Map<String, IPeripheral> peripherals = this.peripheral.toMap();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        if (!Helper.isClientWorld() && this.peripheralAccessAllowed) {
            Direction facing = this.getDirection();
            this.refreshPeripheral();
        }
        this.updatePlacementState();
    }

    public void tick() {
        super.tick();
        this.portableTickScheduler.tickAtStart();
        if (Helper.isClientWorld()) {
            this.portableTickScheduler.tickAtEnd();
            return;
        }
        this.refreshDirection();
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
            if (this.peripheralAccessAllowed) {
                this.peripheral.attach(this.worldObj, this.getPos(), this.modemDirection);
                this.updateConnectedPeripherals();
            }
        }
        this.portableTickScheduler.tickAtEnd();
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            this.peripheral.attach(this.worldObj, this.getPos(), this.getDirection());
            if (!this.peripheral.hasPeripheral()) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.peripheral.toMap());
        } else {
            this.peripheral.detach();
            this.peripheralAccessAllowed = false;
            this.node.updatePeripherals(Collections.emptyMap());
        }
        this.updateBlockState();
    }

    @Nullable
    private Direction getMaybeDirection() {
        this.refreshDirection();
        return this.modemDirection;
    }

    private void refreshDirection() {
        if (this.hasModemDirection) {
            return;
        }
        this.hasModemDirection = true;
        this.modemDirection = this.blockStateModem.getFacing();
    }

    public Packet getDescriptionPacket() {
        return new PacketTileEntityData((TileEntity)this);
    }

    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.peripheralAccessAllowed = nbt.getBoolean(NBT_PERIPHERAL_ENABLED);
        this.peripheral.read(nbt, "");
        this.blockStateModem = CableModemVariant.values()[nbt.getInteger("BlockStateModem")];
        this.blockStateCable = nbt.getBoolean("BlockStateCable");
        this.blockStateNorth = nbt.getBoolean("BlockStateNorth");
        this.blockStateSouth = nbt.getBoolean("BlockStateSouth");
        this.blockStateEast = nbt.getBoolean("BlockStateEast");
        this.blockStateWest = nbt.getBoolean("BlockStateWest");
        this.blockStateUp = nbt.getBoolean("BlockStateUp");
        this.blockStateDown = nbt.getBoolean("BlockStateDown");
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.putBoolean(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        this.peripheral.write(nbt, "");
        nbt.putInt("BlockStateModem", this.blockStateModem.ordinal());
        nbt.putBoolean("BlockStateCable", this.blockStateCable);
        nbt.putBoolean("BlockStateNorth", this.blockStateNorth);
        nbt.putBoolean("BlockStateSouth", this.blockStateSouth);
        nbt.putBoolean("BlockStateEast", this.blockStateEast);
        nbt.putBoolean("BlockStateWest", this.blockStateWest);
        nbt.putBoolean("BlockStateUp", this.blockStateUp);
        nbt.putBoolean("BlockStateDown", this.blockStateDown);
        super.writeToNBT(nbt);
    }

    public void invalidate() {
        super.invalidate();
        this.onRemove();
    }

    public IWiredElement getElement(Direction facing) {
        return BlockLogicCable.canConnectIn(this, facing) ? this.cable : null;
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(Direction side) {
        return this.hasModem() && side == this.getDirection() ? this.modem : null;
    }

    private class CableElement
    extends WiredModemElement {
        private CableElement() {
        }

        @Override
        @Nonnull
        public World getWorld() {
            return TileCable.this.worldObj;
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            BlockPos pos = TileCable.this.getPos();
            return Vec3.getPermanentVec3((double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5));
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            TileCable.this.modem.attachPeripheral(name, peripheral);
        }

        @Override
        protected void detachPeripheral(String name) {
            TileCable.this.modem.detachPeripheral(name);
        }
    }
}

