/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.google.common.base.Objects;
import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemElement;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemLocalPeripheral;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public class TileWiredModemFull
extends TileGeneric
implements IPeripheralTile {
    private static final String NBT_PERIPHERAL_ENABLED = "PeripheralAccess";
    private final WiredModemPeripheral[] modems = new WiredModemPeripheral[6];
    private final WiredModemLocalPeripheral[] peripherals = new WiredModemLocalPeripheral[6];
    private final ModemState modemState = new ModemState(() -> TickScheduler.schedule(this));
    private final WiredModemElement element = new FullElement(this);
    private final IWiredNode node = this.element.getNode();
    private boolean peripheralAccessAllowed = false;
    private final boolean destroyed = false;
    private boolean connectionsFormed = false;

    public TileWiredModemFull() {
        for (int i = 0; i < this.peripherals.length; ++i) {
            Direction facing = Direction.getDirectionById((int)i);
            this.peripherals[i] = new WiredModemLocalPeripheral();
        }
    }

    private static void sendPeripheralChanges(Player player, String kind, Collection<String> peripherals) {
        if (peripherals.isEmpty()) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(peripherals);
        names.sort(Comparator.naturalOrder());
        StringBuilder base = new StringBuilder();
        for (int i = 0; i < names.size(); ++i) {
            if (i > 0) {
                base.append(", ");
            }
            base.append((String)names.get(i));
        }
        I18n i18n = I18n.getInstance();
        player.sendMessage(i18n.translateKeyAndFormat(kind, new Object[]{base}));
    }

    public void invalidate() {
        super.invalidate();
        this.doRemove();
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.doRemove();
    }

    private void doRemove() {
        if (this.worldObj == null || !Helper.isClientWorld()) {
            this.node.remove();
            this.connectionsFormed = false;
        }
    }

    public boolean onBlockRightClicked(Player player, Side side, double xPlaced, double yPlaced) {
        if (Helper.isClientWorld()) {
            return true;
        }
        Set<String> oldPeriphNames = this.getConnectedPeripheralNames();
        this.togglePeripheralAccess();
        Set<String> periphNames = this.getConnectedPeripheralNames();
        if (!Objects.equal(periphNames, oldPeriphNames)) {
            TileWiredModemFull.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_disconnected", oldPeriphNames);
            TileWiredModemFull.sendPeripheralChanges(player, "chat.computercraft.wired_modem.peripheral_connected", periphNames);
        }
        return true;
    }

    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        if (!Helper.isClientWorld() && this.peripheralAccessAllowed) {
            for (Direction facing : DirectionUtil.FACINGS) {
                this.refreshPeripheral(facing);
            }
        }
    }

    public void tick() {
        if (Helper.isClientWorld()) {
            return;
        }
        if (this.modemState.pollChanged()) {
            this.updateBlockState();
        }
        if (!this.connectionsFormed) {
            this.connectionsFormed = true;
            this.connectionsChanged();
            if (this.peripheralAccessAllowed) {
                for (Direction facing : DirectionUtil.FACINGS) {
                    this.peripherals[facing.ordinal()].attach(this.worldObj, this.getPos(), facing);
                }
                this.updateConnectedPeripherals();
            }
        }
    }

    private BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    private void connectionsChanged() {
        if (Helper.isClientWorld()) {
            return;
        }
        BlockPos current = this.getPos();
        for (Direction facing : DirectionUtil.FACINGS) {
            IWiredElement element;
            BlockPos offset = current.offset(facing);
            if (!this.worldObj.isChunkLoaded(Math.floorDiv(offset.x, 16), Math.floorDiv(offset.z, 16)) || (element = ComputerCraftAPI.getWiredElementAt(this.worldObj, offset, facing.getOpposite())) == null) continue;
            this.node.connectTo(element.getNode());
        }
    }

    private void refreshPeripheral(@Nonnull Direction facing) {
        WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
        if (this.worldObj != null && !this.isInvalid() && peripheral.attach(this.worldObj, this.getPos(), facing)) {
            this.updateConnectedPeripherals();
        }
    }

    private void updateConnectedPeripherals() {
        Map<String, IPeripheral> peripherals = this.getConnectedPeripherals();
        if (peripherals.isEmpty()) {
            this.peripheralAccessAllowed = false;
            this.updateBlockState();
        }
        this.node.updatePeripherals(peripherals);
    }

    private Map<String, IPeripheral> getConnectedPeripherals() {
        if (!this.peripheralAccessAllowed) {
            return Collections.emptyMap();
        }
        HashMap<String, IPeripheral> peripherals = new HashMap<String, IPeripheral>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            peripheral.extendMap(peripherals);
        }
        return peripherals;
    }

    private void updateBlockState() {
        int metaId = this.getBlockMeta();
        boolean isModemOn = (metaId & 1) == 1;
        boolean isPeripheralOn = (metaId & 2) == 2;
        boolean modemOn = this.modemState.isOpen();
        boolean peripheralOn = this.peripheralAccessAllowed;
        if (isModemOn == modemOn && isPeripheralOn == peripheralOn) {
            return;
        }
        this.worldObj.setBlockMetadata(this.x, this.y, this.z, (modemOn ? 1 : 0) + (peripheralOn ? 2 : 0));
        this.worldObj.notifyBlockChange(this.x, this.y, this.z, this.getBlockId());
    }

    private Set<String> getConnectedPeripheralNames() {
        if (!this.peripheralAccessAllowed) {
            return Collections.emptySet();
        }
        HashSet<String> peripherals = new HashSet<String>(6);
        for (WiredModemLocalPeripheral peripheral : this.peripherals) {
            String name = peripheral.getConnectedName();
            if (name == null) continue;
            peripherals.add(name);
        }
        return peripherals;
    }

    private void togglePeripheralAccess() {
        if (!this.peripheralAccessAllowed) {
            boolean hasAny = false;
            for (Direction facing : DirectionUtil.FACINGS) {
                WiredModemLocalPeripheral peripheral = this.peripherals[facing.ordinal()];
                peripheral.attach(this.worldObj, this.getPos(), facing);
                hasAny |= peripheral.hasPeripheral();
            }
            if (!hasAny) {
                return;
            }
            this.peripheralAccessAllowed = true;
            this.node.updatePeripherals(this.getConnectedPeripherals());
        } else {
            this.peripheralAccessAllowed = false;
            for (WiredModemLocalPeripheral peripheral : this.peripherals) {
                peripheral.detach();
            }
            this.node.updatePeripherals(Collections.emptyMap());
        }
        this.updateBlockState();
    }

    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.peripheralAccessAllowed = nbt.getBoolean(NBT_PERIPHERAL_ENABLED);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].read(nbt, Integer.toString(i));
        }
    }

    @Nonnull
    public void writeToNBT(CompoundTag nbt) {
        nbt.putBoolean(NBT_PERIPHERAL_ENABLED, this.peripheralAccessAllowed);
        for (int i = 0; i < this.peripherals.length; ++i) {
            this.peripherals[i].write(nbt, Integer.toString(i));
        }
        super.writeToNBT(nbt);
    }

    public IWiredElement getElement() {
        return this.element;
    }

    @Override
    @Nonnull
    public IPeripheral getPeripheral(final Direction side) {
        WiredModemPeripheral peripheral = this.modems[side.ordinal()];
        if (peripheral != null) {
            return peripheral;
        }
        final WiredModemLocalPeripheral localPeripheral = this.peripherals[side.ordinal()];
        WiredModemPeripheral wiredModemPeripheral = new WiredModemPeripheral(this.modemState, this.element){

            @Override
            @Nonnull
            protected WiredModemLocalPeripheral getLocalPeripheral() {
                return localPeripheral;
            }

            @Override
            @Nonnull
            public Vec3 getPosition() {
                BlockPos pos = TileWiredModemFull.this.getPos().offset(side);
                return Vec3.getPermanentVec3((double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5));
            }

            @Override
            @Nonnull
            public Object getTarget() {
                return TileWiredModemFull.this;
            }
        };
        this.modems[side.ordinal()] = wiredModemPeripheral;
        return wiredModemPeripheral;
    }

    private static final class FullElement
    extends WiredModemElement {
        private final TileWiredModemFull entity;

        private FullElement(TileWiredModemFull entity) {
            this.entity = entity;
        }

        @Override
        protected void detachPeripheral(String name) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.detachPeripheral(name);
            }
        }

        @Override
        protected void attachPeripheral(String name, IPeripheral peripheral) {
            for (int i = 0; i < 6; ++i) {
                WiredModemPeripheral modem = this.entity.modems[i];
                if (modem == null) continue;
                modem.attachPeripheral(name, peripheral);
            }
        }

        @Override
        @Nonnull
        public World getWorld() {
            return this.entity.worldObj;
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            BlockPos pos = this.entity.getPos();
            return Vec3.getPermanentVec3((double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5));
        }
    }
}

