/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.Peripherals;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.common.ComputerCraftBlocks;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemPeripheral;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.IDAssigner;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public final class WiredModemLocalPeripheral {
    private static final String NBT_PERIPHERAL_TYPE = "PeripheralType";
    private static final String NBT_PERIPHERAL_ID = "PeripheralId";
    private int id;
    private String type;
    private IPeripheral peripheral;

    public boolean attach(@Nonnull World world, @Nonnull BlockPos origin, @Nonnull Direction direction) {
        IPeripheral oldPeripheral = this.peripheral;
        this.peripheral = this.getPeripheralFrom(world, origin, direction);
        IPeripheral peripheral = this.peripheral;
        if (peripheral == null) {
            return oldPeripheral != null;
        }
        String type = peripheral.getType();
        int id = this.id;
        if (id > 0 && this.type == null) {
            this.type = type;
        } else if (id < 0 || !type.equals(this.type)) {
            this.type = type;
            this.id = IDAssigner.getNextId("peripheral." + type);
        }
        return oldPeripheral == null || !oldPeripheral.equals(peripheral);
    }

    @Nullable
    private IPeripheral getPeripheralFrom(World world, BlockPos pos, Direction direction) {
        BlockPos offset = pos.offset(direction);
        int block = world.getBlockId(offset.x, offset.y, offset.z);
        if (block == ComputerCraftBlocks.WIRED_MODEM_FULL.id() || block == ComputerCraftBlocks.CABLE.id()) {
            return null;
        }
        IPeripheral peripheral = Peripherals.getPeripheral(world, offset, direction.getOpposite());
        return peripheral instanceof WiredModemPeripheral ? null : peripheral;
    }

    public boolean detach() {
        if (this.peripheral == null) {
            return false;
        }
        this.peripheral = null;
        return true;
    }

    @Nullable
    public String getConnectedName() {
        return this.peripheral != null ? this.type + "_" + this.id : null;
    }

    @Nullable
    public IPeripheral getPeripheral() {
        return this.peripheral;
    }

    public boolean hasPeripheral() {
        return this.peripheral != null;
    }

    public void extendMap(@Nonnull Map<String, IPeripheral> peripherals) {
        if (this.peripheral != null) {
            peripherals.put(this.type + "_" + this.id, this.peripheral);
        }
    }

    public Map<String, IPeripheral> toMap() {
        return this.peripheral == null ? Collections.emptyMap() : Collections.singletonMap(this.type + "_" + this.id, this.peripheral);
    }

    public void write(@Nonnull CompoundTag tag, @Nonnull String suffix) {
        if (this.id >= 0) {
            tag.putInt(NBT_PERIPHERAL_ID + suffix, this.id);
        }
        if (this.type != null) {
            tag.putString(NBT_PERIPHERAL_TYPE + suffix, this.type);
        }
    }

    public void read(@Nonnull CompoundTag tag, @Nonnull String suffix) {
        this.id = tag.containsKey(NBT_PERIPHERAL_ID + suffix) ? tag.getInteger(NBT_PERIPHERAL_ID + suffix) : -1;
        this.type = tag.containsKey(NBT_PERIPHERAL_TYPE + suffix) ? tag.getString(NBT_PERIPHERAL_TYPE + suffix) : null;
    }
}

