/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.shared.peripheral.modem.ModemShapes;
import dan200.computercraft.shared.peripheral.modem.wireless.TileWirelessModem;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFullyRotatable;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLogicWirelessModem
extends BlockLogicFullyRotatable {
    public BlockLogicWirelessModem(Block<?> block, boolean advanced) {
        super(block, Material.stone);
        block.withEntity(() -> new TileWirelessModem(advanced));
        this.setBlockBounds(0.125, 0.0, 0.125, 0.875, 0.1875, 0.875);
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        for (Side side : Side.sides) {
            if (!world.isBlockNormalCube(x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ())) continue;
            return true;
        }
        return false;
    }

    private void dropIfCantStay(World world, int x, int y, int z) {
        Direction direction = BlockLogicWirelessModem.metaToDirection((int)world.getBlockMetadata(x, y, z)).getOpposite();
        if (!world.isBlockNormalCube(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ())) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        Direction direction = mob.getPlacementDirection(side, PlacementMode.SIDE);
        world.setBlockMetadataWithNotify(x, y, z, BlockLogicWirelessModem.directionToMeta((Direction)direction));
        this.dropIfCantStay(world, x, y, z);
    }

    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        Direction direction = side.getDirection().getOpposite();
        if (world.isBlockNormalCube(x - direction.getOffsetX(), y - direction.getOffsetY(), z - direction.getOffsetZ())) {
            world.setBlockMetadataWithNotify(x, y, z, BlockLogicWirelessModem.directionToMeta((Direction)direction));
            return;
        }
        world.setBlockMetadataWithNotify(x, y, z, BlockLogicWirelessModem.directionToMeta((Direction)direction.getOpposite()));
        this.dropIfCantStay(world, x, y, z);
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        this.dropIfCantStay(world, x, y, z);
    }

    public boolean isCubeShaped() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        return ModemShapes.getBounds(BlockLogicWirelessModem.metaToDirection((int)world.getBlockMetadata(x, y, z)).getOpposite());
    }
}

