/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.client.gui.FixedWidthFontRenderer;
import dan200.computercraft.shared.util.Palette;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.util.Scanner;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

class MonitorTextureBufferShader {
    static final int TEXTURE_INDEX = 33987;
    private static final FloatBuffer PALETTE_BUFFER = BufferUtils.createFloatBuffer((int)48);
    private static int uniformMv;
    private static int uniformFont;
    private static int uniformWidth;
    private static int uniformHeight;
    private static int uniformTbo;
    private static int uniformPalette;
    private static boolean initialised;
    private static boolean ok;
    private static int program;

    MonitorTextureBufferShader() {
    }

    static void setupUniform(int width, int height, Palette palette, boolean greyscale) {
        GL20.glUniform1i((int)uniformWidth, (int)width);
        GL20.glUniform1i((int)uniformHeight, (int)height);
        PALETTE_BUFFER.clear();
        for (int i = 0; i < 16; ++i) {
            double[] colour = palette.getColour(i);
            if (greyscale) {
                float f = FixedWidthFontRenderer.toGreyscale(colour);
                PALETTE_BUFFER.put(f).put(f).put(f);
                continue;
            }
            PALETTE_BUFFER.put((float)colour[0]).put((float)colour[1]).put((float)colour[2]);
        }
        PALETTE_BUFFER.flip();
        GL20.glUniform3fv((int)uniformPalette, (FloatBuffer)PALETTE_BUFFER);
    }

    static boolean use() {
        if (initialised) {
            if (ok) {
                GL20.glUseProgram((int)program);
            }
            return ok;
        }
        ok = MonitorTextureBufferShader.load();
        if (ok) {
            GL20.glUseProgram((int)program);
            GL20.glUniform1i((int)uniformFont, (int)0);
            GL20.glUniform1i((int)uniformTbo, (int)3);
        }
        return ok;
    }

    private static boolean load() {
        initialised = true;
        try {
            int vertexShader = MonitorTextureBufferShader.loadShader(35633, "assets/computercraft/shaders/monitor.vert");
            int fragmentShader = MonitorTextureBufferShader.loadShader(35632, "assets/computercraft/shaders/monitor.frag");
            program = GL20.glCreateProgram();
            GL20.glAttachShader((int)program, (int)vertexShader);
            GL20.glAttachShader((int)program, (int)fragmentShader);
            GL20.glBindAttribLocation((int)program, (int)0, (CharSequence)"v_pos");
            GL20.glLinkProgram((int)program);
            boolean ok = GL20.glGetProgrami((int)program, (int)35714) != 0;
            String log = GL20.glGetProgramInfoLog((int)program, (int)Short.MAX_VALUE).trim();
            if (!log.isEmpty()) {
                System.out.println("Problems when linking monitor shader: " + log);
            }
            GL20.glDetachShader((int)program, (int)vertexShader);
            GL20.glDetachShader((int)program, (int)fragmentShader);
            GL20.glDeleteShader((int)vertexShader);
            GL20.glDeleteShader((int)fragmentShader);
            if (!ok) {
                return false;
            }
            uniformMv = MonitorTextureBufferShader.getUniformLocation(program, "u_mv");
            uniformFont = MonitorTextureBufferShader.getUniformLocation(program, "u_font");
            uniformWidth = MonitorTextureBufferShader.getUniformLocation(program, "u_width");
            uniformHeight = MonitorTextureBufferShader.getUniformLocation(program, "u_height");
            uniformTbo = MonitorTextureBufferShader.getUniformLocation(program, "u_tbo");
            uniformPalette = MonitorTextureBufferShader.getUniformLocation(program, "u_palette");
            System.out.println("Loaded monitor shader.");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static int loadShader(int kind, String path) {
        try {
            InputStream stream = MonitorTextureBufferShader.class.getResourceAsStream("/" + path);
            if (stream == null) {
                throw new IllegalArgumentException("Cannot find " + path);
            }
            Scanner scanner = new Scanner(stream, "UTF-8");
            String contents = scanner.useDelimiter("\\A").next();
            scanner.close();
            int shader = GL20.glCreateShader((int)kind);
            GL20.glShaderSource((int)shader, (CharSequence)contents);
            GL20.glCompileShader((int)shader);
            boolean ok = GL20.glGetShaderi((int)shader, (int)35713) != 0;
            String log = GL20.glGetShaderInfoLog((int)shader, (int)Short.MAX_VALUE).trim();
            if (!log.isEmpty()) {
                System.out.println("Problems when loading monitor shader " + path + ": " + log);
            }
            if (!ok) {
                throw new IllegalStateException("Cannot compile shader " + path);
            }
            return shader;
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading shader: " + path, e);
        }
    }

    private static int getUniformLocation(int program, String name) {
        int uniform = GL20.glGetUniformLocation((int)program, (CharSequence)name);
        if (uniform == -1) {
            throw new IllegalStateException("Cannot find uniform " + name);
        }
        return uniform;
    }
}

