/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import net.minecraft.core.util.helper.Direction;

public class XYPair {
    public final float x;
    public final float y;

    public XYPair(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public static XYPair of(float xPos, float yPos, float zPos, Direction facing, Direction orientation) {
        switch (orientation) {
            case NORTH: {
                switch (facing) {
                    case NORTH: {
                        return new XYPair(1.0f - xPos, 1.0f - yPos);
                    }
                    case SOUTH: {
                        return new XYPair(xPos, 1.0f - yPos);
                    }
                    case WEST: {
                        return new XYPair(zPos, 1.0f - yPos);
                    }
                    case EAST: {
                        return new XYPair(1.0f - zPos, 1.0f - yPos);
                    }
                }
                break;
            }
            case DOWN: {
                switch (facing) {
                    case NORTH: {
                        return new XYPair(1.0f - xPos, zPos);
                    }
                    case SOUTH: {
                        return new XYPair(xPos, 1.0f - zPos);
                    }
                    case WEST: {
                        return new XYPair(zPos, xPos);
                    }
                    case EAST: {
                        return new XYPair(1.0f - zPos, 1.0f - xPos);
                    }
                }
                break;
            }
            case UP: {
                switch (facing) {
                    case NORTH: {
                        return new XYPair(1.0f - xPos, 1.0f - zPos);
                    }
                    case SOUTH: {
                        return new XYPair(xPos, zPos);
                    }
                    case WEST: {
                        return new XYPair(zPos, 1.0f - xPos);
                    }
                    case EAST: {
                        return new XYPair(1.0f - zPos, xPos);
                    }
                }
            }
        }
        return new XYPair(xPos, zPos);
    }

    public XYPair add(float x, float y) {
        return new XYPair(this.x + x, this.y + y);
    }
}

