/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.printer;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.peripheral.printer.TilePrinter;
import dan200.computercraft.shared.util.StringUtil;
import java.util.Optional;
import javax.annotation.Nonnull;

public class PrinterPeripheral
implements IPeripheral {
    private final TilePrinter printer;

    public PrinterPeripheral(TilePrinter printer) {
        this.printer = printer;
    }

    @Override
    @Nonnull
    public String getType() {
        return "printer";
    }

    @Override
    @Nonnull
    public Object getTarget() {
        return this.printer;
    }

    @Override
    public boolean equals(IPeripheral other) {
        return other instanceof PrinterPeripheral && ((PrinterPeripheral)other).printer == this.printer;
    }

    @LuaFunction
    public final void write(IArguments arguments) throws LuaException {
        String text = StringUtil.toString(arguments.get(0));
        Terminal page = this.getCurrentPage();
        page.write(text);
        page.setCursorPos(page.getCursorX() + text.length(), page.getCursorY());
    }

    @Nonnull
    private Terminal getCurrentPage() throws LuaException {
        Terminal currentPage = this.printer.getCurrentPage();
        if (currentPage == null) {
            throw new LuaException("Page not started");
        }
        return currentPage;
    }

    @LuaFunction
    public final Object[] getCursorPos() throws LuaException {
        Terminal page = this.getCurrentPage();
        int x = page.getCursorX();
        int y = page.getCursorY();
        return new Object[]{x + 1, y + 1};
    }

    @LuaFunction
    public final void setCursorPos(int x, int y) throws LuaException {
        Terminal page = this.getCurrentPage();
        page.setCursorPos(x - 1, y - 1);
    }

    @LuaFunction
    public final Object[] getPageSize() throws LuaException {
        Terminal page = this.getCurrentPage();
        int width = page.getWidth();
        int height = page.getHeight();
        return new Object[]{width, height};
    }

    @LuaFunction(mainThread=true)
    public final boolean newPage() {
        return this.printer.startNewPage();
    }

    @LuaFunction(mainThread=true)
    public final boolean endPage() throws LuaException {
        this.getCurrentPage();
        return this.printer.endCurrentPage();
    }

    @LuaFunction
    public final void setPageTitle(Optional<String> title) throws LuaException {
        this.getCurrentPage();
        this.printer.setPageTitle(StringUtil.normaliseLabel(title.orElse("")));
    }

    @LuaFunction
    public final int getInkLevel() {
        return this.printer.getInkLevel();
    }

    @LuaFunction
    public final int getPaperLevel() {
        return this.printer.getPaperLevel();
    }
}

