/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.speaker;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.fabric.Helper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.core.block.BlockLogicNote;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;

public abstract class SpeakerPeripheral
implements IPeripheral {
    private final AtomicInteger notesThisTick = new AtomicInteger();
    private long clock = 0L;
    private long lastPlayTime = 0L;

    public void update() {
        ++this.clock;
        this.notesThisTick.set(0);
    }

    public boolean madeSound(long ticks) {
        return this.clock - this.lastPlayTime <= ticks;
    }

    @Override
    @Nonnull
    public String getType() {
        return "speaker";
    }

    @LuaFunction
    public final boolean playSound(ILuaContext context, String name, Optional<Double> volumeA, Optional<Double> pitchA) throws LuaException {
        float volume = (float)LuaValues.checkFinite(1, volumeA.orElse(1.0));
        float pitch = (float)LuaValues.checkFinite(2, pitchA.orElse(1.0));
        return this.playSound(context, name, volume, pitch, false);
    }

    private synchronized boolean playSound(ILuaContext context, String name, float volume, float pitch, boolean isNote) throws LuaException {
        if (!(this.clock - this.lastPlayTime >= 1L || isNote && this.clock - this.lastPlayTime == 0L && this.notesThisTick.get() < ComputerCraft.maxNotesPerTick)) {
            return false;
        }
        World world = this.getWorld();
        Vec3 pos = this.getPosition();
        context.issueMainThreadTask(() -> {
            if (!Helper.isServerEnvironment() && !Helper.isSinglePlayer()) {
                return null;
            }
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, pos.x + 0.5, pos.y + 0.5, pos.z + 0.5, name, Math.min(volume, 3.0f), pitch);
            return null;
        });
        this.lastPlayTime = this.clock;
        return true;
    }

    public abstract World getWorld();

    public abstract Vec3 getPosition();

    @LuaFunction
    public final synchronized boolean playNote(ILuaContext context, String name, Optional<Double> volumeA, Optional<Double> pitchA) throws LuaException {
        float volume = (float)LuaValues.checkFinite(1, volumeA.orElse(1.0));
        float pitch = (float)LuaValues.checkFinite(2, pitchA.orElse(1.0));
        BlockLogicNote.Instrument instrument = null;
        for (BlockLogicNote.Instrument testInstrument : BlockLogicNote.Instrument.instrumentMap.values()) {
            if (!testInstrument.soundKey.equalsIgnoreCase(name)) continue;
            instrument = testInstrument;
            break;
        }
        if (instrument == null) {
            throw new LuaException("Invalid instrument, \"" + name + "\"!");
        }
        boolean success = this.playSound(context, "note." + BlockLogicNote.Instrument.getInstrumentFromIndex((int)instrument.index).soundKey, volume, (float)Math.pow(2.0, ((double)pitch - 12.0) / 12.0), true);
        if (success) {
            this.notesThisTick.incrementAndGet();
        }
        return success;
    }
}

