/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.apis;

import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerInventory;

public class PocketAPI
implements ILuaAPI {
    private final PocketServerComputer computer;

    public PocketAPI(PocketServerComputer computer) {
        this.computer = computer;
    }

    private static IPocketUpgrade findUpgrade(ItemStack[] inv, int start, IPocketUpgrade previous) {
        for (int i = 0; i < inv.length; ++i) {
            IPocketUpgrade newUpgrade;
            ItemStack invStack = inv[(i + start) % inv.length];
            if (invStack == null || (newUpgrade = PocketUpgrades.get(invStack)) == null || newUpgrade == previous) continue;
            invStack = invStack.copy();
            --invStack.stackSize;
            inv[(i + start) % inv.length] = invStack.stackSize == 0 ? null : invStack;
            return newUpgrade;
        }
        return null;
    }

    @Override
    public String[] getNames() {
        return new String[]{"pocket"};
    }

    @LuaFunction(mainThread=true)
    public final Object[] equipBack() {
        ItemStack stack;
        Entity entity = this.computer.getEntity();
        if (!(entity instanceof Player)) {
            return new Object[]{false, "Cannot find player"};
        }
        Player player = (Player)entity;
        ContainerInventory inventory = player.inventory;
        IPocketUpgrade previousUpgrade = this.computer.getUpgrade();
        IPocketUpgrade newUpgrade = PocketAPI.findUpgrade(inventory.mainInventory, inventory.getCurrentItemIndex(), previousUpgrade);
        if (newUpgrade == null) {
            return new Object[]{false, "Cannot find a valid upgrade"};
        }
        if (previousUpgrade != null && (stack = previousUpgrade.getCraftingItem()) != null && (stack = InventoryUtil.storeItems(stack, ItemStorage.wrap((Container)inventory), inventory.getCurrentItemIndex())) != null) {
            WorldUtil.dropItemStack(stack, player.world, new BlockPos((int)player.x, (int)player.y, (int)player.z));
        }
        this.computer.setUpgrade(newUpgrade);
        return new Object[]{true};
    }

    @LuaFunction(mainThread=true)
    public final Object[] unequipBack() {
        Entity entity = this.computer.getEntity();
        if (!(entity instanceof Player)) {
            return new Object[]{false, "Cannot find player"};
        }
        Player player = (Player)entity;
        ContainerInventory inventory = player.inventory;
        IPocketUpgrade previousUpgrade = this.computer.getUpgrade();
        if (previousUpgrade == null) {
            return new Object[]{false, "Nothing to unequip"};
        }
        this.computer.setUpgrade(null);
        ItemStack stack = previousUpgrade.getCraftingItem();
        if (stack != null && (stack = InventoryUtil.storeItems(stack, ItemStorage.wrap((Container)inventory), inventory.getCurrentItemIndex())) != null) {
            WorldUtil.dropItemStack(stack, player.world, new BlockPos((int)player.x, (int)player.y, (int)player.z));
        }
        return new Object[]{true};
    }
}

