/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.peripherals;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.AbstractPocketUpgrade;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.shared.common.ComputerCraftItems;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.pocket.peripherals.PocketModemPeripheral;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.util.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PocketModem
extends AbstractPocketUpgrade {
    private final boolean advanced;

    public PocketModem(boolean advanced, int id) {
        super(id, (IItemConvertible)(advanced ? ComputerCraftItems.WIRELESS_MODEM_ADVANCED : ComputerCraftItems.WIRELESS_MODEM_NORMAL));
        this.advanced = advanced;
    }

    @Override
    @Nullable
    public IPeripheral createPeripheral(@Nonnull IPocketAccess access) {
        return new PocketModemPeripheral(this.advanced);
    }

    @Override
    @NotNull
    public String getUnlocalisedAdjective() {
        if (this.advanced) {
            return "upgrade.computercraft.wireless_modem_advanced.adjective";
        }
        return "upgrade.computercraft.wireless_modem_normal.adjective";
    }

    @Override
    public void update(@Nonnull IPocketAccess access, @Nullable IPeripheral peripheral) {
        ModemState state;
        if (!(peripheral instanceof PocketModemPeripheral)) {
            return;
        }
        Entity entity = access.getEntity();
        PocketModemPeripheral modem = (PocketModemPeripheral)peripheral;
        if (entity != null) {
            modem.setLocation(entity.world, Vec3.getPermanentVec3((double)entity.x, (double)(entity.y + (double)entity.getHeadHeight()), (double)entity.z));
        }
        if ((state = modem.getModemState()).pollChanged()) {
            access.setLight(state.isOpen() ? 0xBA0000 : -1);
        }
    }
}

