/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.recipes;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.fabric.mixin.ContainerCraftingAccessor;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.pocket.items.ItemPocketComputer;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerCrafting;

public final class PocketComputerUpgradeRecipe
extends RecipeEntryCrafting<RecipeSymbol[], ItemStack>
implements HasJsonAdapter {
    @Nonnull
    public ItemStack getOutput() {
        return Objects.requireNonNull(PocketComputerItemFactory.create(-1, null, -1, ComputerFamily.NORMAL, null));
    }

    public boolean matches(ContainerCrafting inventory) {
        return this.getCraftingResult(inventory) != null;
    }

    public boolean matchesQuery(SearchQuery searchQuery) {
        return false;
    }

    public ItemStack getCraftingResult(ContainerCrafting inventory) {
        ItemStack computer = null;
        int computerX = -1;
        int computerY = -1;
        int width = ((ContainerCraftingAccessor)inventory).getWidth();
        int height = inventory.getContainerSize() / width;
        block0: for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                ItemStack item = inventory.getItem(x + y * width);
                if (item == null || !(item.getItem() instanceof ItemPocketComputer)) continue;
                computer = item;
                computerX = x;
                computerY = y;
                break block0;
            }
        }
        if (computer == null) {
            return null;
        }
        ItemPocketComputer itemComputer = (ItemPocketComputer)computer.getItem();
        if (ItemPocketComputer.getUpgrade(computer) != null) {
            return null;
        }
        IPocketUpgrade upgrade = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                ItemStack item = inventory.getItem(x + y * width);
                if (x == computerX && y == computerY || !(x == computerX && y == computerY - 1 ? (upgrade = PocketUpgrades.get(item)) == null : item != null)) continue;
                return null;
            }
        }
        if (upgrade == null) {
            return null;
        }
        ComputerFamily family = itemComputer.getFamily();
        int computerID = itemComputer.getComputerID(computer);
        String label = itemComputer.getLabel(computer);
        int colour = itemComputer.getColour(computer);
        return Objects.requireNonNull(PocketComputerItemFactory.create(computerID, label, colour, family, upgrade));
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack[] onCraftResult(ContainerCrafting containerCrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int i = 0; i < containerCrafting.getContainerSize(); ++i) {
            ItemStack itemStack = containerCrafting.getItem(i);
            if (itemStack == null) continue;
            containerCrafting.removeItem(i, 1);
            if (!itemStack.getItem().hasContainerItem()) continue;
            containerCrafting.setItem(i, new ItemStack(itemStack.getItem().getContainerItem()));
        }
        return returnStack;
    }

    public RecipeJsonAdapter<?> getAdapter() {
        return new PocketComputerUpgradeRecipeJsonAdapter();
    }

    private static class PocketComputerUpgradeRecipeJsonAdapter
    implements RecipeJsonAdapter<PocketComputerUpgradeRecipe> {
        private PocketComputerUpgradeRecipeJsonAdapter() {
        }

        public PocketComputerUpgradeRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new PocketComputerUpgradeRecipe();
        }

        public JsonElement serialize(PocketComputerUpgradeRecipe src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", src.toString().replaceFirst("/*$", ""));
            obj.addProperty("type", Registries.RECIPE_TYPES.getKey(((Object)((Object)src)).getClass()));
            return obj;
        }
    }
}

