/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.recipe;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.adapter.RecipeCraftingShapedJsonAdapter;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerCrafting;

public class ImpostorShapedRecipe
extends RecipeEntryCraftingShaped
implements HasJsonAdapter {
    public ImpostorShapedRecipe(int recipeWidth, int recipeHeight, RecipeSymbol[] input, ItemStack output, boolean consumeContainerItem, boolean allowMirrored) {
        super(recipeWidth, recipeHeight, input, output, consumeContainerItem, allowMirrored);
    }

    public ImpostorShapedRecipe() {
    }

    public boolean matches(ContainerCrafting containerCrafting) {
        return false;
    }

    public RecipeJsonAdapter<?> getAdapter() {
        return new ImpostorShapedRecipeJsonAdapter();
    }

    private static class ImpostorShapedRecipeJsonAdapter
    implements RecipeJsonAdapter<ImpostorShapedRecipe> {
        private ImpostorShapedRecipeJsonAdapter() {
        }

        private static void convertUpgradeId(ItemStack result, String key) {
            if (result.getData().containsKey(key)) {
                String currentKey = result.getData().getString(key);
                Integer itemId = (Integer)Item.nameToIdMap.get(currentKey);
                if (itemId != null) {
                    result.getData().putInt(key, itemId.intValue());
                } else {
                    Integer blockId = (Integer)Blocks.keyToIdMap.get(currentKey);
                    if (blockId != null) {
                        result.getData().putInt(key, blockId.intValue());
                    }
                }
            }
        }

        public ImpostorShapedRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            RecipeEntryCraftingShaped recipeEntryCraftingShaped = new RecipeCraftingShapedJsonAdapter().deserialize(json, typeOfT, context);
            ItemStack result = (ItemStack)context.deserialize((JsonElement)obj.get("result").getAsJsonObject(), ItemStack.class);
            ImpostorShapedRecipeJsonAdapter.convertUpgradeId(result, "LeftUpgrade");
            ImpostorShapedRecipeJsonAdapter.convertUpgradeId(result, "RightUpgrade");
            ImpostorShapedRecipeJsonAdapter.convertUpgradeId(result, "Upgrade");
            return new ImpostorShapedRecipe(recipeEntryCraftingShaped.recipeWidth, recipeEntryCraftingShaped.recipeHeight, (RecipeSymbol[])recipeEntryCraftingShaped.getInput(), result, recipeEntryCraftingShaped.consumeContainerItem, recipeEntryCraftingShaped.allowMirrored);
        }

        public JsonElement serialize(ImpostorShapedRecipe src, Type typeOfSrc, JsonSerializationContext context) {
            return new RecipeCraftingShapedJsonAdapter().serialize((RecipeEntryCraftingShaped)src, typeOfSrc, context);
        }
    }
}

