/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.apis;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.event.TurtleEvent;
import dan200.computercraft.api.turtle.event.TurtleInspectItemEvent;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.asm.TaskCallback;
import dan200.computercraft.core.tracking.TrackingField;
import dan200.computercraft.shared.peripheral.generic.data.ItemData;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.MoveDirection;
import dan200.computercraft.shared.turtle.core.TurnDirection;
import dan200.computercraft.shared.turtle.core.TurtleCompareCommand;
import dan200.computercraft.shared.turtle.core.TurtleCompareToCommand;
import dan200.computercraft.shared.turtle.core.TurtleDetectCommand;
import dan200.computercraft.shared.turtle.core.TurtleDropCommand;
import dan200.computercraft.shared.turtle.core.TurtleEquipCommand;
import dan200.computercraft.shared.turtle.core.TurtleInspectCommand;
import dan200.computercraft.shared.turtle.core.TurtleMoveCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtleRefuelCommand;
import dan200.computercraft.shared.turtle.core.TurtleSuckCommand;
import dan200.computercraft.shared.turtle.core.TurtleToolCommand;
import dan200.computercraft.shared.turtle.core.TurtleTransferToCommand;
import dan200.computercraft.shared.turtle.core.TurtleTurnCommand;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.item.ItemStack;

public class TurtleAPI
implements ILuaAPI {
    private final IAPIEnvironment environment;
    private final ITurtleAccess turtle;

    public TurtleAPI(IAPIEnvironment environment, ITurtleAccess turtle) {
        this.environment = environment;
        this.turtle = turtle;
    }

    private static int checkCount(Optional<Integer> countArg) throws LuaException {
        int count = countArg.orElse(64);
        if (count < 0 || count > 64) {
            throw new LuaException("Item count " + count + " out of range");
        }
        return count;
    }

    private static int checkSlot(int slot) throws LuaException {
        if (slot < 1 || slot > 16) {
            throw new LuaException("Slot number " + slot + " out of range");
        }
        return slot - 1;
    }

    private static Optional<Integer> checkSlot(Optional<Integer> slot) throws LuaException {
        return slot.isPresent() ? Optional.of(TurtleAPI.checkSlot(slot.get())) : Optional.empty();
    }

    @Override
    public String[] getNames() {
        return new String[]{"turtle"};
    }

    @LuaFunction
    public final MethodResult forward() {
        return this.trackCommand(new TurtleMoveCommand(MoveDirection.FORWARD));
    }

    private MethodResult trackCommand(ITurtleCommand command) {
        this.environment.addTrackingChange(TrackingField.TURTLE_OPS);
        return this.turtle.executeCommand(command);
    }

    @LuaFunction
    public final MethodResult back() {
        return this.trackCommand(new TurtleMoveCommand(MoveDirection.BACK));
    }

    @LuaFunction
    public final MethodResult up() {
        return this.trackCommand(new TurtleMoveCommand(MoveDirection.UP));
    }

    @LuaFunction
    public final MethodResult down() {
        return this.trackCommand(new TurtleMoveCommand(MoveDirection.DOWN));
    }

    @LuaFunction
    public final MethodResult turnLeft() {
        return this.trackCommand(new TurtleTurnCommand(TurnDirection.LEFT));
    }

    @LuaFunction
    public final MethodResult turnRight() {
        return this.trackCommand(new TurtleTurnCommand(TurnDirection.RIGHT));
    }

    @LuaFunction
    public final MethodResult dig(Optional<TurtleSide> side) {
        this.environment.addTrackingChange(TrackingField.TURTLE_OPS);
        return this.trackCommand(TurtleToolCommand.dig(InteractDirection.FORWARD, side.orElse(null)));
    }

    @LuaFunction
    public final MethodResult digUp(Optional<TurtleSide> side) {
        this.environment.addTrackingChange(TrackingField.TURTLE_OPS);
        return this.trackCommand(TurtleToolCommand.dig(InteractDirection.UP, side.orElse(null)));
    }

    @LuaFunction
    public final MethodResult digDown(Optional<TurtleSide> side) {
        this.environment.addTrackingChange(TrackingField.TURTLE_OPS);
        return this.trackCommand(TurtleToolCommand.dig(InteractDirection.DOWN, side.orElse(null)));
    }

    @LuaFunction
    public final MethodResult place(IArguments args) {
        return this.trackCommand(new TurtlePlaceCommand(InteractDirection.FORWARD, args.getAll()));
    }

    @LuaFunction
    public final MethodResult placeUp(IArguments args) {
        return this.trackCommand(new TurtlePlaceCommand(InteractDirection.UP, args.getAll()));
    }

    @LuaFunction
    public final MethodResult placeDown(IArguments args) {
        return this.trackCommand(new TurtlePlaceCommand(InteractDirection.DOWN, args.getAll()));
    }

    @LuaFunction
    public final MethodResult drop(Optional<Integer> count) throws LuaException {
        return this.trackCommand(new TurtleDropCommand(InteractDirection.FORWARD, TurtleAPI.checkCount(count)));
    }

    @LuaFunction
    public final MethodResult dropUp(Optional<Integer> count) throws LuaException {
        return this.trackCommand(new TurtleDropCommand(InteractDirection.UP, TurtleAPI.checkCount(count)));
    }

    @LuaFunction
    public final MethodResult dropDown(Optional<Integer> count) throws LuaException {
        return this.trackCommand(new TurtleDropCommand(InteractDirection.DOWN, TurtleAPI.checkCount(count)));
    }

    @LuaFunction
    public final MethodResult select(int slot) throws LuaException {
        int actualSlot = TurtleAPI.checkSlot(slot);
        return this.turtle.executeCommand(turtle -> {
            turtle.setSelectedSlot(actualSlot);
            return TurtleCommandResult.success();
        });
    }

    @LuaFunction
    public final int getItemCount(Optional<Integer> slot) throws LuaException {
        int actualSlot = TurtleAPI.checkSlot(slot).orElse(this.turtle.getSelectedSlot());
        ItemStack item = this.turtle.getInventory().getItem(actualSlot);
        if (item == null) {
            return 0;
        }
        return item.stackSize;
    }

    @LuaFunction
    public final int getItemSpace(Optional<Integer> slot) throws LuaException {
        int actualSlot = TurtleAPI.checkSlot(slot).orElse(this.turtle.getSelectedSlot());
        ItemStack stack = this.turtle.getInventory().getItem(actualSlot);
        return stack == null ? 64 : Math.min(stack.getMaxStackSize(), 64) - stack.stackSize;
    }

    @LuaFunction
    public final MethodResult detect() {
        return this.trackCommand(new TurtleDetectCommand(InteractDirection.FORWARD));
    }

    @LuaFunction
    public final MethodResult detectUp() {
        return this.trackCommand(new TurtleDetectCommand(InteractDirection.UP));
    }

    @LuaFunction
    public final MethodResult detectDown() {
        return this.trackCommand(new TurtleDetectCommand(InteractDirection.DOWN));
    }

    @LuaFunction
    public final MethodResult compare() {
        return this.trackCommand(new TurtleCompareCommand(InteractDirection.FORWARD));
    }

    @LuaFunction
    public final MethodResult compareUp() {
        return this.trackCommand(new TurtleCompareCommand(InteractDirection.UP));
    }

    @LuaFunction
    public final MethodResult compareDown() {
        return this.trackCommand(new TurtleCompareCommand(InteractDirection.DOWN));
    }

    @LuaFunction
    public final MethodResult attack(Optional<TurtleSide> side) {
        return this.trackCommand(TurtleToolCommand.attack(InteractDirection.FORWARD, side.orElse(null)));
    }

    @LuaFunction
    public final MethodResult attackUp(Optional<TurtleSide> side) {
        return this.trackCommand(TurtleToolCommand.attack(InteractDirection.UP, side.orElse(null)));
    }

    @LuaFunction
    public final MethodResult attackDown(Optional<TurtleSide> side) {
        return this.trackCommand(TurtleToolCommand.attack(InteractDirection.DOWN, side.orElse(null)));
    }

    @LuaFunction
    public final MethodResult suck(Optional<Integer> count) throws LuaException {
        return this.trackCommand(new TurtleSuckCommand(InteractDirection.FORWARD, TurtleAPI.checkCount(count)));
    }

    @LuaFunction
    public final MethodResult suckUp(Optional<Integer> count) throws LuaException {
        return this.trackCommand(new TurtleSuckCommand(InteractDirection.UP, TurtleAPI.checkCount(count)));
    }

    @LuaFunction
    public final MethodResult suckDown(Optional<Integer> count) throws LuaException {
        return this.trackCommand(new TurtleSuckCommand(InteractDirection.DOWN, TurtleAPI.checkCount(count)));
    }

    @LuaFunction
    public final Object getFuelLevel() {
        return this.turtle.isFuelNeeded() ? Integer.valueOf(this.turtle.getFuelLevel()) : "unlimited";
    }

    @LuaFunction
    public final MethodResult refuel(Optional<Integer> countA) throws LuaException {
        int count = countA.orElse(Integer.MAX_VALUE);
        if (count < 0) {
            throw new LuaException("Refuel count " + count + " out of range");
        }
        return this.trackCommand(new TurtleRefuelCommand(count));
    }

    @LuaFunction
    public final MethodResult compareTo(int slot) throws LuaException {
        return this.trackCommand(new TurtleCompareToCommand(TurtleAPI.checkSlot(slot)));
    }

    @LuaFunction
    public final MethodResult transferTo(int slotArg, Optional<Integer> countArg) throws LuaException {
        int slot = TurtleAPI.checkSlot(slotArg);
        int count = TurtleAPI.checkCount(countArg);
        return this.trackCommand(new TurtleTransferToCommand(slot, count));
    }

    @LuaFunction
    public final int getSelectedSlot() {
        return this.turtle.getSelectedSlot() + 1;
    }

    @LuaFunction
    public final Object getFuelLimit() {
        return this.turtle.isFuelNeeded() ? Integer.valueOf(this.turtle.getFuelLimit()) : "unlimited";
    }

    @LuaFunction
    public final MethodResult equipLeft() {
        return this.trackCommand(new TurtleEquipCommand(TurtleSide.LEFT));
    }

    @LuaFunction
    public final MethodResult equipRight() {
        return this.trackCommand(new TurtleEquipCommand(TurtleSide.RIGHT));
    }

    @LuaFunction
    public final MethodResult inspect() {
        return this.trackCommand(new TurtleInspectCommand(InteractDirection.FORWARD));
    }

    @LuaFunction
    public final MethodResult inspectUp() {
        return this.trackCommand(new TurtleInspectCommand(InteractDirection.UP));
    }

    @LuaFunction
    public final MethodResult inspectDown() {
        return this.trackCommand(new TurtleInspectCommand(InteractDirection.DOWN));
    }

    @LuaFunction
    public final MethodResult getItemDetail(ILuaContext context, Optional<Integer> slot, Optional<Boolean> detailed) throws LuaException {
        int actualSlot = TurtleAPI.checkSlot(slot).orElse(this.turtle.getSelectedSlot());
        return detailed.orElse(false) != false ? TaskCallback.make(context, () -> this.getItemDetail(actualSlot, true)) : MethodResult.of(this.getItemDetail(actualSlot, false));
    }

    private Object[] getItemDetail(int slot, boolean detailed) {
        ItemStack stack = this.turtle.getInventory().getItem(slot);
        if (stack == null) {
            return new Object[]{null};
        }
        HashMap<String, Object> table = detailed ? ItemData.fill(new HashMap(), stack) : ItemData.fillBasicSafe(new HashMap(), stack);
        TurtleInspectItemEvent event = new TurtleInspectItemEvent(this.turtle, stack, table, detailed);
        if (TurtleEvent.post(event)) {
            return new Object[]{false, event.getFailureMessage()};
        }
        return new Object[]{table};
    }
}

