/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.computer.blocks.BlockLogicComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLogicTurtle
extends BlockLogicComputer {
    public BlockLogicTurtle(Block<?> block, ComputerFamily family) {
        super(block, family);
        block.withEntity(() -> new TileTurtle(family));
        this.setBlockBounds(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
    }

    public boolean isCubeShaped() {
        return false;
    }

    public boolean isSolidRender() {
        return false;
    }

    public AABB getBlockBoundsFromState(WorldSource world, int x, int y, int z) {
        return AABB.getPermanentBB((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
    }

    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side side, Mob mob, double xPlaced, double yPlaced) {
        ServerComputer computer;
        Direction direction = mob.getHorizontalPlacementDirection(side);
        world.setBlockMetadataWithNotify(x, y, z, direction.getId());
        TileEntity entity = world.getTileEntity(x, y, z);
        if (!(entity instanceof TileTurtle)) {
            return;
        }
        TileTurtle turtle = (TileTurtle)entity;
        turtle.setDirection(direction);
        turtle.carriedBlock = null;
        if (!Helper.isClientWorld() && (computer = turtle.getServerComputer()) != null) {
            computer.setWorld(world);
        }
    }

    public float getBlastResistance(Entity entity) {
        return 2000.0f;
    }

    @Override
    protected ItemStack getItemStack(TileEntity entity) {
        if (!(entity instanceof TileTurtle)) {
            return null;
        }
        return TurtleItemFactory.create((TileTurtle)entity);
    }
}

