/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.fabric.IComputerPlayer;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.inventory.ContainerComputer;
import dan200.computercraft.shared.network.client.TurtleBrainClientMessage;
import dan200.computercraft.shared.turtle.apis.TurtleAPI;
import dan200.computercraft.shared.turtle.blocks.BlockLogicTurtle;
import dan200.computercraft.shared.turtle.blocks.ITurtleTile;
import dan200.computercraft.shared.turtle.blocks.MoveState;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.motion.CarriedBlock;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketTileEntityData;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.helper.network.NetworkMessage;

public class TileTurtle
extends TileComputerBase
implements ITurtleTile,
Container {
    public static final int INVENTORY_SIZE = 16;
    public static final int INVENTORY_WIDTH = 4;
    public static final int INVENTORY_HEIGHT = 4;
    public final List<@Nullable ItemStack> inventory = new ArrayList<Object>(Collections.nCopies(16, null));
    private final List<ItemStack> previousInventory = new ArrayList<Object>(Collections.nCopies(16, null));
    private boolean inventoryChanged = false;
    private TurtleBrain brain = new TurtleBrain(this);
    private MoveState moveState = MoveState.NOT_MOVED;

    public TileTurtle() {
        super(ComputerFamily.NORMAL);
    }

    public TileTurtle(ComputerFamily family) {
        super(family);
    }

    @Override
    protected void unload() {
        if (!this.hasMoved()) {
            super.unload();
        }
    }

    @Override
    public void destroy() {
        block3: {
            block2: {
                if (this.hasMoved()) break block2;
                super.destroy();
                if (Helper.isClientWorld()) break block3;
                int size = this.inventory.size();
                for (int i = 0; i < size; ++i) {
                    ItemStack stack = this.getItem(i);
                    if (stack == null) continue;
                    WorldUtil.dropItemStack(stack, this.worldObj, this.getPos());
                }
                break block3;
            }
            for (Direction dir : DirectionUtil.FACINGS) {
                RedstoneUtil.propagateRedstoneOutput(this.worldObj, this.getPos(), dir);
            }
        }
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    private boolean hasMoved() {
        return this.moveState == MoveState.MOVED;
    }

    public int getContainerSize() {
        return 16;
    }

    @Nullable
    public ItemStack getItem(int slot) {
        return slot >= 0 && slot < 16 ? this.inventory.get(slot) : null;
    }

    @Nullable
    public ItemStack removeItem(int slot, int count) {
        if (count == 0) {
            return null;
        }
        ItemStack stack = this.getItem(slot);
        if (stack == null) {
            return null;
        }
        if (stack.stackSize <= count) {
            this.setItem(slot, null);
            return stack;
        }
        ItemStack part = stack.splitStack(count);
        this.onInventoryDefinitelyChanged();
        return part;
    }

    public void setItem(int i, @Nullable ItemStack stack) {
        if (i >= 0 && i < 16 && !InventoryUtil.areItemsEqual(stack, this.inventory.get(i))) {
            this.inventory.set(i, stack);
            this.onInventoryDefinitelyChanged();
        }
    }

    public String getNameTranslationKey() {
        return "";
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean stillValid(Player player) {
        return this.isUsable(player, false);
    }

    public void sortContainer() {
    }

    private void onInventoryDefinitelyChanged() {
        this.inventoryChanged = true;
    }

    @Override
    public boolean onBlockRightClicked(Player player, Side side, double xPlaced, double yPlaced) {
        ItemStack currentItem = player.getHeldItem();
        if (currentItem != null) {
            if (currentItem.getItem() instanceof ItemDye) {
                if (!Helper.isClientWorld()) {
                    DyeColor dye = DyeColor.colorFromItemMeta((int)currentItem.getMetadata());
                    if (this.brain.getDyeColour() != dye) {
                        this.brain.setDyeColour(dye);
                        if (player.gamemode != Gamemode.creative) {
                            --currentItem.stackSize;
                            if (currentItem.stackSize == 0) {
                                player.setHeldObject(null);
                            }
                        }
                    }
                }
                return true;
            }
            if (currentItem.getItem().equals(Items.BUCKET_WATER) && this.brain.getColour() != -1) {
                if (!Helper.isClientWorld() && this.brain.getColour() != -1) {
                    this.brain.setColour(-1);
                    if (player.gamemode != Gamemode.creative) {
                        // empty if block
                    }
                }
                return true;
            }
        }
        if (!Helper.isClientWorld() && this.isUsable(player, false)) {
            this.createServerComputer().turnOn();
            this.createServerComputer().sendTerminalState(player);
            ((IComputerPlayer)player).setCurrentContainerComputer(new ContainerComputer(this));
            this.createServerComputer().sendOpenGuiTurtle(player, this);
        }
        return true;
    }

    @Override
    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.onNeighbourChange(neighbour);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.brain.update();
        if (!Helper.isClientWorld() && this.inventoryChanged) {
            ServerComputer computer = this.getServerComputer();
            if (computer != null) {
                computer.queueEvent("turtle_inventory");
            }
            this.inventoryChanged = false;
            for (int n = 0; n < this.inventory.size(); ++n) {
                ItemStack item = this.getItem(n);
                this.previousInventory.set(n, item != null ? item.copy() : null);
            }
        }
    }

    @Override
    @Environment(value=EnvType.SERVER)
    protected void updateBlockServer() {
        NetworkHandler.sendToAllAround((double)this.x, (double)this.y, (double)this.z, (double)64.0, (int)this.worldObj.dimension.id, (NetworkMessage)new TurtleBrainClientMessage(this.getPos(), this.brain));
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
    }

    @Override
    public void writeToNBT(CompoundTag nbt) {
        ListTag nbttaglist = new ListTag();
        for (int i = 0; i < 16; ++i) {
            ItemStack item = this.inventory.get(i);
            if (item != null) {
                CompoundTag tag = new CompoundTag();
                tag.putByte("Slot", (byte)i);
                item.writeToNBT(tag);
                nbttaglist.addTag((Tag)tag);
                continue;
            }
            this.inventory.set(i, null);
        }
        nbt.put("Items", (Tag)nbttaglist);
        nbt = this.brain.writeToNBT(nbt);
        super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        ListTag nbttaglist = nbt.getList("Items");
        this.inventory.replaceAll(ignored -> null);
        this.previousInventory.replaceAll(ignored -> null);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            CompoundTag tag = (CompoundTag)nbttaglist.tagAt(i);
            int slot = tag.getByte("Slot") & 0xFF;
            if (slot >= this.inventory.size()) continue;
            this.inventory.set(slot, ItemStack.readItemStackFromNbt((CompoundTag)tag));
            ItemStack item = this.inventory.get(slot);
            this.previousInventory.set(slot, item != null ? item.copy() : null);
        }
        this.brain.readFromNBT(nbt);
    }

    public Packet getDescriptionPacket() {
        return new PacketTileEntityData((TileEntity)this);
    }

    @Override
    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return this.hasPeripheralUpgradeOnSide(localSide);
    }

    @Override
    public Direction getDirection() {
        return BlockLogicTurtle.getDirectionFromMeta((int)this.getBlockMeta());
    }

    public void setDirection(Direction dir) {
        if (dir.getAxis() == Axis.Y) {
            dir = Direction.NORTH;
        }
        int currentMetadata = this.getBlockMeta();
        this.worldObj.setBlockMetadata(this.x, this.y, this.z, BlockLogicTurtle.setDirection((int)currentMetadata, (Direction)dir));
        this.updateRedstoneOutput();
        this.updateRedstoneInput();
        this.onTileEntityChange();
    }

    @Override
    protected ServerComputer createComputer(int instanceID, int id) {
        ServerComputer computer = new ServerComputer(this.worldObj, id, this.label, instanceID, this.getFamily(), 39, 13);
        computer.setPosition(this.getPos());
        computer.addAPI(new TurtleAPI(computer.getAPIEnvironment(), this.getAccess()));
        this.brain.setupComputer(computer);
        return computer;
    }

    @Override
    public void writeDescription(@Nonnull CompoundTag nbt) {
        super.writeDescription(nbt);
        this.brain.writeDescription(nbt);
    }

    @Override
    public void readDescription(@Nonnull CompoundTag nbt) {
        super.readDescription(nbt);
        this.brain.readDescription(nbt);
    }

    @Override
    public ComputerProxy createProxy() {
        return this.brain.getProxy();
    }

    public void onTileEntityChange() {
        this.worldObj.notifyBlockChange(this.x, this.y, this.z, this.getBlockId());
    }

    private boolean hasPeripheralUpgradeOnSide(ComputerSide side) {
        ITurtleUpgrade upgrade;
        switch (side) {
            case RIGHT: {
                upgrade = this.getUpgrade(TurtleSide.RIGHT);
                break;
            }
            case LEFT: {
                upgrade = this.getUpgrade(TurtleSide.LEFT);
                break;
            }
            default: {
                return false;
            }
        }
        return upgrade != null && upgrade.getType().isPeripheral();
    }

    @Override
    protected double getInteractRange(Player player) {
        return 12.0;
    }

    public void notifyMoveStart() {
        if (this.moveState == MoveState.NOT_MOVED) {
            this.moveState = MoveState.IN_PROGRESS;
        }
    }

    public void notifyMoveEnd() {
        if (this.moveState == MoveState.IN_PROGRESS) {
            this.moveState = MoveState.NOT_MOVED;
        }
    }

    @Override
    public int getColour() {
        return this.brain.getColour();
    }

    @Override
    public int getOverlay() {
        return this.brain.getOverlay();
    }

    @Override
    public ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.brain.getUpgrade(side);
    }

    @Override
    public ITurtleAccess getAccess() {
        return this.brain;
    }

    @Override
    public Vec3 getRenderOffset(float f) {
        return this.brain.getRenderOffset(f);
    }

    @Override
    public float getRenderYaw(float f) {
        return this.brain.getVisualYaw(f);
    }

    @Override
    public float getToolRenderAngle(TurtleSide side, float f) {
        return this.brain.getToolRenderAngle(side, f);
    }

    public void setOwningPlayer(UUID player) {
        this.brain.setOwningPlayer(player);
        this.markDirty();
    }

    public void markDirty() {
        if (!this.inventoryChanged) {
            for (int n = 0; n < this.inventory.size(); ++n) {
                if (ItemStack.areItemStacksEqual((ItemStack)this.getItem(n), (ItemStack)this.previousInventory.get(n))) continue;
                this.inventoryChanged = true;
                break;
            }
        }
    }

    public void clear() {
        boolean changed = false;
        for (int i = 0; i < 16; ++i) {
            if (this.inventory.get(i) == null) continue;
            this.inventory.set(i, null);
            changed = true;
        }
        if (changed) {
            this.onInventoryDefinitelyChanged();
        }
    }

    public void transferStateFrom(TileTurtle copy) {
        Collections.copy(this.inventory, copy.inventory);
        Collections.copy(this.previousInventory, copy.previousInventory);
        this.inventoryChanged = copy.inventoryChanged;
        this.brain = copy.brain;
        this.brain.setOwner(this);
    }

    public void updateBrainFromNBT(CompoundTag tag) {
        this.brain.readFromNBT(tag);
    }

    public boolean canBeCarried(World world, Entity potentialHolder) {
        return !this.brain.isRunningAnimation();
    }

    public CarriedBlock getCarriedEntry(World world, Entity holder, Block<?> currentBlock, int currentMeta) {
        return super.getCarriedEntry(world, holder, currentBlock, BlockLogicTurtle.setDirection((int)currentMeta, (Direction)Direction.NORTH));
    }
}

