/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.google.common.base.Objects;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleCommandQueueEntry;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.Holiday;
import dan200.computercraft.shared.util.HolidayUtil;
import dan200.computercraft.shared.util.PortableTickScheduler;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkPosition;

public class TurtleBrain
implements ITurtleAccess {
    public static final String NBT_RIGHT_UPGRADE = "RightUpgrade";
    public static final String NBT_RIGHT_UPGRADE_DATA = "RightUpgradeNbt";
    public static final String NBT_LEFT_UPGRADE = "LeftUpgrade";
    public static final String NBT_LEFT_UPGRADE_DATA = "LeftUpgradeNbt";
    public static final String NBT_FUEL = "Fuel";
    public static final String NBT_OVERLAY = "Overlay";
    public static final String NBT_ANIMATION = "Animation";
    private static final String NBT_SLOT = "Slot";
    private static final int ANIM_DURATION = 8;
    private final Queue<TurtleCommandQueueEntry> commandQueue = new ArrayDeque<TurtleCommandQueueEntry>();
    private final Map<TurtleSide, ITurtleUpgrade> upgrades = new EnumMap<TurtleSide, ITurtleUpgrade>(TurtleSide.class);
    private final Map<TurtleSide, IPeripheral> peripherals = new EnumMap<TurtleSide, IPeripheral>(TurtleSide.class);
    private final Map<TurtleSide, CompoundTag> upgradeNBTData = new EnumMap<TurtleSide, CompoundTag>(TurtleSide.class);
    private TileTurtle owner;
    private ComputerProxy proxy;
    private UUID owningPlayer;
    private int commandsIssued = 0;
    private int selectedSlot = 0;
    private int fuelLevel = 0;
    private int colourHex = -1;
    private int overlay = -1;
    private TurtleAnimation animation = TurtleAnimation.NONE;
    private int animationProgress = 0;
    private int lastAnimationProgress = 0;

    public TurtleBrain(TileTurtle turtle) {
        this.owner = turtle;
    }

    private static ComputerSide toDirection(TurtleSide side) {
        switch (side) {
            case LEFT: {
                return ComputerSide.LEFT;
            }
        }
        return ComputerSide.RIGHT;
    }

    private static int getUpgradeId(ITurtleUpgrade upgrade) {
        return upgrade != null ? upgrade.getUpgradeID() : -1;
    }

    public TileTurtle getOwner() {
        return this.owner;
    }

    public void setOwner(TileTurtle owner) {
        this.owner = owner;
    }

    public ComputerProxy getProxy() {
        if (this.proxy == null) {
            this.proxy = new ComputerProxy(() -> this.owner);
        }
        return this.proxy;
    }

    public ComputerFamily getFamily() {
        return this.owner.getFamily();
    }

    public void setupComputer(ServerComputer computer) {
        this.updatePeripherals(computer);
    }

    private void updatePeripherals(ServerComputer serverComputer) {
        if (serverComputer == null) {
            return;
        }
        for (TurtleSide side : TurtleSide.values()) {
            IPeripheral existing;
            ITurtleUpgrade upgrade = this.getUpgrade(side);
            IPeripheral peripheral = null;
            if (upgrade != null && upgrade.getType().isPeripheral()) {
                peripheral = upgrade.createPeripheral(this, side);
            }
            if ((existing = this.peripherals.get((Object)side)) == peripheral || existing != null && peripheral != null && existing.equals(peripheral)) {
                peripheral = existing;
            } else {
                this.peripherals.put(side, peripheral);
            }
            serverComputer.setPeripheral(TurtleBrain.toDirection(side), peripheral);
        }
    }

    public void update() {
        World world = this.getWorld();
        if (!Helper.isClientWorld()) {
            this.updateCommands();
            if (this.owner.isInvalid()) {
                return;
            }
        }
        this.updateAnimation();
        if (!this.upgrades.isEmpty()) {
            for (Map.Entry<TurtleSide, ITurtleUpgrade> entry : this.upgrades.entrySet()) {
                entry.getValue().update(this, entry.getKey());
            }
        }
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.owner.worldObj;
    }

    @Override
    @Nonnull
    public BlockPos getPosition() {
        return new BlockPos(this.owner.x, this.owner.y, this.owner.z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean teleportTo(@Nonnull World world, @Nonnull BlockPos pos) {
        if (Helper.isClientWorld()) {
            throw new UnsupportedOperationException("Cannot teleport on the client");
        }
        World oldWorld = this.getWorld();
        BlockPos oldPos = this.owner.getPos();
        if (oldWorld == world && oldPos.equals(pos)) {
            return true;
        }
        if (!world.isChunkLoaded(Math.floorDiv(pos.x, 16), Math.floorDiv(pos.z, 16))) {
            return false;
        }
        this.owner.notifyMoveStart();
        try {
            if (world.setBlockAndMetadataRaw(pos.x, pos.y, pos.z, this.owner.getBlockId(), this.owner.getBlockMeta())) {
                TileEntity newTile = world.getTileEntity(pos.x, pos.y, pos.z);
                if (newTile instanceof TileTurtle) {
                    newTile.invalidate();
                    world.removeBlockTileEntity(oldPos.x, oldPos.y, oldPos.z);
                    world.setBlockRaw(oldPos.x, oldPos.y, oldPos.z, 0);
                    world.notifyBlockChange(oldPos.x, oldPos.y, oldPos.z, 0);
                    this.owner.validate();
                    this.owner.x = pos.x;
                    this.owner.y = pos.y;
                    this.owner.z = pos.z;
                    world.removeBlockTileEntity(pos.x, pos.y, pos.z);
                    world.setTileEntity(pos.x, pos.y, pos.z, (TileEntity)this.owner);
                    this.owner.transferStateFrom(this.owner);
                    this.owner.createServerComputer().setWorld(world);
                    this.owner.createServerComputer().setPosition(pos);
                    this.owner.updateBlock();
                    this.owner.updateRedstoneInput();
                    this.owner.updateRedstoneOutput();
                    this.owner.notifyMoveEnd();
                    Chunk oldChunk = world.getChunkFromChunkCoords(Math.floorDiv(oldPos.x, 16), Math.floorDiv(oldPos.z, 16));
                    if (oldChunk != null && oldChunk.isLoaded && this.owner != null && oldChunk.tileEntityMap.containsValue(this.owner)) {
                        oldChunk.tileEntityMap.remove(new ChunkPosition(oldPos.x & 0xF, oldPos.y, oldPos.z & 0xF));
                    }
                    if (!Helper.isServerEnvironment()) {
                        PortableTickScheduler.mainPortableTickScheduler.scheduleOnNextEndTick(() -> {
                            if (!Minecraft.getMinecraft().renderGlobal.tileEntities.contains(this.owner)) {
                                Minecraft.getMinecraft().renderGlobal.tileEntities.add(this.owner);
                            }
                        });
                        PortableTickScheduler.mainPortableTickScheduler.scheduleOnNextStartTick(() -> {
                            if (!Minecraft.getMinecraft().renderGlobal.tileEntities.contains(this.owner)) {
                                Minecraft.getMinecraft().renderGlobal.tileEntities.add(this.owner);
                            }
                        });
                        PortableTickScheduler.mainPortableTickScheduler.scheduleStartTick(() -> {
                            if (!Minecraft.getMinecraft().renderGlobal.tileEntities.contains(this.owner)) {
                                Minecraft.getMinecraft().renderGlobal.tileEntities.add(this.owner);
                            }
                        }, 2);
                    }
                    boolean bl = true;
                    return bl;
                }
                oldWorld.setBlock(pos.x, pos.y, pos.z, 0);
            }
        }
        finally {
            this.owner.notifyMoveEnd();
        }
        return false;
    }

    @Override
    @Nonnull
    public Vec3 getVisualPosition(float f) {
        return this.getRenderOffset(f);
    }

    @Override
    public float getVisualYaw(float f) {
        float yaw = DirectionUtil.getRotationYaw(this.getDirection());
        switch (this.animation) {
            case TURN_LEFT: {
                yaw += 90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw >= 360.0f)) break;
                yaw -= 360.0f;
                break;
            }
            case TURN_RIGHT: {
                yaw += -90.0f * (1.0f - this.getAnimationFraction(f));
                if (!(yaw < 0.0f)) break;
                yaw += 360.0f;
            }
        }
        return yaw;
    }

    @Override
    @Nonnull
    public Direction getDirection() {
        return this.owner.getDirection();
    }

    @Override
    public void setDirection(@Nonnull Direction dir) {
        this.owner.setDirection(dir);
    }

    @Override
    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public void setSelectedSlot(int slot) {
        if (Helper.isClientWorld()) {
            throw new UnsupportedOperationException("Cannot set the slot on the client");
        }
        if (slot >= 0 && slot < this.owner.inventory.size()) {
            this.selectedSlot = slot;
            this.owner.onTileEntityChange();
        }
    }

    @Override
    public int getColour() {
        return this.colourHex;
    }

    @Override
    public void setColour(int colour) {
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (this.colourHex != colour) {
                this.colourHex = colour;
                this.owner.updateBlock();
            }
        } else if (this.colourHex != -1) {
            this.colourHex = -1;
            this.owner.updateBlock();
        }
    }

    @Override
    @Nullable
    public UUID getOwningPlayer() {
        return this.owningPlayer;
    }

    public void setOwningPlayer(UUID profile) {
        this.owningPlayer = profile;
    }

    @Override
    public boolean isFuelNeeded() {
        return ComputerCraft.turtlesNeedFuel;
    }

    @Override
    public int getFuelLevel() {
        return Math.min(this.fuelLevel, this.getFuelLimit());
    }

    @Override
    public void setFuelLevel(int level) {
        this.fuelLevel = Math.min(level, this.getFuelLimit());
        this.owner.onTileEntityChange();
    }

    @Override
    public int getFuelLimit() {
        if (this.owner.getFamily() == ComputerFamily.ADVANCED) {
            return ComputerCraft.advancedTurtleFuelLimit;
        }
        return ComputerCraft.turtleFuelLimit;
    }

    @Override
    public boolean consumeFuel(int fuel) {
        if (Helper.isClientWorld()) {
            throw new UnsupportedOperationException("Cannot consume fuel on the client");
        }
        if (!this.isFuelNeeded()) {
            return true;
        }
        int consumption = Math.max(fuel, 0);
        if (this.getFuelLevel() >= consumption) {
            this.setFuelLevel(this.getFuelLevel() - consumption);
            return true;
        }
        return false;
    }

    @Override
    public void addFuel(int fuel) {
        if (Helper.isClientWorld()) {
            throw new UnsupportedOperationException("Cannot add fuel on the client");
        }
        int addition = Math.max(fuel, 0);
        this.setFuelLevel(this.getFuelLevel() + addition);
    }

    @Override
    @Nonnull
    public MethodResult executeCommand(@Nonnull ITurtleCommand command) {
        if (Helper.isClientWorld()) {
            throw new UnsupportedOperationException("Cannot run commands on the client");
        }
        int commandID = this.issueCommand(command);
        return new CommandCallback((int)commandID).pull;
    }

    private int issueCommand(ITurtleCommand command) {
        this.commandQueue.offer(new TurtleCommandQueueEntry(++this.commandsIssued, command));
        return this.commandsIssued;
    }

    @Override
    public void playAnimation(@Nonnull TurtleAnimation animation) {
        if (Helper.isClientWorld()) {
            throw new UnsupportedOperationException("Cannot play animations on the client");
        }
        this.animation = animation;
        if (this.animation == TurtleAnimation.SHORT_WAIT) {
            this.animationProgress = 4;
            this.lastAnimationProgress = 4;
        } else {
            this.animationProgress = 0;
            this.lastAnimationProgress = 0;
        }
        this.owner.updateBlock();
    }

    @Override
    public ITurtleUpgrade getUpgrade(@Nonnull TurtleSide side) {
        return this.upgrades.get((Object)side);
    }

    @Override
    public void setUpgrade(@Nonnull TurtleSide side, ITurtleUpgrade upgrade) {
        if (this.upgrades.containsKey((Object)side)) {
            if (this.upgrades.get((Object)side) == upgrade) {
                return;
            }
            this.upgrades.remove((Object)side);
        } else if (upgrade == null) {
            return;
        }
        this.upgradeNBTData.remove((Object)side);
        if (upgrade != null) {
            this.upgrades.put(side, upgrade);
        }
        if (this.owner.worldObj != null) {
            this.updatePeripherals(this.owner.createServerComputer());
            this.owner.updateBlock();
        }
    }

    @Override
    public IPeripheral getPeripheral(@Nonnull TurtleSide side) {
        return this.peripherals.get((Object)side);
    }

    @Override
    @Nonnull
    public CompoundTag getUpgradeNBTData(TurtleSide side) {
        CompoundTag nbt = this.upgradeNBTData.get((Object)side);
        if (nbt == null) {
            nbt = new CompoundTag();
            this.upgradeNBTData.put(side, nbt);
        }
        return nbt;
    }

    @Override
    public void updateUpgradeNBTData(@Nonnull TurtleSide side) {
        this.owner.updateBlock();
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.owner;
    }

    private void updateCommands() {
        if (this.animation != TurtleAnimation.NONE || this.commandQueue.isEmpty()) {
            return;
        }
        ServerComputer computer = this.owner.getServerComputer();
        if (computer != null && !computer.getComputer().getMainThreadMonitor().canWork()) {
            return;
        }
        TurtleCommandQueueEntry nextCommand = this.commandQueue.poll();
        if (nextCommand == null) {
            return;
        }
        long start = System.nanoTime();
        TurtleCommandResult result = nextCommand.command.execute(this);
        long end = System.nanoTime();
        if (computer == null) {
            return;
        }
        computer.getComputer().getMainThreadMonitor().trackWork(end - start, TimeUnit.NANOSECONDS);
        int callbackID = nextCommand.callbackID;
        if (callbackID < 0) {
            return;
        }
        if (result != null && result.isSuccess()) {
            Object[] results = result.getResults();
            if (results != null) {
                Object[] arguments = new Object[results.length + 2];
                arguments[0] = callbackID;
                arguments[1] = true;
                System.arraycopy(results, 0, arguments, 2, results.length);
                computer.queueEvent("turtle_response", arguments);
            } else {
                computer.queueEvent("turtle_response", new Object[]{callbackID, true});
            }
        } else {
            computer.queueEvent("turtle_response", new Object[]{callbackID, false, result != null ? result.getErrorMessage() : null});
        }
    }

    private void updateAnimation() {
        if (this.animation != TurtleAnimation.NONE) {
            Vec3 position;
            Holiday currentHoliday;
            World world = this.getWorld();
            if (ComputerCraft.turtlesCanPush && (this.animation == TurtleAnimation.MOVE_FORWARD || this.animation == TurtleAnimation.MOVE_BACK || this.animation == TurtleAnimation.MOVE_UP || this.animation == TurtleAnimation.MOVE_DOWN)) {
                Direction moveDir;
                BlockPos pos = this.getPosition();
                switch (this.animation) {
                    default: {
                        moveDir = this.getDirection();
                        break;
                    }
                    case MOVE_BACK: {
                        moveDir = this.getDirection().getOpposite();
                        break;
                    }
                    case MOVE_UP: {
                        moveDir = Direction.UP;
                        break;
                    }
                    case MOVE_DOWN: {
                        moveDir = Direction.DOWN;
                    }
                }
                double minX = pos.getX();
                double minY = pos.getY();
                double minZ = pos.getZ();
                double maxX = minX + 1.0;
                double maxY = minY + 1.0;
                double maxZ = minZ + 1.0;
                float pushFrac = 1.0f - (float)(this.animationProgress + 1) / 8.0f;
                float push = Math.max(pushFrac + 0.0125f, 0.0f);
                if (moveDir.getOffsetX() < 0) {
                    minX += (double)((float)moveDir.getOffsetX() * push);
                } else {
                    maxX -= (double)((float)moveDir.getOffsetX() * push);
                }
                if (moveDir.getOffsetY() < 0) {
                    minY += (double)((float)moveDir.getOffsetY() * push);
                } else {
                    maxY -= (double)((float)moveDir.getOffsetY() * push);
                }
                if (moveDir.getOffsetZ() < 0) {
                    minZ += (double)((float)moveDir.getOffsetZ() * push);
                } else {
                    maxZ -= (double)((float)moveDir.getOffsetZ() * push);
                }
                AABB aabb = AABB.getPermanentBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
                List list = world.getEntitiesWithinAABB(Entity.class, aabb);
                if (!list.isEmpty()) {
                    double pushStep = 0.125;
                    double pushStepX = (double)moveDir.getOffsetX() * pushStep;
                    double pushStepY = (double)moveDir.getOffsetY() * pushStep;
                    double pushStepZ = (double)moveDir.getOffsetZ() * pushStep;
                    for (Entity entity : list) {
                        entity.move(pushStepX, pushStepY, pushStepZ);
                    }
                }
            }
            if (Helper.isClientWorld() && this.animation == TurtleAnimation.MOVE_FORWARD && this.animationProgress == 4 && (currentHoliday = HolidayUtil.getCurrentHoliday()) == Holiday.VALENTINES && (position = this.getVisualPosition(1.0f)) != null) {
                double x = position.x + world.rand.nextGaussian() * 0.1;
                double y = position.y + 0.5 + world.rand.nextGaussian() * 0.1;
                double z = position.z + world.rand.nextGaussian() * 0.1;
                world.spawnParticle("heart", x, y, z, world.rand.nextGaussian() * 0.02, world.rand.nextGaussian() * 0.02, world.rand.nextGaussian() * 0.02, 0);
            }
            this.lastAnimationProgress = this.animationProgress++;
            if (this.animationProgress >= 8) {
                this.animation = TurtleAnimation.NONE;
                this.animationProgress = 0;
                this.lastAnimationProgress = 0;
            }
        }
    }

    public Vec3 getRenderOffset(float f) {
        switch (this.animation) {
            case MOVE_FORWARD: 
            case MOVE_BACK: 
            case MOVE_UP: 
            case MOVE_DOWN: {
                Direction dir;
                switch (this.animation) {
                    default: {
                        dir = this.getDirection();
                        break;
                    }
                    case MOVE_BACK: {
                        dir = this.getDirection().getOpposite();
                        break;
                    }
                    case MOVE_UP: {
                        dir = Direction.UP;
                        break;
                    }
                    case MOVE_DOWN: {
                        dir = Direction.DOWN;
                    }
                }
                double distance = -1.0 + (double)this.getAnimationFraction(f);
                return Vec3.getPermanentVec3((double)(distance * (double)dir.getOffsetX()), (double)(distance * (double)dir.getOffsetY()), (double)(distance * (double)dir.getOffsetZ()));
            }
        }
        return Vec3.getPermanentVec3((double)0.0, (double)0.0, (double)0.0);
    }

    private float getAnimationFraction(float f) {
        float next = (float)this.animationProgress / 8.0f;
        float previous = (float)this.lastAnimationProgress / 8.0f;
        return previous + (next - previous) * f;
    }

    public void readFromNBT(CompoundTag nbt) {
        this.readCommon(nbt);
        this.selectedSlot = nbt.getInteger(NBT_SLOT);
        if (nbt.containsKey("Owner")) {
            CompoundTag owner = nbt.getCompound("Owner");
            this.owningPlayer = new UUID(owner.getLong("UpperId"), owner.getLong("LowerId"));
        } else {
            this.owningPlayer = null;
        }
        this.animation = TurtleAnimation.values()[nbt.getInteger(NBT_ANIMATION)];
    }

    private void readCommon(CompoundTag nbt) {
        this.colourHex = nbt.containsKey("Color") ? nbt.getInteger("Color") : -1;
        this.fuelLevel = nbt.containsKey(NBT_FUEL) ? nbt.getInteger(NBT_FUEL) : 0;
        this.overlay = nbt.containsKey(NBT_OVERLAY) ? nbt.getInteger(NBT_OVERLAY) : -1;
        this.setUpgrade(TurtleSide.LEFT, nbt.containsKey(NBT_LEFT_UPGRADE) ? TurtleUpgrades.get(nbt.getInteger(NBT_LEFT_UPGRADE)) : null);
        this.setUpgrade(TurtleSide.RIGHT, nbt.containsKey(NBT_RIGHT_UPGRADE) ? TurtleUpgrades.get(nbt.getInteger(NBT_RIGHT_UPGRADE)) : null);
        this.upgradeNBTData.clear();
        if (nbt.containsKey(NBT_LEFT_UPGRADE_DATA)) {
            this.upgradeNBTData.put(TurtleSide.LEFT, nbt.getCompound(NBT_LEFT_UPGRADE_DATA));
        }
        if (nbt.containsKey(NBT_RIGHT_UPGRADE_DATA)) {
            this.upgradeNBTData.put(TurtleSide.RIGHT, nbt.getCompound(NBT_RIGHT_UPGRADE_DATA));
        }
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        this.writeCommon(nbt);
        nbt.putInt(NBT_SLOT, this.selectedSlot);
        if (this.owningPlayer != null) {
            CompoundTag owner = new CompoundTag();
            nbt.put("Owner", (Tag)owner);
            owner.putLong("UpperId", this.owningPlayer.getMostSignificantBits());
            owner.putLong("LowerId", this.owningPlayer.getLeastSignificantBits());
        }
        nbt.putInt(NBT_ANIMATION, this.animation.ordinal());
        return nbt;
    }

    private void writeCommon(CompoundTag nbt) {
        int rightUpgradeId;
        int leftUpgradeId;
        nbt.putInt(NBT_FUEL, this.fuelLevel);
        if (this.colourHex != -1) {
            nbt.putInt("Color", this.colourHex);
        }
        if (this.overlay != -1) {
            nbt.putInt(NBT_OVERLAY, this.overlay);
        }
        if ((leftUpgradeId = TurtleBrain.getUpgradeId(this.getUpgrade(TurtleSide.LEFT))) != -1) {
            nbt.putInt(NBT_LEFT_UPGRADE, leftUpgradeId);
        }
        if ((rightUpgradeId = TurtleBrain.getUpgradeId(this.getUpgrade(TurtleSide.RIGHT))) != -1) {
            nbt.putInt(NBT_RIGHT_UPGRADE, rightUpgradeId);
        }
        if (this.upgradeNBTData.containsKey((Object)TurtleSide.LEFT)) {
            nbt.put(NBT_LEFT_UPGRADE_DATA, (Tag)this.getUpgradeNBTData(TurtleSide.LEFT));
        }
        if (this.upgradeNBTData.containsKey((Object)TurtleSide.RIGHT)) {
            nbt.put(NBT_RIGHT_UPGRADE_DATA, (Tag)this.getUpgradeNBTData(TurtleSide.RIGHT));
        }
    }

    public void readDescription(CompoundTag nbt) {
        this.readCommon(nbt);
        TurtleAnimation anim = TurtleAnimation.values()[nbt.getInteger(NBT_ANIMATION)];
        if (anim != this.animation && anim != TurtleAnimation.WAIT && anim != TurtleAnimation.SHORT_WAIT && anim != TurtleAnimation.NONE) {
            this.animation = anim;
            this.animationProgress = 0;
            this.lastAnimationProgress = 0;
        }
    }

    public void writeDescription(CompoundTag nbt) {
        this.writeCommon(nbt);
        nbt.putInt(NBT_ANIMATION, this.animation.ordinal());
    }

    public int getOverlay() {
        return this.overlay;
    }

    public void setOverlay(int overlay) {
        if (!Objects.equal(this.overlay, overlay)) {
            this.overlay = overlay;
            this.owner.updateBlock();
        }
    }

    public DyeColor getDyeColour() {
        if (this.colourHex == -1) {
            return null;
        }
        Colour colour = Colour.fromHex(this.colourHex);
        return colour == null ? null : DyeColor.values()[15 - colour.ordinal()];
    }

    public void setDyeColour(DyeColor dyeColour) {
        int newColour = -1;
        if (dyeColour != null) {
            newColour = Colour.values()[15 - dyeColour.ordinal()].getHex();
        }
        if (this.colourHex != newColour) {
            this.colourHex = newColour;
            this.owner.updateBlock();
        }
    }

    public float getToolRenderAngle(TurtleSide side, float f) {
        return side == TurtleSide.LEFT && this.animation == TurtleAnimation.SWING_LEFT_TOOL || side == TurtleSide.RIGHT && this.animation == TurtleAnimation.SWING_RIGHT_TOOL ? 45.0f * (float)Math.sin((double)this.getAnimationFraction(f) * Math.PI) : 0.0f;
    }

    public boolean isRunningAnimation() {
        return this.animation != TurtleAnimation.NONE;
    }

    private static final class CommandCallback
    implements ILuaCallback {
        final MethodResult pull = MethodResult.pullEvent("turtle_response", this);
        private final int command;

        CommandCallback(int command) {
            this.command = command;
        }

        @Override
        @Nonnull
        public MethodResult resume(Object[] response) {
            if (response.length < 3 || !(response[1] instanceof Number) || !(response[2] instanceof Boolean)) {
                return this.pull;
            }
            if (((Number)response[1]).intValue() != this.command) {
                return this.pull;
            }
            return MethodResult.of(Arrays.copyOfRange(response, 2, response.length));
        }
    }
}

