/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleEvent;
import dan200.computercraft.api.turtle.event.TurtleInventoryEvent;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.ItemStorage;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public class TurtleDropCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleDropCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        Direction side;
        Container inventory;
        BlockPos oldPosition;
        BlockPos newPosition;
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        Direction direction = this.direction.toWorldDir(turtle);
        ItemStack stack = InventoryUtil.takeItems(this.quantity, turtle.getItemHandler(), turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
        if (stack == null) {
            return TurtleCommandResult.failure("No items to drop");
        }
        World world = turtle.getWorld();
        TurtleInventoryEvent.Drop event = new TurtleInventoryEvent.Drop(turtle, world, newPosition = (oldPosition = turtle.getPosition()).offset(direction), inventory = InventoryUtil.getInventory(world, newPosition, side = direction.getOpposite()), stack);
        if (TurtleEvent.post(event)) {
            InventoryUtil.storeItems(stack, turtle.getItemHandler(), turtle.getSelectedSlot());
            return TurtleCommandResult.failure(event.getFailureMessage());
        }
        if (inventory != null) {
            ItemStack remainder = InventoryUtil.storeItems(stack, ItemStorage.wrap(inventory));
            if (remainder != null) {
                InventoryUtil.storeItems(remainder, turtle.getItemHandler(), turtle.getSelectedSlot());
            }
            if (remainder != stack) {
                turtle.playAnimation(TurtleAnimation.WAIT);
                return TurtleCommandResult.success();
            }
            return TurtleCommandResult.failure("No space for items");
        }
        WorldUtil.dropItemStack(stack, world, oldPosition, direction);
        turtle.playAnimation(TurtleAnimation.WAIT);
        return TurtleCommandResult.success();
    }
}

