/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.api.turtle.event.TurtleEvent;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.core.MoveDirection;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class TurtleMoveCommand
implements ITurtleCommand {
    private final MoveDirection direction;

    public TurtleMoveCommand(MoveDirection direction) {
        this.direction = direction;
    }

    private static TurtleCommandResult canEnter(World world, BlockPos position) {
        if (position.getY() < 0 || position.getY() >= 256) {
            return TurtleCommandResult.failure(position.getY() < 0 ? "Too low to move" : "Too high to move");
        }
        if (ComputerCraft.turtlesObeyBlockProtection && !TurtlePermissions.isBlockEnterable(world, position)) {
            return TurtleCommandResult.failure("Cannot enter protected area");
        }
        if (!world.isChunkLoaded(Math.floorDiv(position.x, 16), Math.floorDiv(position.z, 16))) {
            return TurtleCommandResult.failure("Cannot leave loaded world");
        }
        return TurtleCommandResult.success();
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        TurtleBlockEvent.Move moveEvent;
        BlockPos oldPosition;
        BlockPos newPosition;
        Direction direction = this.direction.toWorldDir(turtle);
        World oldWorld = turtle.getWorld();
        TurtleCommandResult canEnterResult = TurtleMoveCommand.canEnter(oldWorld, newPosition = (oldPosition = turtle.getPosition()).offset(direction));
        if (!canEnterResult.isSuccess()) {
            return canEnterResult;
        }
        if (!(oldWorld.isAirBlock(newPosition.x, newPosition.y, newPosition.z) || WorldUtil.isLiquidBlock(oldWorld, newPosition) || oldWorld.getBlockMaterial(newPosition.x, newPosition.y, newPosition.z).isReplaceable())) {
            return TurtleCommandResult.failure("Movement obstructed");
        }
        AABB collision = AABB.getPermanentBB((double)newPosition.getX(), (double)newPosition.getY(), (double)newPosition.getZ(), (double)((double)newPosition.getX() + 1.0), (double)((double)newPosition.getY() + 1.0), (double)((double)newPosition.getZ() + 1.0));
        if (!oldWorld.getEntitiesWithinAABB(Entity.class, collision).isEmpty()) {
            if (!ComputerCraft.turtlesCanPush || this.direction == MoveDirection.UP || this.direction == MoveDirection.DOWN) {
                return TurtleCommandResult.failure("Movement obstructed");
            }
            List list = oldWorld.getEntitiesWithinAABB(Entity.class, collision);
            for (Entity entity : list) {
                AABB pushedBB;
                if (!entity.isAlive() || oldWorld.getEntitiesWithinAABB(Entity.class, pushedBB = entity.bb.copy().move((double)(-direction.getOffsetX()) / 2.0, (double)(-direction.getOffsetY()) / 2.0, (double)(-direction.getOffsetZ()) / 2.0).expand((double)direction.getOffsetX(), (double)direction.getOffsetY(), (double)direction.getOffsetZ())).isEmpty()) continue;
                return TurtleCommandResult.failure("Movement obstructed");
            }
        }
        if (TurtleEvent.post(moveEvent = new TurtleBlockEvent.Move(turtle, oldWorld, newPosition))) {
            return TurtleCommandResult.failure(moveEvent.getFailureMessage());
        }
        if (turtle.isFuelNeeded() && turtle.getFuelLevel() < 1) {
            return TurtleCommandResult.failure("Out of fuel");
        }
        if (!turtle.teleportTo(oldWorld, newPosition)) {
            return TurtleCommandResult.failure("Movement failed");
        }
        turtle.consumeFuel(1);
        switch (this.direction) {
            default: {
                turtle.playAnimation(TurtleAnimation.MOVE_FORWARD);
                break;
            }
            case BACK: {
                turtle.playAnimation(TurtleAnimation.MOVE_BACK);
                break;
            }
            case UP: {
                turtle.playAnimation(TurtleAnimation.MOVE_UP);
                break;
            }
            case DOWN: {
                turtle.playAnimation(TurtleAnimation.MOVE_DOWN);
            }
        }
        return TurtleCommandResult.success();
    }
}

