/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.client.blocks.BlockAORenderer;
import dan200.computercraft.shared.common.ComputerCraftItems;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.ItemRenderer;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.item.model.ItemModelBlock;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.Global;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class ItemModelBlockTurtle
extends ItemModelBlock {
    public ItemModelBlockTurtle(ItemBlock<?> itemBlock) {
        super(itemBlock);
    }

    public void renderItemFirstPerson(Tessellator tessellator, ItemRenderer renderer, Player player, ItemStack stack, float partialTick) {
        Minecraft mc = Minecraft.getMinecraft();
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            int lightmapCoord = player.getLightmapCoord(partialTick);
            if (this.itemfullBright) {
                lightmapCoord = LightmapHelper.setBlocklightValue((int)lightmapCoord, (int)15);
            }
            LightmapHelper.setLightmapCoord((int)lightmapCoord);
        } else if (!mc.fullbright && !this.itemfullBright) {
            brightness = player.getBrightness(1.0f);
        }
        float swingProgress = player.getSwingProgress(partialTick);
        float animationProgress2 = MathHelper.sin((float)(swingProgress * (float)Math.PI));
        float animationProgress = MathHelper.sin((float)(MathHelper.sqrt_float((float)swingProgress) * (float)Math.PI));
        GL11.glTranslatef((float)(-animationProgress * 0.4f), (float)(MathHelper.sin((float)(MathHelper.sqrt_float((float)swingProgress) * (float)Math.PI * 2.0f)) * 0.2f), (float)(-animationProgress2 * 0.2f));
        GL11.glTranslatef((float)0.56f, (float)(-0.52f - (1.0f - renderer.getEquippedProgress(partialTick)) * 0.6f), (float)-0.71999997f);
        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnable((int)32826);
        float animationProgress3 = MathHelper.sin((float)(swingProgress * swingProgress * (float)Math.PI));
        GL11.glRotatef((float)(-animationProgress3 * 20.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-animationProgress * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-animationProgress * 80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)0.4f, (float)0.4f, (float)0.4f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderItem(tessellator, renderer, stack, (Entity)player, brightness, true);
    }

    public void renderItem(Tessellator tessellator, ItemRenderer renderer, ItemStack itemstack, @Nullable Entity entity, float brightness, boolean handheldTransform) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        TextureRegistry.blockAtlas.bind();
        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.drawTurtle(tessellator, itemstack, brightness, 1.0f);
        GL11.glDisable((int)3042);
    }

    public void renderItemIntoGui(Tessellator tessellator, Font font, TextureManager textureManager, ItemStack itemStack, int x, int y, float brightness, float alpha) {
        if (itemStack != null) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)2884);
            GL11.glBlendFunc((int)770, (int)771);
            TextureRegistry.blockAtlas.bind();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x - 2), (float)(y + 3), (float)-3.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (this.useColor) {
                int color = this.getColor(itemStack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g2 = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g2 * brightness), (float)(b * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BlockModel.renderBlocks.useInventoryTint = this.useColor;
            GL11.glTranslatef((float)0.62f, (float)0.0f, (float)0.62f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.62f, (float)0.0f, (float)-0.62f);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glTranslatef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glTranslatef((float)-0.12f, (float)0.0f, (float)-0.12f);
            this.drawTurtle(tessellator, itemStack, brightness, alpha);
            BlockModel.renderBlocks.useInventoryTint = true;
            GL11.glPopMatrix();
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
        }
    }

    public void renderAsItemEntity(Tessellator tessellator, Entity entity, Random random, ItemStack itemstack, int renderCount, float yaw, float brightness, float partialTick) {
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        TextureRegistry.blockAtlas.bind();
        float itemSize = 0.25f;
        GL11.glScalef((float)itemSize, (float)itemSize, (float)itemSize);
        for (int i = 0; i < renderCount; ++i) {
            GL11.glPushMatrix();
            if (i > 0) {
                float rOffX = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                float rOffY = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                float rOffZ = (random.nextFloat() * 2.0f - 1.0f) * 0.2f / itemSize;
                GL11.glTranslatef((float)rOffX, (float)rOffY, (float)rOffZ);
            }
            if (LightmapHelper.isLightmapEnabled()) {
                brightness = 1.0f;
                LightmapHelper.setLightmapCoord((int)entity.getLightmapCoord(partialTick));
            }
            if (Global.accessor.isFullbrightEnabled() || this.itemfullBright) {
                brightness = 1.0f;
            }
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            this.drawTurtle(tessellator, itemstack, brightness, 1.0f);
            GL11.glPopMatrix();
        }
    }

    public void renderItemInWorld(Tessellator tessellator, Entity entity, ItemStack itemStack, float brightness, float alpha, boolean worldTransform) {
        if (itemStack != null) {
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)2884);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            TextureRegistry.blockAtlas.bind();
            if (this.useColor) {
                int color = this.getColor(itemStack);
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g2 = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)(r * brightness), (float)(g2 * brightness), (float)(b * brightness), (float)alpha);
            } else {
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
            }
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            BlockModel.renderBlocks.useInventoryTint = this.useColor;
            this.drawTurtle(tessellator, itemStack, brightness, alpha);
            BlockModel.renderBlocks.useInventoryTint = true;
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
        }
    }

    public void drawTurtle(Tessellator tessellator, ItemStack itemStack, float brightness, float alpha) {
        int colour = IColouredItem.getColourBasic(itemStack);
        if (colour != -1) {
            float r = (float)(colour >> 16 & 0xFF) / 255.0f;
            float g2 = (float)(colour >> 8 & 0xFF) / 255.0f;
            float b = (float)(colour & 0xFF) / 255.0f;
            GL11.glColor4f((float)(r * brightness), (float)(g2 * brightness), (float)(b * brightness), (float)alpha);
            Minecraft.getMinecraft().textureManager.loadTexture("/assets/computercraft/textures/block/turtle_colour.png").bind();
            tessellator.startDrawingQuads();
            new BlockAORenderer(AABB.getTemporaryBB((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.8125)).setBottomUV(0.359375, 0.53125, 0.171875, 0.359375).setTopUV(0.546875, 0.359375, 0.359375, 0.53125).setNorthUV(0.71875, 0.71875, 0.53125, 0.53125).setSouthUV(0.359375, 0.71875, 0.171875, 0.53125).setWestUV(0.53125, 0.71875, 0.359375, 0.5346875).setEastUV(0.171875, 0.71875, 0.0, 0.53125).render(tessellator, Side.NORTH);
            new BlockAORenderer(AABB.getTemporaryBB((double)0.1875, (double)0.375, (double)0.8125, (double)0.8125, (double)0.8125, (double)0.9375)).setBottomUV(0.734375, 0.390625, 0.578125, 0.359375).setTopUV(0.890625, 0.359375, 0.734375, 0.390625).setSouthUV(0.734375, 0.5, 0.578125, 0.390625).setWestUV(0.765625, 0.5, 0.734375, 0.390625).setEastUV(0.578125, 0.5, 0.546875, 0.390625).render(tessellator, Side.NORTH);
            tessellator.draw();
        } else if (itemStack.itemID == ComputerCraftItems.TURTLE_ADVANCED.id) {
            Minecraft.getMinecraft().textureManager.loadTexture("/assets/computercraft/textures/block/turtle_advanced.png").bind();
        } else {
            Minecraft.getMinecraft().textureManager.loadTexture("/assets/computercraft/textures/block/turtle_normal.png").bind();
        }
        tessellator.startDrawingQuads();
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        new BlockAORenderer(AABB.getTemporaryBB((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.8125)).setBottomUV(0.359375, 0.171875, 0.171875, 0.0).setTopUV(0.546875, 0.0, 0.359375, 0.171875).setNorthUV(0.71875, 0.359375, 0.53125, 0.171875).setSouthUV(0.359375, 0.359375, 0.171875, 0.171875).setWestUV(0.53125, 0.359375, 0.359375, 0.171875).setEastUV(0.171875, 0.359375, 0.0, 0.171875).render(tessellator, Side.NORTH);
        new BlockAORenderer(AABB.getTemporaryBB((double)0.1875, (double)0.375, (double)0.8125, (double)0.8125, (double)0.8125, (double)0.9375)).setBottomUV(0.734375, 0.03125, 0.578125, 0.0).setTopUV(0.890625, 0.0, 0.734375, 0.03125).setSouthUV(0.734375, 0.140625, 0.578125, 0.03125).setWestUV(0.765625, 0.140625, 0.734375, 0.03125).setEastUV(0.578125, 0.140625, 0.546875, 0.03125).render(tessellator, Side.NORTH);
        tessellator.draw();
        if (itemStack.getItem() instanceof ITurtleItem) {
            ITurtleUpgrade rightUpgrade;
            ITurtleItem item = (ITurtleItem)itemStack.getItem();
            ITurtleUpgrade leftUpgrade = item.getUpgrade(itemStack, TurtleSide.LEFT);
            if (leftUpgrade != null) {
                leftUpgrade.drawItemUpgrade(tessellator, Minecraft.getMinecraft().textureManager, TurtleSide.LEFT);
            }
            if ((rightUpgrade = item.getUpgrade(itemStack, TurtleSide.RIGHT)) != null) {
                rightUpgrade.drawItemUpgrade(tessellator, Minecraft.getMinecraft().textureManager, TurtleSide.RIGHT);
            }
        }
    }
}

