/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.fabric.mixin.ContainerCraftingAccessor;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.HasJsonAdapter;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.adapter.RecipeJsonAdapter;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.container.ContainerCrafting;

public final class TurtleUpgradeRecipe
extends RecipeEntryCrafting<RecipeSymbol[], ItemStack>
implements HasJsonAdapter {
    @Nonnull
    public ItemStack getOutput() {
        return Objects.requireNonNull(TurtleItemFactory.create(-1, null, -1, ComputerFamily.NORMAL, null, null, 0, -1));
    }

    public boolean matches(ContainerCrafting inventory) {
        return this.getCraftingResult(inventory) != null;
    }

    public boolean matchesQuery(SearchQuery searchQuery) {
        return false;
    }

    public ItemStack getCraftingResult(ContainerCrafting inventory) {
        ItemStack leftItem = null;
        ItemStack turtle = null;
        ItemStack rightItem = null;
        int width = ((ContainerCraftingAccessor)inventory).getWidth();
        int height = inventory.getContainerSize() / width;
        for (int y = 0; y < height; ++y) {
            if (turtle == null) {
                boolean finishedRow = false;
                for (int x = 0; x < width; ++x) {
                    ItemStack item = inventory.getItem(x + y * width);
                    if (item != null) {
                        if (finishedRow) {
                            return null;
                        }
                        if (item.getItem() instanceof ITurtleItem) {
                            if (turtle == null) {
                                turtle = item;
                                continue;
                            }
                            return null;
                        }
                        if (turtle == null && leftItem == null) {
                            leftItem = item;
                            continue;
                        }
                        if (turtle != null && rightItem == null) {
                            rightItem = item;
                            continue;
                        }
                        return null;
                    }
                    if (leftItem == null && turtle == null) continue;
                    finishedRow = true;
                }
                if (turtle != null || leftItem == null && rightItem == null) continue;
                return null;
            }
            for (int x = 0; x < width; ++x) {
                ItemStack item = inventory.getItem(x + y * width);
                if (item == null) continue;
                return null;
            }
        }
        if (turtle == null || leftItem == null && rightItem == null) {
            return null;
        }
        ITurtleItem itemTurtle = (ITurtleItem)turtle.getItem();
        ComputerFamily family = itemTurtle.getFamily();
        ITurtleUpgrade[] upgrades = new ITurtleUpgrade[]{itemTurtle.getUpgrade(turtle, TurtleSide.LEFT), itemTurtle.getUpgrade(turtle, TurtleSide.RIGHT)};
        ItemStack[] items = new ItemStack[]{rightItem, leftItem};
        for (int i = 0; i < 2; ++i) {
            if (items[i] == null) continue;
            ITurtleUpgrade itemUpgrade = TurtleUpgrades.get(items[i]);
            if (itemUpgrade == null) {
                return null;
            }
            if (upgrades[i] != null) {
                return null;
            }
            if (!TurtleUpgrades.suitableForFamily(family, itemUpgrade)) {
                return null;
            }
            upgrades[i] = itemUpgrade;
        }
        int computerID = itemTurtle.getComputerID(turtle);
        String label = itemTurtle.getLabel(turtle);
        int fuelLevel = itemTurtle.getFuelLevel(turtle);
        int colour = itemTurtle.getColour(turtle);
        int overlay = itemTurtle.getOverlay(turtle);
        return TurtleItemFactory.create(computerID, label, colour, family, upgrades[0], upgrades[1], fuelLevel, overlay);
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack[] onCraftResult(ContainerCrafting containerCrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int i = 0; i < containerCrafting.getContainerSize(); ++i) {
            ItemStack itemStack = containerCrafting.getItem(i);
            if (itemStack == null) continue;
            containerCrafting.removeItem(i, 1);
            if (!itemStack.getItem().hasContainerItem()) continue;
            containerCrafting.setItem(i, new ItemStack(itemStack.getItem().getContainerItem()));
        }
        return returnStack;
    }

    public RecipeJsonAdapter<?> getAdapter() {
        return new TurtleUpgradeRecipeJsonAdapter();
    }

    private static class TurtleUpgradeRecipeJsonAdapter
    implements RecipeJsonAdapter<TurtleUpgradeRecipe> {
        private TurtleUpgradeRecipeJsonAdapter() {
        }

        public TurtleUpgradeRecipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return new TurtleUpgradeRecipe();
        }

        public JsonElement serialize(TurtleUpgradeRecipe src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", src.toString().replaceFirst("/*$", ""));
            obj.addProperty("type", Registries.RECIPE_TYPES.getKey(((Object)((Object)src)).getClass()));
            return obj;
        }
    }
}

