/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.common.ComputerCraftItems;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.util.BlockPos;
import javax.annotation.Nonnull;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class TurtleModem
extends AbstractTurtleUpgrade {
    private final boolean advanced;

    public TurtleModem(boolean advanced, int id) {
        super(id, TurtleUpgradeType.PERIPHERAL, (IItemConvertible)(advanced ? ComputerCraftItems.WIRELESS_MODEM_ADVANCED : ComputerCraftItems.WIRELESS_MODEM_NORMAL));
        this.advanced = advanced;
    }

    @Override
    public IPeripheral createPeripheral(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        return new Peripheral(turtle, this.advanced);
    }

    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull Direction dir) {
        return TurtleCommandResult.failure();
    }

    @Override
    public void drawTileUpgrade(Tessellator tessellator, TextureManager textureManager, TileTurtle tileEntity, float angle, @NotNull TurtleSide side, float partialTick) {
        boolean active = false;
        ITurtleAccess turtle = tileEntity.getAccess();
        if (turtle != null) {
            CompoundTag turtleNBT = turtle.getUpgradeNBTData(side);
            boolean bl = active = turtleNBT.containsKey("active") && turtleNBT.getBoolean("active");
        }
        if (this.advanced) {
            if (active) {
                textureManager.loadTexture("/assets/computercraft/textures/block/wireless_modem_advanced_face_on.png").bind();
            } else {
                textureManager.loadTexture("/assets/computercraft/textures/block/wireless_modem_advanced_face.png").bind();
            }
        } else if (active) {
            textureManager.loadTexture("/assets/computercraft/textures/block/wireless_modem_normal_face_on.png").bind();
        } else {
            textureManager.loadTexture("/assets/computercraft/textures/block/wireless_modem_normal_face.png").bind();
        }
        tessellator.startDrawingQuads();
        if (side == TurtleSide.LEFT) {
            TurtleModem.drawUpgradeLeft(tessellator, tileEntity, angle);
        } else {
            TurtleModem.drawUpgradeRight(tessellator, tileEntity, angle);
        }
        tessellator.draw();
    }

    @Override
    public void drawItemUpgrade(Tessellator tessellator, TextureManager textureManager, @NotNull TurtleSide side) {
        if (!this.advanced) {
            textureManager.loadTexture("/assets/computercraft/textures/block/wireless_modem_normal_face.png").bind();
        } else {
            textureManager.loadTexture("/assets/computercraft/textures/block/wireless_modem_advanced_face.png").bind();
        }
        tessellator.startDrawingQuads();
        if (side == TurtleSide.LEFT) {
            TurtleModem.drawUpgradeLeft(tessellator);
        } else {
            TurtleModem.drawUpgradeRight(tessellator);
        }
        tessellator.draw();
    }

    @Override
    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        ModemState state;
        IPeripheral peripheral;
        if (!Helper.isClientWorld() && (peripheral = turtle.getPeripheral(side)) instanceof Peripheral && (state = ((Peripheral)peripheral).getModemState()).pollChanged()) {
            turtle.getUpgradeNBTData(side).putBoolean("active", state.isOpen());
            turtle.updateUpgradeNBTData(side);
        }
    }

    @Override
    @NotNull
    public String getUnlocalisedAdjective() {
        if (this.advanced) {
            return "upgrade.computercraft.wireless_modem_advanced.adjective";
        }
        return "upgrade.computercraft.wireless_modem_normal.adjective";
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final ITurtleAccess turtle;

        Peripheral(ITurtleAccess turtle, boolean advanced) {
            super(new ModemState(), advanced);
            this.turtle = turtle;
        }

        @Override
        @Nonnull
        public World getWorld() {
            return this.turtle.getWorld();
        }

        @Override
        @Nonnull
        public Vec3 getPosition() {
            BlockPos turtlePos = this.turtle.getPosition();
            return Vec3.getPermanentVec3((double)turtlePos.getX(), (double)turtlePos.getY(), (double)turtlePos.getZ());
        }

        @Override
        public boolean equals(IPeripheral other) {
            return this == other || other instanceof Peripheral && ((Peripheral)other).turtle == this.turtle;
        }
    }
}

