/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import com.mojang.nbt.tags.CompoundTag;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.api.turtle.event.TurtleAttackEvent;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import dan200.computercraft.api.turtle.event.TurtleEvent;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

public class TurtleTool
extends AbstractTurtleUpgrade {
    private static final int TAG_LIST = 9;
    private static final int TAG_COMPOUND = 10;
    protected final ItemStack item;
    protected EnumDropCause dropCause = EnumDropCause.PROPER_TOOL;

    public TurtleTool(int id, Item item) {
        super(id, TurtleUpgradeType.TOOL, (IItemConvertible)item);
        this.item = new ItemStack(item);
    }

    public TurtleTool(int id, ItemStack craftItem, ItemStack toolItem) {
        super(id, TurtleUpgradeType.TOOL, craftItem);
        this.item = toolItem;
    }

    private static Function<ItemStack, ItemStack> turtleDropConsumer(TileEntity turtleBlock, ITurtleAccess turtle) {
        return drop -> turtleBlock.isInvalid() ? drop : InventoryUtil.storeItems(drop, turtle.getItemHandler(), turtle.getSelectedSlot());
    }

    private static void stopConsuming(TileEntity turtleBlock, ITurtleAccess turtle) {
        Direction direction = !turtleBlock.isInvalid() ? null : turtle.getDirection().getOpposite();
        List<ItemStack> extra = DropConsumer.clear();
        for (ItemStack remainder : extra) {
            WorldUtil.dropItemStack(remainder, turtle.getWorld(), turtle.getPosition(), direction);
        }
    }

    @Override
    @NotNull
    public String getUnlocalisedAdjective() {
        return "upgrade.minecraft.diamond_pickaxe.adjective";
    }

    @Override
    public boolean isItemSuitable(@Nonnull ItemStack stack) {
        CompoundTag tag = stack.getData();
        if (stack.isItemDamaged() || stack.hasCustomName()) {
            return false;
        }
        return !tag.containsKey("AttributeModifiers") || tag.getList("AttributeModifiers") != null;
    }

    @Override
    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull Direction direction) {
        switch (verb) {
            case ATTACK: {
                return this.attack(turtle, direction, side);
            }
            case DIG: {
                return this.dig(turtle, direction, side);
            }
        }
        return TurtleCommandResult.failure("Unsupported action");
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void drawTileUpgrade(Tessellator tessellator, TextureManager textureManager, TileTurtle tileEntity, float angle, @Nonnull TurtleSide side, float partialTick) {
        float xOffset = side == TurtleSide.LEFT ? -0.40625f : 0.40625f;
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ItemModel model = ItemModelDispatcher.getInstance().getDispatch(this.item);
        float tileWidth = 1.0f / (float)model.getIcon(null, (ItemStack)this.item).width;
        GL11.glTranslatef((float)(-1.0f + tileWidth), (float)(-1.0f + tileWidth), (float)(0.5f + tileWidth / 2.0f - xOffset));
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)tileEntity.getToolRenderAngle(side, partialTick), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        GL11.glTranslatef((float)tileWidth, (float)tileWidth, (float)tileWidth);
        model.renderItemInWorld(tessellator, null, this.item, 1.0f, 1.0f, false);
        GL11.glPopMatrix();
    }

    @Override
    public void drawItemUpgrade(Tessellator tessellator, TextureManager textureManager, @NotNull TurtleSide side) {
        float xOffset = side == TurtleSide.LEFT ? -0.40625f : 0.40625f;
        GL11.glPushMatrix();
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ItemModel model = ItemModelDispatcher.getInstance().getDispatch(this.item);
        float tileWidth = 1.0f / (float)model.getIcon(null, (ItemStack)this.item).width;
        GL11.glTranslatef((float)(-1.0f + tileWidth), (float)(-1.0f + tileWidth), (float)(0.5f + tileWidth / 2.0f - xOffset));
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
        GL11.glTranslatef((float)tileWidth, (float)tileWidth, (float)tileWidth);
        model.renderItemInWorld(tessellator, null, this.item, 1.0f, 1.0f, false);
        GL11.glEnable((int)32826);
        GL11.glPopMatrix();
    }

    private TurtleCommandResult attack(ITurtleAccess turtle, Direction direction, TurtleSide side) {
        Vec3 rayDir;
        TileTurtle turtleBlock;
        World world = turtle.getWorld();
        BlockPos position = turtle.getPosition();
        TileTurtle tileTurtle = turtleBlock = turtle instanceof TurtleBrain ? ((TurtleBrain)turtle).getOwner() : world.getTileEntity(position.x, position.y, position.z);
        if (turtleBlock == null) {
            return TurtleCommandResult.failure("Turtle has vanished from existence.");
        }
        Vec3 turtlePos = Vec3.getPermanentVec3((double)position.x, (double)position.y, (double)position.z);
        Pair<Entity, Vec3> hit = WorldUtil.rayTraceEntities(world, turtlePos, rayDir = Vec3.getPermanentVec3((double)direction.getOffsetX(), (double)direction.getOffsetY(), (double)direction.getOffsetZ()), 1.5);
        if (hit != null) {
            Entity hitEntity = (Entity)hit.getKey();
            if (!hitEntity.isSelectable()) {
                return TurtleCommandResult.failure("Nothing to attack here");
            }
            TurtleAttackEvent attackEvent = new TurtleAttackEvent(turtle, hitEntity, this, side);
            if (TurtleEvent.post(attackEvent)) {
                return TurtleCommandResult.failure(attackEvent.getFailureMessage());
            }
            DropConsumer.set(hitEntity, TurtleTool.turtleDropConsumer(turtleBlock, turtle));
            boolean attacked = false;
            int damage = 1;
            if ((float)damage > 0.0f && hitEntity.hurt(null, damage *= this.getDamageMultiplier(), DamageType.GENERIC)) {
                attacked = true;
            }
            TurtleTool.stopConsuming(turtleBlock, turtle);
            if (attacked) {
                return TurtleCommandResult.success();
            }
        }
        return TurtleCommandResult.failure("Nothing to attack here");
    }

    private TurtleCommandResult dig(ITurtleAccess turtle, Direction direction, TurtleSide side) {
        TileTurtle turtleBlock;
        World world = turtle.getWorld();
        BlockPos turtlePosition = turtle.getPosition();
        TileTurtle tileTurtle = turtleBlock = turtle instanceof TurtleBrain ? ((TurtleBrain)turtle).getOwner() : world.getTileEntity(turtlePosition.x, turtlePosition.y, turtlePosition.z);
        if (turtleBlock == null) {
            return TurtleCommandResult.failure("Turtle has vanished from existence.");
        }
        BlockPos blockPosition = turtlePosition.offset(direction);
        if (world.isAirBlock(blockPosition.x, blockPosition.y, blockPosition.z) || WorldUtil.isLiquidBlock(world, blockPosition)) {
            return TurtleCommandResult.failure("Nothing to dig here");
        }
        Block block = Objects.requireNonNull(world.getBlock(blockPosition.x, blockPosition.y, blockPosition.z));
        if (ComputerCraft.turtlesObeyBlockProtection && !TurtlePermissions.isBlockEditable(world, blockPosition)) {
            return TurtleCommandResult.failure("Cannot break protected block");
        }
        if (!this.canBreakBlock(world, blockPosition)) {
            return TurtleCommandResult.failure("Unbreakable block detected");
        }
        TurtleBlockEvent.Dig digEvent = new TurtleBlockEvent.Dig(turtle, world, blockPosition, block.id(), this, side);
        if (TurtleEvent.post(digEvent)) {
            return TurtleCommandResult.failure(digEvent.getFailureMessage());
        }
        DropConsumer.set(world, blockPosition, TurtleTool.turtleDropConsumer(turtleBlock, turtle));
        TileEntity tile = world.getTileEntity(blockPosition.x, blockPosition.y, blockPosition.z);
        world.playBlockEvent(null, 2001, blockPosition.x, blockPosition.y, blockPosition.z, block.id());
        block.dropBlockWithCause(world, this.dropCause, blockPosition.x, blockPosition.y, blockPosition.z, world.getBlockMetadata(blockPosition.x, blockPosition.y, blockPosition.z), tile, null);
        world.setBlockWithNotify(blockPosition.x, blockPosition.y, blockPosition.z, 0);
        TurtleTool.stopConsuming(turtleBlock, turtle);
        return TurtleCommandResult.success();
    }

    protected int getDamageMultiplier() {
        return 3;
    }

    protected boolean canBreakBlock(World world, BlockPos pos) {
        Block block = world.getBlock(pos.x, pos.y, pos.z);
        return block != null && block != Blocks.BEDROCK;
    }
}

