/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

public enum Colour {
    BLACK(0x111111),
    RED(0xCC4C4C),
    GREEN(5744206),
    BROWN(8349260),
    BLUE(0x3366CC),
    PURPLE(11691749),
    CYAN(5020082),
    LIGHT_GREY(0x999999),
    GREY(0x4C4C4C),
    PINK(15905484),
    LIME(8375321),
    YELLOW(14605932),
    LIGHT_BLUE(10072818),
    MAGENTA(15040472),
    ORANGE(15905331),
    WHITE(0xF0F0F0);

    public static final Colour[] VALUES;
    private final int hex;
    private final float[] rgb;

    private Colour(int hex) {
        this.hex = hex;
        this.rgb = new float[]{(float)(hex >> 16 & 0xFF) / 255.0f, (float)(hex >> 8 & 0xFF) / 255.0f, (float)(hex & 0xFF) / 255.0f};
    }

    public static Colour fromInt(int colour) {
        return colour >= 0 && colour < 16 ? VALUES[colour] : null;
    }

    public static Colour fromHex(int colour) {
        for (Colour entry : VALUES) {
            if (entry.getHex() != colour) continue;
            return entry;
        }
        return null;
    }

    public int getHex() {
        return this.hex;
    }

    public Colour getNext() {
        return VALUES[(this.ordinal() + 1) % 16];
    }

    public Colour getPrevious() {
        return VALUES[(this.ordinal() + 15) % 16];
    }

    public float[] getRGB() {
        return this.rgb;
    }

    public float getR() {
        return this.rgb[0];
    }

    public float getG() {
        return this.rgb[1];
    }

    public float getB() {
        return this.rgb[2];
    }

    static {
        VALUES = Colour.values();
    }
}

