/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.ComputerCraft;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;

public class ResourceManager {
    public Identifier[] findResources(String namespace, String subPath) {
        String path = "/assets/" + namespace + "/" + subPath;
        ArrayList identifiers = new ArrayList();
        try {
            Path dirPath;
            URI uri = ComputerCraft.class.getResource(path).toURI();
            try {
                dirPath = Paths.get(uri);
            }
            catch (FileSystemNotFoundException e) {
                HashMap env = new HashMap();
                FileSystem fileSystem = FileSystems.newFileSystem(uri, env);
                dirPath = fileSystem.getPath(path, new String[0]);
            }
            Files.list(dirPath).forEach(found -> {
                Identifier identifier = new Identifier(namespace, found.toString().replaceFirst(".*?/assets/" + Pattern.quote(namespace) + "/", ""));
                identifiers.add(identifier);
                Identifier[] newIdentifiers = this.findResources(namespace, identifier.subPath);
                identifiers.addAll(Arrays.asList(newIdentifiers));
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return identifiers.toArray(new Identifier[0]);
    }

    public Resource getResource(Identifier identifier) {
        return new Resource(identifier);
    }

    public static class Identifier {
        private final String namespace;
        private final String subPath;

        public Identifier(String namespace, String subPath) {
            this.namespace = namespace;
            this.subPath = subPath;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getPath() {
            return this.subPath;
        }
    }

    public static class Resource {
        private final Identifier identifier;

        public Resource(Identifier identifier) {
            this.identifier = identifier;
        }

        public InputStream getInputStream() {
            return ComputerCraft.class.getResourceAsStream("/assets/" + this.identifier.namespace + "/" + this.identifier.subPath);
        }
    }
}

