/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;

public final class Buffer {
    private static final int DEFAULT_CAPACITY = 64;
    private static final byte[] NOBYTES = new byte[0];
    private byte[] bytes;
    private int length;
    private int offset;
    private LuaString value;

    public Buffer() {
        this(64);
    }

    public Buffer(int initialCapacity) {
        this.bytes = new byte[initialCapacity];
        this.length = 0;
        this.offset = 0;
        this.value = null;
    }

    public Buffer(LuaString value) {
        this.bytes = NOBYTES;
        this.offset = 0;
        this.length = 0;
        this.value = value;
    }

    public LuaValue value() {
        return this.value != null ? this.value : this.toLuaString();
    }

    public Buffer setvalue(LuaString value) {
        this.bytes = NOBYTES;
        this.length = 0;
        this.offset = 0;
        this.value = value;
        return this;
    }

    public final LuaString toLuaString() {
        this.realloc(this.length, 0);
        return LuaString.valueOf(this.bytes, this.offset, this.length);
    }

    public String toString() {
        return this.value().toString();
    }

    public final Buffer append(byte b) {
        this.makeRoom(0, 1);
        this.bytes[this.offset + this.length++] = b;
        return this;
    }

    public final Buffer append(byte[] b) {
        this.makeRoom(0, b.length);
        System.arraycopy(b, 0, this.bytes, this.offset + this.length, b.length);
        this.length += b.length;
        return this;
    }

    public final Buffer append(byte[] b, int start, int length) {
        this.makeRoom(0, length);
        System.arraycopy(b, start, this.bytes, this.offset + this.length, length);
        this.length += length;
        return this;
    }

    public final Buffer append(char c) {
        this.makeRoom(0, 1);
        this.bytes[this.offset + this.length++] = c < '\u0100' ? (int)c : 63;
        return this;
    }

    public final Buffer append(char[] chars) {
        int n = chars.length;
        this.makeRoom(0, n);
        LuaString.encode(chars, this.bytes, this.offset + this.length);
        this.length += n;
        return this;
    }

    public Buffer append(char[] chars, int start, int length) {
        this.makeRoom(0, length);
        int j = this.offset + this.length;
        int i = start;
        while (i < start + length) {
            char c = chars[i];
            this.bytes[j] = c < '\u0100' ? (int)c : 63;
            ++i;
            ++j;
        }
        this.length += length;
        return this;
    }

    public final Buffer append(LuaString str) {
        int n = str.length;
        this.makeRoom(0, n);
        str.copyTo(0, this.bytes, this.offset + this.length, n);
        this.length += n;
        return this;
    }

    public final Buffer append(String str) {
        int n = str.length();
        this.makeRoom(0, n);
        LuaString.encode(str, this.bytes, this.offset + this.length);
        this.length += n;
        return this;
    }

    public Buffer prepend(LuaString s2) {
        int n = s2.length;
        this.makeRoom(n, 0);
        System.arraycopy(s2.bytes, s2.offset, this.bytes, this.offset - n, n);
        this.offset -= n;
        this.length += n;
        this.value = null;
        return this;
    }

    public final void makeRoom(int nbefore, int nafter) {
        if (this.value != null) {
            LuaString s2 = this.value;
            this.value = null;
            this.length = s2.length;
            this.offset = nbefore;
            this.bytes = new byte[nbefore + this.length + nafter];
            System.arraycopy(s2.bytes, s2.offset, this.bytes, this.offset, this.length);
        } else if (this.offset + this.length + nafter > this.bytes.length || this.offset < nbefore) {
            int n = nbefore + this.length + nafter;
            int m4 = n < 32 ? 32 : Math.max(n, this.length * 2);
            this.realloc(m4, nbefore == 0 ? 0 : m4 - this.length - nafter);
        }
    }

    private void realloc(int newSize, int newOffset) {
        if (newSize != this.bytes.length) {
            byte[] newBytes = new byte[newSize];
            System.arraycopy(this.bytes, this.offset, newBytes, newOffset, this.length);
            this.bytes = newBytes;
            this.offset = newOffset;
        }
    }
}

