/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;

public final class LuaInteger
extends LuaNumber {
    private static final LuaInteger[] intValues = new LuaInteger[512];
    public final int v;

    public static LuaInteger valueOf(int i) {
        return i <= 255 && i >= -256 ? intValues[i + 256] : new LuaInteger(i);
    }

    public static LuaNumber valueOf(long l) {
        int i = (int)l;
        return l == (long)i ? (i <= 255 && i >= -256 ? intValues[i + 256] : new LuaInteger(i)) : LuaDouble.valueOf(l);
    }

    LuaInteger(int i) {
        this.v = i;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isIntExact() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public double toDouble() {
        return this.v;
    }

    @Override
    public int toInteger() {
        return this.v;
    }

    @Override
    public long toLong() {
        return this.v;
    }

    @Override
    public double optDouble(double defval) {
        return this.v;
    }

    @Override
    public int optInteger(int defval) {
        return this.v;
    }

    @Override
    public LuaInteger optLuaInteger(LuaInteger defval) {
        return this;
    }

    @Override
    public long optLong(long defval) {
        return this.v;
    }

    @Override
    public String toString() {
        return Integer.toString(this.v);
    }

    @Override
    public LuaString strvalue() {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    @Override
    public LuaString optLuaString(LuaString defval) {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    @Override
    public LuaValue toLuaString() {
        return LuaString.valueOf(Integer.toString(this.v));
    }

    @Override
    public String optString(String defval) {
        return Integer.toString(this.v);
    }

    @Override
    public LuaInteger checkLuaInteger() {
        return this;
    }

    public int hashCode() {
        return this.v;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LuaInteger && ((LuaInteger)o).v == this.v;
    }

    @Override
    public boolean raweq(LuaValue val) {
        return val.raweq(this.v);
    }

    @Override
    public boolean raweq(double val) {
        return (double)this.v == val;
    }

    @Override
    public boolean raweq(int val) {
        return this.v == val;
    }

    @Override
    public int checkInteger() {
        return this.v;
    }

    @Override
    public long checkLong() {
        return this.v;
    }

    @Override
    public double checkDouble() {
        return this.v;
    }

    @Override
    public String checkString() {
        return String.valueOf(this.v);
    }

    @Override
    public LuaString checkLuaString() {
        return ValueFactory.valueOf(String.valueOf(this.v));
    }

    @Override
    public double checkArith() {
        return this.v;
    }

    static {
        for (int i = 0; i < 512; ++i) {
            LuaInteger.intValues[i] = new LuaInteger(i - 256);
        }
    }
}

