/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt;

import org.squiddev.cobalt.CachedMetamethod;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaBaseString;
import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaThread;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.NonResumableException;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.debug.DebugFrame;
import org.squiddev.cobalt.debug.DebugHandler;
import org.squiddev.cobalt.function.LuaFunction;

public final class OperationHelper {
    private OperationHelper() {
    }

    public static LuaValue add(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        return OperationHelper.add(state, left, right, -1, -1);
    }

    public static LuaValue add(LuaState state, LuaValue left, LuaValue right, int leftIdx, int rightIdx) throws LuaError, UnwindThrowable {
        double dRight;
        int y;
        int r;
        int x;
        if (left instanceof LuaInteger && right instanceof LuaInteger && (((x = ((LuaInteger)left).v) ^ (r = x + (y = ((LuaInteger)right).v))) & (y ^ r)) >= 0) {
            return LuaInteger.valueOf(r);
        }
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(dLeft + dRight);
        }
        return OperationHelper.arithMetatable(state, Constants.ADD, left, right, leftIdx, rightIdx);
    }

    public static LuaValue sub(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        return OperationHelper.sub(state, left, right, -1, -1);
    }

    public static LuaValue sub(LuaState state, LuaValue left, LuaValue right, int leftIdx, int rightIdx) throws LuaError, UnwindThrowable {
        double dRight;
        int y;
        int r;
        int x;
        if (left instanceof LuaInteger && right instanceof LuaInteger && (((x = ((LuaInteger)left).v) ^ (r = x - (y = ((LuaInteger)right).v))) & (y ^ r)) >= 0) {
            return LuaInteger.valueOf(r);
        }
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(dLeft - dRight);
        }
        return OperationHelper.arithMetatable(state, Constants.SUB, left, right, leftIdx, rightIdx);
    }

    public static LuaValue mul(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        return OperationHelper.mul(state, left, right, -1, -1);
    }

    public static LuaValue mul(LuaState state, LuaValue left, LuaValue right, int leftIdx, int rightIdx) throws LuaError, UnwindThrowable {
        double dRight;
        if (left instanceof LuaInteger && right instanceof LuaInteger) {
            return LuaInteger.valueOf((long)((LuaInteger)left).v * (long)((LuaInteger)right).v);
        }
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(dLeft * dRight);
        }
        return OperationHelper.arithMetatable(state, Constants.MUL, left, right, leftIdx, rightIdx);
    }

    public static LuaValue div(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        return OperationHelper.div(state, left, right, -1, -1);
    }

    public static LuaValue div(LuaState state, LuaValue left, LuaValue right, int leftIdx, int rightIdx) throws LuaError, UnwindThrowable {
        double dRight;
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(OperationHelper.div(dLeft, dRight));
        }
        return OperationHelper.arithMetatable(state, Constants.DIV, left, right, leftIdx, rightIdx);
    }

    public static LuaValue mod(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        return OperationHelper.mod(state, left, right, -1, -1);
    }

    public static LuaValue mod(LuaState state, LuaValue left, LuaValue right, int leftIdx, int rightIdx) throws LuaError, UnwindThrowable {
        double dRight;
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(OperationHelper.mod(dLeft, dRight));
        }
        return OperationHelper.arithMetatable(state, Constants.MOD, left, right, leftIdx, rightIdx);
    }

    public static LuaValue pow(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        return OperationHelper.pow(state, left, right, -1, -1);
    }

    public static LuaValue pow(LuaState state, LuaValue left, LuaValue right, int leftIdx, int rightIdx) throws LuaError, UnwindThrowable {
        double dRight;
        double dLeft = left.toDouble();
        if (OperationHelper.checkNumber(left, dLeft) && OperationHelper.checkNumber(right, dRight = right.toDouble())) {
            return LuaDouble.valueOf(Math.pow(dLeft, dRight));
        }
        return OperationHelper.arithMetatable(state, Constants.POW, left, right, leftIdx, rightIdx);
    }

    public static double div(double lhs, double rhs) {
        return rhs != 0.0 ? lhs / rhs : (lhs > 0.0 ? Double.POSITIVE_INFINITY : (lhs == 0.0 ? Double.NaN : Double.NEGATIVE_INFINITY));
    }

    public static double mod(double lhs, double rhs) {
        double mod = lhs % rhs;
        return mod * rhs < 0.0 ? mod + rhs : mod;
    }

    public static LuaValue arithMetatable(LuaState state, LuaValue tag, LuaValue left, LuaValue right, int leftStack, int rightStack) throws LuaError, UnwindThrowable {
        return OperationHelper.call(state, OperationHelper.getMetatable(state, tag, left, right, leftStack, rightStack), left, right);
    }

    public static LuaValue getMetatable(LuaState state, LuaValue tag, LuaValue left, LuaValue right, int leftStack, int rightStack) throws LuaError {
        LuaValue h2 = left.metatag(state, tag);
        if (h2.isNil() && (h2 = right.metatag(state, tag)).isNil()) {
            if (left.isNumber()) {
                left = right;
                leftStack = rightStack;
            }
            throw ErrorFactory.operandError(state, left, "perform arithmetic on", leftStack);
        }
        return h2;
    }

    public static LuaValue concat(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        return OperationHelper.concat(state, left, right, -1, -1);
    }

    public static LuaValue concat(LuaState state, LuaValue left, LuaValue right, int leftStack, int rightStack) throws LuaError, UnwindThrowable {
        if (left.isString() && right.isString()) {
            return OperationHelper.concat(left.checkLuaString(), right.checkLuaString());
        }
        return OperationHelper.concatNonStrings(state, left, right, leftStack, rightStack);
    }

    public static LuaValue concatNonStrings(LuaState state, LuaValue left, LuaValue right, int leftStack, int rightStack) throws LuaError, UnwindThrowable {
        LuaValue h2 = left.metatag(state, Constants.CONCAT);
        if (h2.isNil() && (h2 = right.metatag(state, Constants.CONCAT)).isNil()) {
            if (left.isString()) {
                throw ErrorFactory.operandError(state, right, "concatenate", rightStack);
            }
            throw ErrorFactory.operandError(state, left, "concatenate", leftStack);
        }
        return OperationHelper.call(state, h2, left, right);
    }

    public static LuaString concat(LuaString left, LuaString right) {
        byte[] b = new byte[left.length + right.length];
        System.arraycopy(left.bytes, left.offset, b, 0, left.length);
        System.arraycopy(right.bytes, right.offset, b, left.length, right.length);
        return LuaString.valueOf(b);
    }

    public static boolean lt(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        int tLeft = left.type();
        if (tLeft != right.type()) {
            throw ErrorFactory.compareError(left, right);
        }
        switch (tLeft) {
            case 3: {
                return left.toDouble() < right.toDouble();
            }
            case 4: {
                return left.strvalue().compare(right.strvalue()) < 0;
            }
        }
        LuaValue h2 = left.metatag(state, Constants.LT);
        if (!h2.isNil() && h2 == right.metatag(state, Constants.LT)) {
            return OperationHelper.call(state, h2, left, right).toBoolean();
        }
        throw new LuaError("attempt to compare two " + left.typeName() + " values");
    }

    public static boolean le(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        int tLeft = left.type();
        if (tLeft != right.type()) {
            throw ErrorFactory.compareError(left, right);
        }
        switch (tLeft) {
            case 3: {
                return left.toDouble() <= right.toDouble();
            }
            case 4: {
                return left.strvalue().compare(right.strvalue()) <= 0;
            }
        }
        LuaValue h2 = left.metatag(state, Constants.LE);
        if (h2.isNil()) {
            h2 = left.metatag(state, Constants.LT);
            if (!h2.isNil() && h2 == right.metatag(state, Constants.LT)) {
                DebugFrame frame = DebugHandler.getDebugState(state).getStackUnsafe();
                frame.flags |= 0x80;
                boolean result = !OperationHelper.call(state, h2, right, left).toBoolean();
                frame.flags ^= 0x80;
                return result;
            }
        } else if (h2 == right.metatag(state, Constants.LE)) {
            return OperationHelper.call(state, h2, left, right).toBoolean();
        }
        throw new LuaError("attempt to compare two " + left.typeName() + " values");
    }

    public static boolean eq(LuaState state, LuaValue left, LuaValue right) throws LuaError, UnwindThrowable {
        int tLeft = left.type();
        if (tLeft != right.type()) {
            return false;
        }
        switch (tLeft) {
            case 0: {
                return true;
            }
            case 3: {
                return left.toDouble() == right.toDouble();
            }
            case 1: {
                return left.toBoolean() == right.toBoolean();
            }
            case 4: {
                return left == right || left.raweq(right);
            }
            case 5: 
            case 7: {
                if (left == right || left.raweq(right)) {
                    return true;
                }
                LuaTable leftMeta = left.getMetatable(state);
                if (leftMeta == null) {
                    return false;
                }
                LuaTable rightMeta = right.getMetatable(state);
                if (rightMeta == null) {
                    return false;
                }
                LuaValue h2 = leftMeta.rawget(CachedMetamethod.EQ);
                return !h2.isNil() && h2 == rightMeta.rawget(CachedMetamethod.EQ) && OperationHelper.call(state, h2, left, right).toBoolean();
            }
        }
        return left == right || left.raweq(right);
    }

    public static LuaValue length(LuaState state, LuaValue value) throws LuaError, UnwindThrowable {
        return OperationHelper.length(state, value, -1);
    }

    public static LuaValue length(LuaState state, LuaValue value, int stack) throws LuaError, UnwindThrowable {
        switch (value.type()) {
            case 5: {
                LuaValue h2 = value.metatag(state, CachedMetamethod.LEN);
                if (h2.isNil()) {
                    return LuaInteger.valueOf(((LuaTable)value).length());
                }
                return OperationHelper.call(state, h2, value);
            }
            case 4: {
                return LuaInteger.valueOf(((LuaBaseString)value).length());
            }
        }
        LuaValue h3 = value.metatag(state, CachedMetamethod.LEN);
        if (h3.isNil()) {
            throw ErrorFactory.operandError(state, value, "get length of", stack);
        }
        return OperationHelper.call(state, h3, value);
    }

    public static LuaValue neg(LuaState state, LuaValue value) throws LuaError, UnwindThrowable {
        return OperationHelper.neg(state, value, -1);
    }

    public static LuaValue neg(LuaState state, LuaValue value, int stack) throws LuaError, UnwindThrowable {
        double res;
        int type = value.type();
        if (type == 3) {
            int x;
            if (value instanceof LuaInteger && (x = ((LuaInteger)value).v) != Integer.MIN_VALUE) {
                return LuaInteger.valueOf(-x);
            }
            return LuaDouble.valueOf(-value.toDouble());
        }
        if (type == 4 && !Double.isNaN(res = value.toDouble())) {
            return LuaDouble.valueOf(-res);
        }
        LuaValue meta = value.metatag(state, Constants.UNM);
        if (meta.isNil()) {
            throw ErrorFactory.operandError(state, value, "perform arithmetic on", stack);
        }
        return OperationHelper.call(state, meta, value);
    }

    private static boolean checkNumber(LuaValue lua2, double value) {
        return lua2.type() == 3 || !Double.isNaN(value);
    }

    public static LuaValue call(LuaState state, LuaValue function) throws LuaError, UnwindThrowable {
        return OperationHelper.call(state, function, -1);
    }

    public static LuaValue call(LuaState state, LuaValue function, int stack) throws LuaError, UnwindThrowable {
        if (function.isFunction()) {
            return ((LuaFunction)function).call(state);
        }
        LuaValue meta = function.metatag(state, Constants.CALL);
        if (!meta.isFunction()) {
            throw ErrorFactory.operandError(state, function, "call", stack);
        }
        return ((LuaFunction)meta).call(state, function);
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg) throws LuaError, UnwindThrowable {
        return OperationHelper.call(state, function, arg, -1);
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg, int stack) throws LuaError, UnwindThrowable {
        if (function.isFunction()) {
            return ((LuaFunction)function).call(state, arg);
        }
        LuaValue meta = function.metatag(state, Constants.CALL);
        if (!meta.isFunction()) {
            throw ErrorFactory.operandError(state, function, "call", stack);
        }
        return ((LuaFunction)meta).call(state, function, arg);
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg1, LuaValue arg2) throws LuaError, UnwindThrowable {
        return OperationHelper.call(state, function, arg1, arg2, -1);
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg1, LuaValue arg2, int stack) throws LuaError, UnwindThrowable {
        if (function.isFunction()) {
            return ((LuaFunction)function).call(state, arg1, arg2);
        }
        LuaValue meta = function.metatag(state, Constants.CALL);
        if (!meta.isFunction()) {
            throw ErrorFactory.operandError(state, function, "call", stack);
        }
        return ((LuaFunction)meta).call(state, function, arg1, arg2);
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg1, LuaValue arg2, LuaValue arg3) throws LuaError, UnwindThrowable {
        return OperationHelper.call(state, function, arg1, arg2, arg3, -1);
    }

    public static LuaValue call(LuaState state, LuaValue function, LuaValue arg1, LuaValue arg2, LuaValue arg3, int stack) throws LuaError, UnwindThrowable {
        if (function.isFunction()) {
            return ((LuaFunction)function).call(state, arg1, arg2, arg3);
        }
        LuaValue meta = function.metatag(state, Constants.CALL);
        if (!meta.isFunction()) {
            throw ErrorFactory.operandError(state, function, "call", stack);
        }
        return ((LuaFunction)meta).invoke(state, ValueFactory.varargsOf(function, arg1, arg2, arg3)).first();
    }

    public static Varargs invoke(LuaState state, LuaValue function, Varargs args) throws LuaError, UnwindThrowable {
        return OperationHelper.invoke(state, function, args, -1);
    }

    public static Varargs invoke(LuaState state, LuaValue function, Varargs args, int stack) throws LuaError, UnwindThrowable {
        if (function.isFunction()) {
            return ((LuaFunction)function).invoke(state, args);
        }
        LuaValue meta = function.metatag(state, Constants.CALL);
        if (!meta.isFunction()) {
            throw ErrorFactory.operandError(state, function, "call", stack);
        }
        return ((LuaFunction)meta).invoke(state, ValueFactory.varargsOf(function, args));
    }

    public static LuaValue getTable(LuaState state, LuaValue t2, LuaValue key) throws LuaError, UnwindThrowable {
        return OperationHelper.getTable(state, t2, key, -1);
    }

    public static LuaValue getTable(LuaState state, LuaValue t2, LuaValue key, int stack) throws LuaError, UnwindThrowable {
        int loop = 0;
        do {
            LuaValue tm;
            if (t2.isTable()) {
                LuaValue res = ((LuaTable)t2).rawget(key);
                if (!res.isNil() || (tm = t2.metatag(state, CachedMetamethod.INDEX)).isNil()) {
                    return res;
                }
            } else {
                tm = t2.metatag(state, CachedMetamethod.INDEX);
                if (tm.isNil()) {
                    throw ErrorFactory.operandError(state, t2, "index", stack);
                }
            }
            if (tm.isFunction()) {
                return ((LuaFunction)tm).call(state, t2, key);
            }
            t2 = tm;
            stack = -1;
        } while (++loop < 100);
        throw new LuaError("loop in gettable");
    }

    public static void setTable(LuaState state, LuaValue t2, LuaValue key, LuaValue value) throws LuaError, UnwindThrowable {
        OperationHelper.setTable(state, t2, key, value, -1);
    }

    public static void setTable(LuaState state, LuaValue t2, LuaValue key, LuaValue value, int stack) throws LuaError, UnwindThrowable {
        int loop = 0;
        do {
            LuaValue tm;
            if (t2.isTable()) {
                LuaTable table = (LuaTable)t2;
                key.checkValidKey();
                if (!table.rawget(key).isNil() || (tm = t2.metatag(state, CachedMetamethod.NEWINDEX)).isNil()) {
                    table.rawset(key, value);
                    return;
                }
            } else {
                tm = t2.metatag(state, CachedMetamethod.NEWINDEX);
                if (tm.isNil()) {
                    throw ErrorFactory.operandError(state, t2, "index", stack);
                }
            }
            if (tm.isFunction()) {
                ((LuaFunction)tm).call(state, t2, key, value);
                return;
            }
            t2 = tm;
            stack = -1;
        } while (++loop < 100);
        throw new LuaError("loop in settable");
    }

    public static <T> T noUnwind(LuaState state, LuaRunnable<T> task) throws LuaError {
        LuaThread.State threadState = state.getCurrentThread().state;
        ++threadState.javaCount;
        try {
            T t2 = task.run();
            return t2;
        }
        catch (UnwindThrowable e) {
            throw new NonResumableException("Cannot raise UnwindThrowable while disabled");
        }
        finally {
            --threadState.javaCount;
        }
    }

    public static void noUnwind(LuaState state, LuaTask task) throws LuaError {
        LuaThread.State threadState = state.getCurrentThread().state;
        ++threadState.javaCount;
        try {
            task.run();
        }
        catch (UnwindThrowable e) {
            throw new NonResumableException("Cannot raise UnwindThrowable while disabled");
        }
        finally {
            --threadState.javaCount;
        }
    }

    public static LuaValue toString(LuaState state, LuaValue value) throws LuaError, UnwindThrowable {
        LuaValue h2 = value.metatag(state, Constants.TOSTRING);
        return h2.isNil() ? OperationHelper.toStringDirect(value) : OperationHelper.call(state, h2, value);
    }

    public static LuaString checkToString(LuaValue value) throws LuaError {
        LuaValue asStr = value.toLuaString();
        if (asStr.isNil()) {
            throw new LuaError("'__tostring' must return a string");
        }
        return (LuaString)asStr;
    }

    public static LuaString toStringDirect(LuaValue value) {
        LuaValue v = value.toLuaString();
        return v.isNil() ? LuaString.valueOf(value.toString()) : (LuaString)v;
    }

    public static interface LuaTask {
        public void run() throws LuaError, UnwindThrowable;
    }

    public static interface LuaRunnable<T> {
        public T run() throws LuaError, UnwindThrowable;
    }
}

