/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.compiler;

import java.util.Hashtable;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.LuaDouble;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.OperationHelper;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.UnwindThrowable;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.InstructionPtr;
import org.squiddev.cobalt.compiler.IntPtr;
import org.squiddev.cobalt.compiler.LexState;
import org.squiddev.cobalt.compiler.LuaC;
import org.squiddev.cobalt.function.LocalVariable;

public class FuncState {
    Prototype f;
    Hashtable<LuaValue, Integer> htable;
    FuncState prev;
    LexState ls;
    LuaC L;
    BlockCnt bl;
    int pc;
    int lasttarget;
    IntPtr jpc;
    int freereg;
    int nk;
    int np;
    short nlocvars;
    short nactvar;
    upvaldesc[] upvalues = new upvaldesc[60];
    short[] actvar = new short[200];

    FuncState() {
    }

    InstructionPtr getcodePtr(LexState.expdesc e) {
        return new InstructionPtr(this.f.code, e.u.s.info);
    }

    int getcode(LexState.expdesc e) {
        return this.f.code[e.u.s.info];
    }

    int codeAsBx(int o, int A2, int sBx) throws CompileException {
        return this.codeABx(o, A2, sBx + 131071);
    }

    void setmultret(LexState.expdesc e) throws CompileException {
        this.setreturns(e, -1);
    }

    LocalVariable getlocvar(int i) {
        return this.f.locvars[this.actvar[i]];
    }

    void checklimit(int v, int l, String msg) throws CompileException {
        if (v > l) {
            this.errorlimit(l, msg);
        }
    }

    private void errorlimit(int limit, String what) throws CompileException {
        String msg = this.f.linedefined == 0 ? "main function has more than " + limit + " " + what : "function at line " + this.f.linedefined + " has more than " + limit + " " + what;
        throw this.ls.lexError(msg, 0);
    }

    private int indexupvalue(LuaString name, LexState.expdesc v) throws CompileException {
        for (int i = 0; i < this.f.nups; ++i) {
            if (this.upvalues[i].k != v.k || this.upvalues[i].info != v.u.s.info) continue;
            LuaC._assert(this.f.upvalues[i] == name);
            return i;
        }
        this.checklimit(this.f.nups + 1, 60, "upvalues");
        if (this.f.upvalues == null || this.f.nups + 1 > this.f.upvalues.length) {
            this.f.upvalues = LuaC.realloc(this.f.upvalues, this.f.nups * 2 + 1);
        }
        this.f.upvalues[this.f.nups] = name;
        LuaC._assert(v.k == 6 || v.k == 7);
        this.upvalues[this.f.nups] = new upvaldesc();
        this.upvalues[this.f.nups].k = (short)v.k;
        this.upvalues[this.f.nups].info = (short)v.u.s.info;
        return this.f.nups++;
    }

    private int searchvar(LuaString n) {
        for (int i = this.nactvar - 1; i >= 0; --i) {
            if (n != this.getlocvar((int)i).name) continue;
            return i;
        }
        return -1;
    }

    private void markupval(int level) {
        BlockCnt bl = this.bl;
        while (bl != null && bl.nactvar > level) {
            bl = bl.previous;
        }
        if (bl != null) {
            bl.upval = true;
        }
    }

    int singlevaraux(LuaString n, LexState.expdesc var, int base) throws CompileException {
        int v = this.searchvar(n);
        if (v >= 0) {
            var.init(6, v);
            if (base == 0) {
                this.markupval(v);
            }
            return 6;
        }
        if (this.prev == null) {
            var.init(8, 255);
            return 8;
        }
        if (this.prev.singlevaraux(n, var, 0) == 8) {
            return 8;
        }
        var.u.s.info = this.indexupvalue(n, var);
        var.k = 7;
        return 7;
    }

    void enterblock(BlockCnt bl, boolean isbreakable) throws CompileException {
        bl.breaklist.i = -1;
        bl.isbreakable = isbreakable;
        bl.nactvar = this.nactvar;
        bl.upval = false;
        bl.previous = this.bl;
        this.bl = bl;
        LuaC._assert(this.freereg == this.nactvar);
    }

    void leaveblock() throws CompileException {
        BlockCnt bl = this.bl;
        this.bl = bl.previous;
        this.ls.removevars(bl.nactvar);
        if (bl.upval) {
            this.codeABC(35, bl.nactvar, 0, 0);
        }
        LuaC._assert(!bl.isbreakable || !bl.upval);
        LuaC._assert(bl.nactvar == this.nactvar);
        this.freereg = this.nactvar;
        this.patchtohere(bl.breaklist.i);
    }

    void closelistfield(LexState.ConsControl cc) throws CompileException {
        if (cc.v.k == 0) {
            return;
        }
        this.exp2nextreg(cc.v);
        cc.v.k = 0;
        if (cc.tostore == 50) {
            this.setlist(cc.t.u.s.info, cc.na, cc.tostore);
            cc.tostore = 0;
        }
    }

    private boolean hasmultret(int k) {
        return k == 13 || k == 14;
    }

    void lastlistfield(LexState.ConsControl cc) throws CompileException {
        if (cc.tostore == 0) {
            return;
        }
        if (this.hasmultret(cc.v.k)) {
            this.setmultret(cc.v);
            this.setlist(cc.t.u.s.info, cc.na, -1);
            --cc.na;
        } else {
            if (cc.v.k != 0) {
                this.exp2nextreg(cc.v);
            }
            this.setlist(cc.t.u.s.info, cc.na, cc.tostore);
        }
    }

    void nil(int from, int n) throws CompileException {
        if (this.pc > this.lasttarget) {
            if (this.pc == 0) {
                if (from >= this.nactvar) {
                    return;
                }
            } else {
                InstructionPtr previous = new InstructionPtr(this.f.code, this.pc - 1);
                if (Lua.GET_OPCODE(previous.get()) == 3) {
                    int pfrom = Lua.GETARG_A(previous.get());
                    int pto = Lua.GETARG_B(previous.get());
                    if (pfrom <= from && from <= pto + 1) {
                        if (from + n - 1 > pto) {
                            LuaC.SETARG_B(previous, from + n - 1);
                        }
                        return;
                    }
                }
            }
        }
        this.codeABC(3, from, from + n - 1, 0);
    }

    int jump() throws CompileException {
        int jpc = this.jpc.i;
        this.jpc.i = -1;
        IntPtr j = new IntPtr(this.codeAsBx(22, 0, -1));
        this.concat(j, jpc);
        return j.i;
    }

    void ret(int first, int nret) throws CompileException {
        this.codeABC(30, first, nret + 1, 0);
    }

    private int condjump(int op, int A2, int B, int C2) throws CompileException {
        this.codeABC(op, A2, B, C2);
        return this.jump();
    }

    private void fixjump(int pc, int dest) throws CompileException {
        InstructionPtr jmp = new InstructionPtr(this.f.code, pc);
        int offset = dest - (pc + 1);
        LuaC._assert(dest != -1);
        if (Math.abs(offset) > 131071) {
            throw this.ls.syntaxError("control structure too long");
        }
        LuaC.SETARG_sBx(jmp, offset);
    }

    int getlabel() {
        this.lasttarget = this.pc;
        return this.pc;
    }

    private int getjump(int pc) {
        int offset = Lua.GETARG_sBx(this.f.code[pc]);
        if (offset == -1) {
            return -1;
        }
        return pc + 1 + offset;
    }

    private InstructionPtr getjumpcontrol(int pc) {
        InstructionPtr pi = new InstructionPtr(this.f.code, pc);
        if (pc >= 1 && Lua.testTMode(Lua.GET_OPCODE(pi.code[pi.idx - 1]))) {
            return new InstructionPtr(pi.code, pi.idx - 1);
        }
        return pi;
    }

    private boolean need_value(int list) {
        while (list != -1) {
            int i = this.getjumpcontrol(list).get();
            if (Lua.GET_OPCODE(i) != 27) {
                return true;
            }
            list = this.getjump(list);
        }
        return false;
    }

    private boolean patchtestreg(int node, int reg) {
        InstructionPtr i = this.getjumpcontrol(node);
        if (Lua.GET_OPCODE(i.get()) != 27) {
            return false;
        }
        if (reg != 255 && reg != Lua.GETARG_B(i.get())) {
            LuaC.SETARG_A(i, reg);
        } else {
            i.set(LuaC.CREATE_ABC(26, Lua.GETARG_B(i.get()), 0, Lua.GETARG_C(i.get())));
        }
        return true;
    }

    private void removevalues(int list) {
        while (list != -1) {
            this.patchtestreg(list, 255);
            list = this.getjump(list);
        }
    }

    private void patchlistaux(int list, int vtarget, int reg, int dtarget) throws CompileException {
        while (list != -1) {
            int next = this.getjump(list);
            if (this.patchtestreg(list, reg)) {
                this.fixjump(list, vtarget);
            } else {
                this.fixjump(list, dtarget);
            }
            list = next;
        }
    }

    private void dischargejpc() throws CompileException {
        this.patchlistaux(this.jpc.i, this.pc, 255, this.pc);
        this.jpc.i = -1;
    }

    void patchlist(int list, int target) throws CompileException {
        if (target == this.pc) {
            this.patchtohere(list);
        } else {
            LuaC._assert(target < this.pc);
            this.patchlistaux(list, target, 255, target);
        }
    }

    void patchtohere(int list) throws CompileException {
        this.getlabel();
        this.concat(this.jpc, list);
    }

    void concat(IntPtr l1, int l2) throws CompileException {
        if (l2 == -1) {
            return;
        }
        if (l1.i == -1) {
            l1.i = l2;
        } else {
            int next;
            int list = l1.i;
            while ((next = this.getjump(list)) != -1) {
                list = next;
            }
            this.fixjump(list, l2);
        }
    }

    void checkstack(int n) throws CompileException {
        int newstack = this.freereg + n;
        if (newstack > this.f.maxstacksize) {
            if (newstack >= 250) {
                throw this.ls.syntaxError("function or expression too complex");
            }
            this.f.maxstacksize = newstack;
        }
    }

    void reserveregs(int n) throws CompileException {
        this.checkstack(n);
        this.freereg += n;
    }

    private void freereg(int reg) throws CompileException {
        if (!Lua.ISK(reg) && reg >= this.nactvar) {
            --this.freereg;
            LuaC._assert(reg == this.freereg);
        }
    }

    private void freeexp(LexState.expdesc e) throws CompileException {
        if (e.k == 12) {
            this.freereg(e.u.s.info);
        }
    }

    private int addk(LuaValue v) {
        int idx;
        if (this.htable.containsKey(v)) {
            idx = this.htable.get(v);
        } else {
            idx = this.nk;
            this.htable.put(v, idx);
            Prototype f = this.f;
            if (f.k == null || this.nk + 1 >= f.k.length) {
                f.k = LuaC.realloc(f.k, this.nk * 2 + 1);
            }
            f.k[this.nk++] = v;
        }
        return idx;
    }

    int stringK(LuaString s2) {
        return this.addk(s2);
    }

    int numberK(LuaValue r) {
        int i;
        double d;
        if (r instanceof LuaDouble && (d = r.toDouble()) == (double)(i = (int)d)) {
            r = LuaInteger.valueOf(i);
        }
        return this.addk(r);
    }

    private int boolK(boolean b) {
        return this.addk(b ? Constants.TRUE : Constants.FALSE);
    }

    private int nilK() {
        return this.addk(Constants.NIL);
    }

    void setreturns(LexState.expdesc e, int nresults) throws CompileException {
        if (e.k == 13) {
            LuaC.SETARG_C(this.getcodePtr(e), nresults + 1);
        } else if (e.k == 14) {
            LuaC.SETARG_B(this.getcodePtr(e), nresults + 1);
            LuaC.SETARG_A(this.getcodePtr(e), this.freereg);
            this.reserveregs(1);
        }
    }

    void setoneret(LexState.expdesc e) {
        if (e.k == 13) {
            e.k = 12;
            e.u.s.info = Lua.GETARG_A(this.getcode(e));
        } else if (e.k == 14) {
            LuaC.SETARG_B(this.getcodePtr(e), 2);
            e.k = 11;
        }
    }

    void dischargevars(LexState.expdesc e) throws CompileException {
        switch (e.k) {
            case 6: {
                e.k = 12;
                break;
            }
            case 7: {
                e.u.s.info = this.codeABC(4, 0, e.u.s.info, 0);
                e.k = 11;
                break;
            }
            case 8: {
                e.u.s.info = this.codeABx(5, 0, e.u.s.info);
                e.k = 11;
                break;
            }
            case 9: {
                this.freereg(e.u.s.aux);
                this.freereg(e.u.s.info);
                e.u.s.info = this.codeABC(6, 0, e.u.s.info, e.u.s.aux);
                e.k = 11;
                break;
            }
            case 13: 
            case 14: {
                this.setoneret(e);
                break;
            }
        }
    }

    private int code_label(int A2, int b, int jump) throws CompileException {
        this.getlabel();
        return this.codeABC(2, A2, b, jump);
    }

    private void discharge2reg(LexState.expdesc e, int reg) throws CompileException {
        this.dischargevars(e);
        switch (e.k) {
            case 1: {
                this.nil(reg, 1);
                break;
            }
            case 2: 
            case 3: {
                this.codeABC(2, reg, e.k == 2 ? 1 : 0, 0);
                break;
            }
            case 4: {
                this.codeABx(1, reg, e.u.s.info);
                break;
            }
            case 5: {
                this.codeABx(1, reg, this.numberK(e.u.nval()));
                break;
            }
            case 11: {
                InstructionPtr pc = this.getcodePtr(e);
                LuaC.SETARG_A(pc, reg);
                break;
            }
            case 12: {
                if (reg == e.u.s.info) break;
                this.codeABC(0, reg, e.u.s.info, 0);
                break;
            }
            default: {
                LuaC._assert(e.k == 0 || e.k == 10);
                return;
            }
        }
        e.u.s.info = reg;
        e.k = 12;
    }

    private void discharge2anyreg(LexState.expdesc e) throws CompileException {
        if (e.k != 12) {
            this.reserveregs(1);
            this.discharge2reg(e, this.freereg - 1);
        }
    }

    private void exp2reg(LexState.expdesc e, int reg) throws CompileException {
        this.discharge2reg(e, reg);
        if (e.k == 10) {
            this.concat(e.t, e.u.s.info);
        }
        if (e.hasjumps()) {
            int p_f = -1;
            int p_t = -1;
            if (this.need_value(e.t.i) || this.need_value(e.f.i)) {
                int fj = e.k == 10 ? -1 : this.jump();
                p_f = this.code_label(reg, 0, 1);
                p_t = this.code_label(reg, 1, 0);
                this.patchtohere(fj);
            }
            int _final = this.getlabel();
            this.patchlistaux(e.f.i, _final, reg, p_f);
            this.patchlistaux(e.t.i, _final, reg, p_t);
        }
        e.t.i = -1;
        e.f.i = -1;
        e.u.s.info = reg;
        e.k = 12;
    }

    void exp2nextreg(LexState.expdesc e) throws CompileException {
        this.dischargevars(e);
        this.freeexp(e);
        this.reserveregs(1);
        this.exp2reg(e, this.freereg - 1);
    }

    int exp2anyreg(LexState.expdesc e) throws CompileException {
        this.dischargevars(e);
        if (e.k == 12) {
            if (!e.hasjumps()) {
                return e.u.s.info;
            }
            if (e.u.s.info >= this.nactvar) {
                this.exp2reg(e, e.u.s.info);
                return e.u.s.info;
            }
        }
        this.exp2nextreg(e);
        return e.u.s.info;
    }

    void exp2val(LexState.expdesc e) throws CompileException {
        if (e.hasjumps()) {
            this.exp2anyreg(e);
        } else {
            this.dischargevars(e);
        }
    }

    int exp2RK(LexState.expdesc e) throws CompileException {
        this.exp2val(e);
        switch (e.k) {
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                if (this.nk > 255) break;
                e.u.s.info = e.k == 1 ? this.nilK() : (e.k == 5 ? this.numberK(e.u.nval()) : this.boolK(e.k == 2));
                e.k = 4;
                return Lua.RKASK(e.u.s.info);
            }
            case 4: {
                if (e.u.s.info > 255) break;
                return Lua.RKASK(e.u.s.info);
            }
        }
        return this.exp2anyreg(e);
    }

    void storevar(LexState.expdesc var, LexState.expdesc ex) throws CompileException {
        switch (var.k) {
            case 6: {
                this.freeexp(ex);
                this.exp2reg(ex, var.u.s.info);
                return;
            }
            case 7: {
                int e = this.exp2anyreg(ex);
                this.codeABC(8, e, var.u.s.info, 0);
                break;
            }
            case 8: {
                int e = this.exp2anyreg(ex);
                this.codeABx(7, e, var.u.s.info);
                break;
            }
            case 9: {
                int e = this.exp2RK(ex);
                this.codeABC(9, var.u.s.info, var.u.s.aux, e);
                break;
            }
            default: {
                LuaC._assert(false);
            }
        }
        this.freeexp(ex);
    }

    void self(LexState.expdesc e, LexState.expdesc key) throws CompileException {
        this.exp2anyreg(e);
        this.freeexp(e);
        int func = this.freereg;
        this.reserveregs(2);
        this.codeABC(11, func, e.u.s.info, this.exp2RK(key));
        this.freeexp(key);
        e.u.s.info = func;
        e.k = 12;
    }

    private void invertjump(LexState.expdesc e) throws CompileException {
        InstructionPtr pc = this.getjumpcontrol(e.u.s.info);
        LuaC._assert(Lua.testTMode(Lua.GET_OPCODE(pc.get())) && Lua.GET_OPCODE(pc.get()) != 27 && Lua.GET_OPCODE(pc.get()) != 26);
        int a = Lua.GETARG_A(pc.get());
        int nota = a != 0 ? 0 : 1;
        LuaC.SETARG_A(pc, nota);
    }

    private int jumponcond(LexState.expdesc e, int cond) throws CompileException {
        int ie;
        if (e.k == 11 && Lua.GET_OPCODE(ie = this.getcode(e)) == 19) {
            --this.pc;
            return this.condjump(26, Lua.GETARG_B(ie), 0, cond != 0 ? 0 : 1);
        }
        this.discharge2anyreg(e);
        this.freeexp(e);
        return this.condjump(27, 255, e.u.s.info, cond);
    }

    void goiftrue(LexState.expdesc e) throws CompileException {
        int pc;
        this.dischargevars(e);
        switch (e.k) {
            case 2: 
            case 4: 
            case 5: {
                pc = -1;
                break;
            }
            case 3: {
                pc = this.jump();
                break;
            }
            case 10: {
                this.invertjump(e);
                pc = e.u.s.info;
                break;
            }
            default: {
                pc = this.jumponcond(e, 0);
            }
        }
        this.concat(e.f, pc);
        this.patchtohere(e.t.i);
        e.t.i = -1;
    }

    private void goiffalse(LexState.expdesc e) throws CompileException {
        int pc;
        this.dischargevars(e);
        switch (e.k) {
            case 1: 
            case 3: {
                pc = -1;
                break;
            }
            case 2: {
                pc = this.jump();
                break;
            }
            case 10: {
                pc = e.u.s.info;
                break;
            }
            default: {
                pc = this.jumponcond(e, 1);
            }
        }
        this.concat(e.t, pc);
        this.patchtohere(e.f.i);
        e.f.i = -1;
    }

    private void codenot(LexState.expdesc e) throws CompileException {
        this.dischargevars(e);
        switch (e.k) {
            case 1: 
            case 3: {
                e.k = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                e.k = 3;
                break;
            }
            case 10: {
                this.invertjump(e);
                break;
            }
            case 11: 
            case 12: {
                this.discharge2anyreg(e);
                this.freeexp(e);
                e.u.s.info = this.codeABC(19, 0, e.u.s.info, 0);
                e.k = 11;
                break;
            }
            default: {
                LuaC._assert(false);
            }
        }
        int temp = e.f.i;
        e.f.i = e.t.i;
        e.t.i = temp;
        this.removevalues(e.f.i);
        this.removevalues(e.t.i);
    }

    void indexed(LexState.expdesc t2, LexState.expdesc k) throws CompileException {
        t2.u.s.aux = this.exp2RK(k);
        t2.k = 9;
    }

    private boolean constfolding(int op, LexState.expdesc e1, LexState.expdesc e2) throws CompileException {
        LuaValue r;
        if (!e1.isnumeral() || !e2.isnumeral()) {
            return false;
        }
        LuaValue v1 = e1.u.nval();
        LuaValue v2 = e2.u.nval();
        try {
            switch (op) {
                case 12: {
                    r = OperationHelper.add(null, v1, v2);
                    break;
                }
                case 13: {
                    r = OperationHelper.sub(null, v1, v2);
                    break;
                }
                case 14: {
                    r = OperationHelper.mul(null, v1, v2);
                    break;
                }
                case 15: {
                    r = OperationHelper.div(null, v1, v2);
                    break;
                }
                case 16: {
                    r = OperationHelper.mod(null, v1, v2);
                    break;
                }
                case 17: {
                    r = OperationHelper.pow(null, v1, v2);
                    break;
                }
                case 18: {
                    r = OperationHelper.neg(null, v1);
                    break;
                }
                case 20: {
                    return false;
                }
                default: {
                    LuaC._assert(false);
                    r = null;
                    break;
                }
            }
        }
        catch (LuaError | UnwindThrowable e) {
            return false;
        }
        if (Double.isNaN(r.toDouble())) {
            return false;
        }
        e1.u.setNval(r);
        return true;
    }

    private void codearith(int op, LexState.expdesc e1, LexState.expdesc e2) throws CompileException {
        if (!this.constfolding(op, e1, e2)) {
            int o2 = op != 18 && op != 20 ? this.exp2RK(e2) : 0;
            int o1 = this.exp2RK(e1);
            if (o1 > o2) {
                this.freeexp(e1);
                this.freeexp(e2);
            } else {
                this.freeexp(e2);
                this.freeexp(e1);
            }
            e1.u.s.info = this.codeABC(op, 0, o1, o2);
            e1.k = 11;
        }
    }

    private void codecomp(int op, int cond, LexState.expdesc e1, LexState.expdesc e2) throws CompileException {
        int o1 = this.exp2RK(e1);
        int o2 = this.exp2RK(e2);
        this.freeexp(e2);
        this.freeexp(e1);
        if (cond == 0 && op != 23) {
            int temp = o1;
            o1 = o2;
            o2 = temp;
            cond = 1;
        }
        e1.u.s.info = this.condjump(op, cond, o1, o2);
        e1.k = 10;
    }

    void prefix(int op, LexState.expdesc e) throws CompileException {
        LexState.expdesc e2 = new LexState.expdesc();
        e2.init(5, 0);
        switch (op) {
            case 0: {
                if (e.k == 4) {
                    this.exp2anyreg(e);
                }
                this.codearith(18, e, e2);
                break;
            }
            case 1: {
                this.codenot(e);
                break;
            }
            case 2: {
                this.exp2anyreg(e);
                this.codearith(20, e, e2);
                break;
            }
            default: {
                LuaC._assert(false);
            }
        }
    }

    void infix(int op, LexState.expdesc v) throws CompileException {
        switch (op) {
            case 13: {
                this.goiftrue(v);
                break;
            }
            case 14: {
                this.goiffalse(v);
                break;
            }
            case 6: {
                this.exp2nextreg(v);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (v.isnumeral()) break;
                this.exp2RK(v);
                break;
            }
            default: {
                this.exp2RK(v);
            }
        }
    }

    void posfix(int op, LexState.expdesc e1, LexState.expdesc e2) throws CompileException {
        switch (op) {
            case 13: {
                LuaC._assert(e1.t.i == -1);
                this.dischargevars(e2);
                this.concat(e2.f, e1.f.i);
                e1.setvalue(e2);
                break;
            }
            case 14: {
                LuaC._assert(e1.f.i == -1);
                this.dischargevars(e2);
                this.concat(e2.t, e1.t.i);
                e1.setvalue(e2);
                break;
            }
            case 6: {
                this.exp2val(e2);
                if (e2.k == 11 && Lua.GET_OPCODE(this.getcode(e2)) == 21) {
                    LuaC._assert(e1.u.s.info == Lua.GETARG_B(this.getcode(e2)) - 1);
                    this.freeexp(e1);
                    LuaC.SETARG_B(this.getcodePtr(e2), e1.u.s.info);
                    e1.k = 11;
                    e1.u.s.info = e2.u.s.info;
                    break;
                }
                this.exp2nextreg(e2);
                this.codearith(21, e1, e2);
                break;
            }
            case 0: {
                this.codearith(12, e1, e2);
                break;
            }
            case 1: {
                this.codearith(13, e1, e2);
                break;
            }
            case 2: {
                this.codearith(14, e1, e2);
                break;
            }
            case 3: {
                this.codearith(15, e1, e2);
                break;
            }
            case 4: {
                this.codearith(16, e1, e2);
                break;
            }
            case 5: {
                this.codearith(17, e1, e2);
                break;
            }
            case 8: {
                this.codecomp(23, 1, e1, e2);
                break;
            }
            case 7: {
                this.codecomp(23, 0, e1, e2);
                break;
            }
            case 9: {
                this.codecomp(24, 1, e1, e2);
                break;
            }
            case 10: {
                this.codecomp(25, 1, e1, e2);
                break;
            }
            case 11: {
                this.codecomp(24, 0, e1, e2);
                break;
            }
            case 12: {
                this.codecomp(25, 0, e1, e2);
                break;
            }
            default: {
                LuaC._assert(false);
            }
        }
    }

    void fixline(int line) {
        this.f.lineinfo[this.pc - 1] = line;
    }

    private int code(int instruction, int line) throws CompileException {
        Prototype f = this.f;
        this.dischargejpc();
        if (f.code == null || this.pc + 1 > f.code.length) {
            f.code = LuaC.realloc(f.code, this.pc * 2 + 1);
        }
        f.code[this.pc] = instruction;
        if (f.lineinfo == null || this.pc + 1 > f.lineinfo.length) {
            f.lineinfo = LuaC.realloc(f.lineinfo, this.pc * 2 + 1);
        }
        f.lineinfo[this.pc] = line;
        return this.pc++;
    }

    int codeABC(int o, int a, int b, int c) throws CompileException {
        LuaC._assert(Lua.getOpMode(o) == 0);
        LuaC._assert(Lua.getBMode(o) != 0 || b == 0);
        LuaC._assert(Lua.getCMode(o) != 0 || c == 0);
        return this.code(LuaC.CREATE_ABC(o, a, b, c), this.ls.lastline);
    }

    int codeABx(int o, int a, int bc) throws CompileException {
        LuaC._assert(Lua.getOpMode(o) == 1 || Lua.getOpMode(o) == 2);
        LuaC._assert(Lua.getCMode(o) == 0);
        return this.code(LuaC.CREATE_ABx(o, a, bc), this.ls.lastline);
    }

    private void setlist(int base, int nelems, int tostore) throws CompileException {
        int c = (nelems - 1) / 50 + 1;
        int b = tostore == -1 ? 0 : tostore;
        LuaC._assert(tostore != 0);
        if (c <= 511) {
            this.codeABC(34, base, b, c);
        } else {
            this.codeABC(34, base, b, 0);
            this.code(c, this.ls.lastline);
        }
        this.freereg = base + 1;
    }

    static class BlockCnt {
        BlockCnt previous;
        IntPtr breaklist = new IntPtr();
        short nactvar;
        boolean upval;
        boolean isbreakable;

        BlockCnt() {
        }
    }

    class upvaldesc {
        short k;
        short info;

        upvaldesc() {
        }
    }
}

