/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import org.squiddev.cobalt.Lua;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Prototype;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.compiler.CompileException;
import org.squiddev.cobalt.compiler.FuncState;
import org.squiddev.cobalt.compiler.InstructionPtr;
import org.squiddev.cobalt.compiler.IntPtr;
import org.squiddev.cobalt.compiler.LuaC;
import org.squiddev.cobalt.function.LocalVariable;
import org.squiddev.cobalt.lib.Utf8Lib;

public class LexState {
    private static final String RESERVED_LOCAL_VAR_FOR_CONTROL = "(for control)";
    private static final String RESERVED_LOCAL_VAR_FOR_STATE = "(for state)";
    private static final String RESERVED_LOCAL_VAR_FOR_GENERATOR = "(for generator)";
    private static final String RESERVED_LOCAL_VAR_FOR_STEP = "(for step)";
    private static final String RESERVED_LOCAL_VAR_FOR_LIMIT = "(for limit)";
    private static final String RESERVED_LOCAL_VAR_FOR_INDEX = "(for index)";
    private static final String[] RESERVED_LOCAL_VAR_KEYWORDS = new String[]{"(for control)", "(for generator)", "(for index)", "(for limit)", "(for state)", "(for step)"};
    private static final Hashtable<String, Boolean> RESERVED_LOCAL_VAR_KEYWORDS_TABLE = new Hashtable();
    private static final int EOZ = -1;
    private static final int MAXSRC = 80;
    private static final int MAX_INT = 0x7FFFFFFD;
    private static final int UCHAR_MAX = 255;
    private static final int LUAI_MAXCCALLS = 200;
    private static final int LUA_COMPAT_LSTR = 1;
    private static final boolean LUA_COMPAT_VARARG = true;
    static final int NO_JUMP = -1;
    static final int OPR_ADD = 0;
    static final int OPR_SUB = 1;
    static final int OPR_MUL = 2;
    static final int OPR_DIV = 3;
    static final int OPR_MOD = 4;
    static final int OPR_POW = 5;
    static final int OPR_CONCAT = 6;
    static final int OPR_NE = 7;
    static final int OPR_EQ = 8;
    static final int OPR_LT = 9;
    static final int OPR_LE = 10;
    static final int OPR_GT = 11;
    static final int OPR_GE = 12;
    static final int OPR_AND = 13;
    static final int OPR_OR = 14;
    static final int OPR_NOBINOPR = 15;
    static final int OPR_MINUS = 0;
    static final int OPR_NOT = 1;
    static final int OPR_LEN = 2;
    static final int OPR_NOUNOPR = 3;
    static final int VVOID = 0;
    static final int VNIL = 1;
    static final int VTRUE = 2;
    static final int VFALSE = 3;
    static final int VK = 4;
    static final int VKNUM = 5;
    static final int VLOCAL = 6;
    static final int VUPVAL = 7;
    static final int VGLOBAL = 8;
    static final int VINDEXED = 9;
    static final int VJMP = 10;
    static final int VRELOCABLE = 11;
    static final int VNONRELOC = 12;
    static final int VCALL = 13;
    static final int VVARARG = 14;
    private int current;
    private int linenumber;
    int lastline;
    private final Token t = new Token();
    private final Token lookahead = new Token();
    FuncState fs;
    private InputStream z;
    private byte[] buff;
    private int nbuff;
    private LuaString source;
    private byte decpoint;
    public int nCcalls;
    private final HashMap<LuaString, LuaString> strings = new HashMap();
    private static final String[] luaX_tokens;
    static final int TK_AND = 257;
    static final int TK_BREAK = 258;
    static final int TK_DO = 259;
    static final int TK_ELSE = 260;
    static final int TK_ELSEIF = 261;
    static final int TK_END = 262;
    static final int TK_FALSE = 263;
    static final int TK_FOR = 264;
    static final int TK_FUNCTION = 265;
    static final int TK_IF = 266;
    static final int TK_IN = 267;
    static final int TK_LOCAL = 268;
    static final int TK_NIL = 269;
    static final int TK_NOT = 270;
    static final int TK_OR = 271;
    static final int TK_REPEAT = 272;
    static final int TK_RETURN = 273;
    static final int TK_THEN = 274;
    static final int TK_TRUE = 275;
    static final int TK_UNTIL = 276;
    static final int TK_WHILE = 277;
    static final int TK_CONCAT = 278;
    static final int TK_DOTS = 279;
    static final int TK_EQ = 280;
    static final int TK_GE = 281;
    static final int TK_LE = 282;
    static final int TK_NE = 283;
    static final int TK_EOS = 284;
    static final int TK_NUMBER = 285;
    static final int TK_NAME = 286;
    static final int TK_STRING = 287;
    private static final int FIRST_RESERVED = 257;
    private static final int NUM_RESERVED = 21;
    private static final Hashtable<LuaString, Integer> RESERVED;
    private static Priority[] priority;
    private static final int UNARY_PRIORITY = 8;

    private static String LUA_QS(String s2) {
        return "'" + s2 + "'";
    }

    private static String LUA_QL(Object o) {
        return LexState.LUA_QS(String.valueOf(o));
    }

    public static boolean isReservedKeyword(String varName) {
        return RESERVED_LOCAL_VAR_KEYWORDS_TABLE.containsKey(varName);
    }

    private static boolean isAlphaNum(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95;
    }

    private static boolean isAlpha(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90;
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isSpace(int c) {
        return c <= 32;
    }

    private static boolean isHex(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    public LexState(InputStream stream) {
        this.z = stream;
        this.buff = new byte[32];
    }

    private void nextChar() {
        try {
            this.current = this.z.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.current = -1;
        }
    }

    private boolean currIsNewline() {
        return this.current == 10 || this.current == 13;
    }

    private void save_and_next() {
        this.save(this.current);
        this.nextChar();
    }

    private void save(int c) {
        if (this.buff == null || this.nbuff + 1 > this.buff.length) {
            this.buff = LuaC.realloc(this.buff, this.nbuff * 2 + 1);
        }
        this.buff[this.nbuff++] = (byte)c;
    }

    private String token2str(int token) {
        if (token < 257) {
            return LexState.LUA_QS(LexState.iscntrl(token) ? "char(" + token + ")" : String.valueOf((char)token));
        }
        String name = luaX_tokens[token - 257];
        return token < 284 ? LexState.LUA_QS(name) : name;
    }

    private static boolean iscntrl(int token) {
        return token < 32;
    }

    private String txtToken(int token) {
        switch (token) {
            case 285: 
            case 286: 
            case 287: {
                return LexState.LUA_QS(new String(this.buff, 0, this.nbuff));
            }
        }
        return this.token2str(token);
    }

    CompileException lexError(String msg, int token) {
        String cid = this.chunkId(this.source.toString());
        String message = cid + ":" + this.linenumber + ": " + msg;
        if (token != 0) {
            message = message + " near " + this.txtToken(token);
        }
        return new CompileException(message);
    }

    String chunkId(String source) {
        if (source.startsWith("=")) {
            return source.substring(1);
        }
        String end = "";
        if (source.startsWith("@")) {
            source = source.substring(1);
        } else {
            source = "[string \"" + source;
            end = "\"]";
        }
        int n = source.length() + end.length();
        if (n > 80) {
            source = source.substring(0, 80 - end.length() - 3) + "...";
        }
        return source + end;
    }

    CompileException syntaxError(String msg) {
        return this.lexError(msg, this.t.token);
    }

    public LuaString newString(byte[] bytes, int offset, int len) {
        LuaString tmp = LuaString.valueOf(bytes, offset, len);
        LuaString v = this.strings.get(tmp);
        if (v == null) {
            byte[] copy = new byte[len];
            System.arraycopy(bytes, offset, copy, 0, len);
            v = LuaString.valueOf(copy);
            this.strings.put(v, v);
        }
        return v;
    }

    private LuaString newString(String s2) {
        byte[] b = s2.getBytes();
        return this.newString(b, 0, b.length);
    }

    private void inclineNumber() throws CompileException {
        int old = this.current;
        LuaC._assert(this.currIsNewline());
        this.nextChar();
        if (this.currIsNewline() && this.current != old) {
            this.nextChar();
        }
        if (++this.linenumber >= 0x7FFFFFFD) {
            throw this.syntaxError("chunk has too many lines");
        }
    }

    void setinput(int firstByte, InputStream z, LuaString source) {
        this.decpoint = (byte)46;
        this.lookahead.token = 284;
        this.z = z;
        this.fs = null;
        this.linenumber = 1;
        this.lastline = 1;
        this.source = source;
        this.nbuff = 0;
        this.current = firstByte;
        this.skipShebang();
    }

    private void skipShebang() {
        if (this.current == 35) {
            while (!this.currIsNewline() && this.current != -1) {
                this.nextChar();
            }
        }
    }

    private boolean check_next(String set) {
        if (set.indexOf(this.current) < 0) {
            return false;
        }
        this.save_and_next();
        return true;
    }

    private void buffreplace(byte from, byte to) {
        int n = this.nbuff;
        byte[] p = this.buff;
        while (--n >= 0) {
            if (p[n] != from) continue;
            p[n] = to;
        }
    }

    private void str2d(String str, SemInfo seminfo) throws CompileException {
        if (str.startsWith("0x") || str.startsWith("0X")) {
            try {
                seminfo.r = ValueFactory.valueOf(Long.valueOf(str.substring(2), 16).longValue());
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            seminfo.r = ValueFactory.valueOf(Double.parseDouble(str));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw this.lexError("malformed number", 285);
        }
    }

    private void read_numeral(SemInfo seminfo) throws CompileException {
        LuaC._assert(LexState.isDigit(this.current));
        int first = this.current;
        this.save_and_next();
        String exp = "Ee";
        if (first == 48 && this.check_next("xX")) {
            exp = "Pp";
        }
        while (true) {
            if (this.check_next(exp)) {
                this.check_next("+-");
            }
            if (!LexState.isHex(this.current) && this.current != 46) break;
            this.save_and_next();
        }
        String str = new String(this.buff, 0, this.nbuff);
        this.str2d(str, seminfo);
    }

    private int skip_sep() throws CompileException {
        int count = 0;
        int s2 = this.current;
        LuaC._assert(s2 == 91 || s2 == 93);
        this.save_and_next();
        while (this.current == 61) {
            this.save_and_next();
            ++count;
        }
        return this.current == s2 ? count : -count - 1;
    }

    private void read_long_string(SemInfo seminfo, int sep) throws CompileException {
        int cont = 0;
        this.save_and_next();
        if (this.currIsNewline()) {
            this.inclineNumber();
        }
        boolean endloop = false;
        block6: while (!endloop) {
            switch (this.current) {
                case -1: {
                    String msg = seminfo != null ? "unfinished long string" : "unfinished long comment";
                    throw this.lexError(msg, 284);
                }
                case 91: {
                    if (this.skip_sep() != sep) continue block6;
                    this.save_and_next();
                    ++cont;
                    if (sep != 0) continue block6;
                    throw this.lexError("nesting of [[...]] is deprecated", 91);
                }
                case 93: {
                    if (this.skip_sep() != sep) continue block6;
                    this.save_and_next();
                    endloop = true;
                    continue block6;
                }
                case 10: 
                case 13: {
                    this.save(10);
                    this.inclineNumber();
                    if (seminfo != null) continue block6;
                    this.nbuff = 0;
                    continue block6;
                }
            }
            if (seminfo != null) {
                this.save_and_next();
                continue;
            }
            this.nextChar();
        }
        if (seminfo != null) {
            seminfo.ts = this.newString(this.buff, 2 + sep, this.nbuff - 2 * (2 + sep));
        }
    }

    private void read_string(int del, SemInfo seminfo) throws CompileException {
        this.save_and_next();
        block19: while (this.current != del) {
            switch (this.current) {
                case -1: {
                    throw this.lexError("unfinished string", 284);
                }
                case 10: 
                case 13: {
                    throw this.lexError("unfinished string", 287);
                }
                case 92: {
                    this.save_and_next();
                    switch (this.current) {
                        case 97: {
                            this.saveEscape(7);
                            continue block19;
                        }
                        case 98: {
                            this.saveEscape(8);
                            continue block19;
                        }
                        case 102: {
                            this.saveEscape(12);
                            continue block19;
                        }
                        case 110: {
                            this.saveEscape(10);
                            continue block19;
                        }
                        case 114: {
                            this.saveEscape(13);
                            continue block19;
                        }
                        case 116: {
                            this.saveEscape(9);
                            continue block19;
                        }
                        case 118: {
                            this.saveEscape(11);
                            continue block19;
                        }
                        case 120: {
                            this.saveEscape(this.readHexEsc());
                            continue block19;
                        }
                        case 117: {
                            this.readUtf8Esc();
                            continue block19;
                        }
                        case 10: 
                        case 13: {
                            --this.nbuff;
                            this.save(10);
                            this.inclineNumber();
                            continue block19;
                        }
                        case -1: {
                            continue block19;
                        }
                        case 122: {
                            --this.nbuff;
                            this.nextChar();
                            while (LexState.isSpace(this.current)) {
                                if (this.currIsNewline()) {
                                    this.inclineNumber();
                                }
                                this.nextChar();
                            }
                            continue block19;
                        }
                    }
                    if (!LexState.isDigit(this.current)) {
                        --this.nbuff;
                        this.save_and_next();
                        continue block19;
                    }
                    int c = this.readDecEsc();
                    --this.nbuff;
                    this.save(c);
                    continue block19;
                }
            }
            this.save_and_next();
        }
        this.save_and_next();
        seminfo.ts = this.newString(this.buff, 1, this.nbuff - 2);
    }

    private void saveEscape(int character) {
        this.nextChar();
        --this.nbuff;
        this.save(character);
    }

    private int readHexEsc() throws CompileException {
        int r = this.readHex() << 4 | this.readHex();
        this.nbuff -= 2;
        return r;
    }

    private int readDecEsc() throws CompileException {
        int i;
        int result = 0;
        for (i = 0; i < 3 && LexState.isDigit(this.current); ++i) {
            result = 10 * result + this.current - 48;
            this.save_and_next();
        }
        if (result > 255) {
            throw this.escapeError("escape sequence too large");
        }
        this.nbuff -= i;
        return result;
    }

    private void readUtf8Esc() throws CompileException {
        long codepoint;
        int i;
        block6: {
            this.save_and_next();
            if (this.current != 123) {
                throw this.escapeError("mising '{'");
            }
            i = 4;
            codepoint = this.readHex();
            do {
                this.save_and_next();
                if (!LexState.isHex(this.current)) break block6;
                ++i;
            } while ((codepoint = codepoint << 4 | (long)LexState.hexValue(this.current)) <= 0x10FFFFL);
            throw this.escapeError("UTF-8 value too large");
        }
        if (this.current != 125) {
            throw this.escapeError("missing '}'");
        }
        this.nextChar();
        this.nbuff -= i;
        if (codepoint < 128L) {
            this.save((int)codepoint);
        } else {
            byte[] buffer = new byte[8];
            for (int j = Utf8Lib.buildCharacter(buffer, codepoint); j > 0; --j) {
                this.save(buffer[8 - j]);
            }
        }
    }

    private int readHex() throws CompileException {
        this.save_and_next();
        if (!LexState.isHex(this.current)) {
            throw this.escapeError("hexadecimal digit expected");
        }
        return LexState.hexValue(this.current);
    }

    private static int hexValue(int c) {
        return c <= 57 ? c - 48 : (c & 0xF) + 9;
    }

    private CompileException escapeError(String message) {
        if (this.current != -1) {
            this.save_and_next();
        }
        return this.lexError(message, 287);
    }

    private int llex(SemInfo seminfo) throws CompileException {
        this.nbuff = 0;
        block12: while (true) {
            switch (this.current) {
                case 10: 
                case 13: {
                    this.inclineNumber();
                    continue block12;
                }
                case 45: {
                    int sep;
                    this.nextChar();
                    if (this.current != 45) {
                        return 45;
                    }
                    this.nextChar();
                    if (this.current == 91) {
                        sep = this.skip_sep();
                        this.nbuff = 0;
                        if (sep >= 0) {
                            this.read_long_string(null, sep);
                            this.nbuff = 0;
                            continue block12;
                        }
                    }
                    while (true) {
                        if (this.currIsNewline() || this.current == -1) continue block12;
                        this.nextChar();
                    }
                }
                case 91: {
                    int sep = this.skip_sep();
                    if (sep >= 0) {
                        this.read_long_string(seminfo, sep);
                        return 287;
                    }
                    if (sep == -1) {
                        return 91;
                    }
                    throw this.lexError("invalid long string delimiter", 287);
                }
                case 61: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 61;
                    }
                    this.nextChar();
                    return 280;
                }
                case 60: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 60;
                    }
                    this.nextChar();
                    return 282;
                }
                case 62: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 62;
                    }
                    this.nextChar();
                    return 281;
                }
                case 126: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 126;
                    }
                    this.nextChar();
                    return 283;
                }
                case 34: 
                case 39: {
                    this.read_string(this.current, seminfo);
                    return 287;
                }
                case 46: {
                    this.save_and_next();
                    if (this.check_next(".")) {
                        if (this.check_next(".")) {
                            return 279;
                        }
                        return 278;
                    }
                    if (!LexState.isDigit(this.current)) {
                        return 46;
                    }
                    this.read_numeral(seminfo);
                    return 285;
                }
                case -1: {
                    return 284;
                }
            }
            if (!LexState.isSpace(this.current)) break;
            LuaC._assert(!this.currIsNewline());
            this.nextChar();
        }
        if (LexState.isDigit(this.current)) {
            this.read_numeral(seminfo);
            return 285;
        }
        if (LexState.isAlpha(this.current) || this.current == 95) {
            do {
                this.save_and_next();
            } while (LexState.isAlphaNum(this.current) || this.current == 95);
            LuaString ts = this.newString(this.buff, 0, this.nbuff);
            if (RESERVED.containsKey(ts)) {
                return RESERVED.get(ts);
            }
            seminfo.ts = ts;
            return 286;
        }
        int c = this.current;
        this.nextChar();
        return c;
    }

    void nextToken() throws CompileException {
        this.lastline = this.linenumber;
        if (this.lookahead.token != 284) {
            this.t.set(this.lookahead);
            this.lookahead.token = 284;
        } else {
            this.t.token = this.llex(this.t.seminfo);
        }
    }

    private void lookahead() throws CompileException {
        LuaC._assert(this.lookahead.token == 284);
        this.lookahead.token = this.llex(this.lookahead.seminfo);
    }

    private boolean hasmultret(int k) {
        return k == 13 || k == 14;
    }

    private void error_expected(int token) throws CompileException {
        throw this.syntaxError(this.token2str(token) + " expected");
    }

    private boolean testnext(int c) throws CompileException {
        if (this.t.token == c) {
            this.nextToken();
            return true;
        }
        return false;
    }

    void check(int c) throws CompileException {
        if (this.t.token != c) {
            this.error_expected(c);
        }
    }

    private void checknext(int c) throws CompileException {
        this.check(c);
        this.nextToken();
    }

    private void check_condition(boolean c, String msg) throws CompileException {
        if (!c) {
            throw this.syntaxError(msg);
        }
    }

    private void check_match(int what, int who, int where) throws CompileException {
        if (!this.testnext(what)) {
            if (where == this.linenumber) {
                this.error_expected(what);
            } else {
                throw this.syntaxError(LexState.LUA_QS(this.token2str(what)) + " expected (to close " + LexState.LUA_QS(this.token2str(who)) + " at line " + where + ")");
            }
        }
    }

    private LuaString str_checkname() throws CompileException {
        this.check(286);
        LuaString ts = this.t.seminfo.ts;
        this.nextToken();
        return ts;
    }

    private void codestring(expdesc e, LuaString s2) {
        e.init(4, this.fs.stringK(s2));
    }

    private void checkname(expdesc e) throws CompileException {
        this.codestring(e, this.str_checkname());
    }

    private int registerlocalvar(LuaString varname) {
        FuncState fs = this.fs;
        Prototype f = fs.f;
        if (f.locvars == null || fs.nlocvars + 1 > f.locvars.length) {
            f.locvars = LuaC.realloc(f.locvars, fs.nlocvars * 2 + 1);
        }
        f.locvars[fs.nlocvars] = new LocalVariable(varname, 0, 0);
        short s2 = fs.nlocvars;
        fs.nlocvars = (short)(s2 + 1);
        return s2;
    }

    private void new_localvarliteral(String v, int n) throws CompileException {
        LuaString ts = this.newString(v);
        this.new_localvar(ts, n);
    }

    private void new_localvar(LuaString name, int n) throws CompileException {
        FuncState fs = this.fs;
        fs.checklimit(fs.nactvar + n + 1, 200, "local variables");
        fs.actvar[fs.nactvar + n] = (short)this.registerlocalvar(name);
    }

    private void adjustlocalvars(int nvars) {
        FuncState fs = this.fs;
        fs.nactvar = (short)(fs.nactvar + nvars);
        while (nvars > 0) {
            fs.getlocvar((int)(fs.nactvar - nvars)).startpc = fs.pc;
            --nvars;
        }
    }

    void removevars(int tolevel) {
        FuncState fs = this.fs;
        while (fs.nactvar > tolevel) {
            fs.nactvar = (short)(fs.nactvar - 1);
            fs.getlocvar((int)((short)(fs.nactvar - 1))).endpc = fs.pc;
        }
    }

    private void singlevar(expdesc var) throws CompileException {
        FuncState fs = this.fs;
        LuaString varname = this.str_checkname();
        if (fs.singlevaraux(varname, var, 1) == 8) {
            var.u.s.info = fs.stringK(varname);
        }
    }

    private void adjust_assign(int nvars, int nexps, expdesc e) throws CompileException {
        FuncState fs = this.fs;
        int extra = nvars - nexps;
        if (this.hasmultret(e.k)) {
            if (++extra < 0) {
                extra = 0;
            }
            fs.setreturns(e, extra);
            if (extra > 1) {
                fs.reserveregs(extra - 1);
            }
        } else {
            if (e.k != 0) {
                fs.exp2nextreg(e);
            }
            if (extra > 0) {
                int reg = fs.freereg;
                fs.reserveregs(extra);
                fs.nil(reg, extra);
            }
        }
    }

    private void enterlevel() throws CompileException {
        if (++this.nCcalls > 200) {
            throw this.lexError("chunk has too many syntax levels", 0);
        }
    }

    private void leavelevel() {
        --this.nCcalls;
    }

    private void pushclosure(FuncState func, expdesc v) throws CompileException {
        FuncState fs = this.fs;
        Prototype f = fs.f;
        if (f.p == null || fs.np + 1 > f.p.length) {
            f.p = LuaC.realloc(f.p, fs.np * 2 + 1);
        }
        f.p[fs.np++] = func.f;
        v.init(11, fs.codeABx(36, 0, fs.np - 1));
        for (int i = 0; i < func.f.nups; ++i) {
            int o = func.upvalues[i].k == 6 ? 0 : 4;
            fs.codeABC(o, 0, func.upvalues[i].info, 0);
        }
    }

    void open_func(FuncState fs) {
        Prototype f = new Prototype();
        if (this.fs != null) {
            f.source = this.fs.f.source;
        }
        fs.f = f;
        fs.prev = this.fs;
        fs.ls = this;
        this.fs = fs;
        fs.pc = 0;
        fs.lasttarget = -1;
        fs.jpc = new IntPtr(-1);
        fs.freereg = 0;
        fs.nk = 0;
        fs.np = 0;
        fs.nlocvars = 0;
        fs.nactvar = 0;
        fs.bl = null;
        f.maxstacksize = 2;
        fs.htable = new Hashtable();
    }

    void close_func() throws CompileException {
        FuncState fs = this.fs;
        Prototype f = fs.f;
        this.removevars(0);
        fs.ret(0, 0);
        f.code = LuaC.realloc(f.code, fs.pc);
        f.lineinfo = LuaC.realloc(f.lineinfo, fs.pc);
        f.k = LuaC.realloc(f.k, fs.nk);
        f.p = LuaC.realloc(f.p, fs.np);
        f.locvars = LuaC.realloc(f.locvars, (int)fs.nlocvars);
        f.upvalues = LuaC.realloc(f.upvalues, f.nups);
        LuaC._assert(fs.bl == null);
        this.fs = fs.prev;
    }

    private void field(expdesc v) throws CompileException {
        FuncState fs = this.fs;
        expdesc key = new expdesc();
        fs.exp2anyreg(v);
        this.nextToken();
        this.checkname(key);
        fs.indexed(v, key);
    }

    private void yindex(expdesc v) throws CompileException {
        this.nextToken();
        this.expr(v);
        this.fs.exp2val(v);
        this.checknext(93);
    }

    private void recfield(ConsControl cc) throws CompileException {
        FuncState fs = this.fs;
        int reg = this.fs.freereg;
        expdesc key = new expdesc();
        expdesc val = new expdesc();
        if (this.t.token == 286) {
            fs.checklimit(cc.nh, 0x7FFFFFFD, "items in a constructor");
            this.checkname(key);
        } else {
            this.yindex(key);
        }
        ++cc.nh;
        this.checknext(61);
        int rkkey = fs.exp2RK(key);
        this.expr(val);
        fs.codeABC(9, cc.t.u.s.info, rkkey, fs.exp2RK(val));
        fs.freereg = reg;
    }

    private void listfield(ConsControl cc) throws CompileException {
        this.expr(cc.v);
        this.fs.checklimit(cc.na, 0x7FFFFFFD, "items in a constructor");
        ++cc.na;
        ++cc.tostore;
    }

    private void constructor(expdesc t2) throws CompileException {
        FuncState fs = this.fs;
        int line = this.linenumber;
        int pc = fs.codeABC(10, 0, 0, 0);
        ConsControl cc = new ConsControl();
        cc.tostore = 0;
        cc.nh = 0;
        cc.na = 0;
        cc.t = t2;
        t2.init(11, pc);
        cc.v.init(0, 0);
        fs.exp2nextreg(t2);
        this.checknext(123);
        do {
            LuaC._assert(cc.v.k == 0 || cc.tostore > 0);
            if (this.t.token == 125) break;
            fs.closelistfield(cc);
            switch (this.t.token) {
                case 286: {
                    this.lookahead();
                    if (this.lookahead.token != 61) {
                        this.listfield(cc);
                        break;
                    }
                    this.recfield(cc);
                    break;
                }
                case 91: {
                    this.recfield(cc);
                    break;
                }
                default: {
                    this.listfield(cc);
                }
            }
        } while (this.testnext(44) || this.testnext(59));
        this.check_match(125, 123, line);
        fs.lastlistfield(cc);
        InstructionPtr i = new InstructionPtr(fs.f.code, pc);
        LuaC.SETARG_B(i, LexState.luaO_int2fb(cc.na));
        LuaC.SETARG_C(i, LexState.luaO_int2fb(cc.nh));
    }

    private static int luaO_int2fb(int x) {
        int e = 0;
        while (x >= 16) {
            x = x + 1 >> 1;
            ++e;
        }
        if (x < 8) {
            return x;
        }
        return e + 1 << 3 | x - 8;
    }

    private void parlist() throws CompileException {
        FuncState fs = this.fs;
        Prototype f = fs.f;
        int nparams = 0;
        f.is_vararg = 0;
        if (this.t.token != 41) {
            do {
                switch (this.t.token) {
                    case 286: {
                        this.new_localvar(this.str_checkname(), nparams++);
                        break;
                    }
                    case 279: {
                        this.nextToken();
                        this.new_localvarliteral("arg", nparams++);
                        f.is_vararg = 5;
                        f.is_vararg |= 2;
                        break;
                    }
                    default: {
                        throw this.syntaxError("<name> or " + LexState.LUA_QL("...") + " expected");
                    }
                }
            } while (f.is_vararg == 0 && this.testnext(44));
        }
        this.adjustlocalvars(nparams);
        f.numparams = fs.nactvar - (f.is_vararg & 1);
        fs.reserveregs(fs.nactvar);
    }

    private void body(expdesc e, boolean needself, int line) throws CompileException {
        FuncState new_fs = new FuncState();
        this.open_func(new_fs);
        new_fs.f.linedefined = line;
        this.checknext(40);
        if (needself) {
            this.new_localvarliteral("self", 0);
            this.adjustlocalvars(1);
        }
        this.parlist();
        this.checknext(41);
        this.chunk();
        new_fs.f.lastlinedefined = this.linenumber;
        this.check_match(262, 265, line);
        this.close_func();
        this.pushclosure(new_fs, e);
    }

    private int explist1(expdesc v) throws CompileException {
        int n = 1;
        this.expr(v);
        while (this.testnext(44)) {
            this.fs.exp2nextreg(v);
            this.expr(v);
            ++n;
        }
        return n;
    }

    private void funcargs(expdesc f) throws CompileException {
        int nparams;
        FuncState fs = this.fs;
        expdesc args = new expdesc();
        int line = this.linenumber;
        switch (this.t.token) {
            case 40: {
                if (line != this.lastline) {
                    throw this.syntaxError("ambiguous syntax (function call x new statement)");
                }
                this.nextToken();
                if (this.t.token == 41) {
                    args.k = 0;
                } else {
                    this.explist1(args);
                    fs.setmultret(args);
                }
                this.check_match(41, 40, line);
                break;
            }
            case 123: {
                this.constructor(args);
                break;
            }
            case 287: {
                this.codestring(args, this.t.seminfo.ts);
                this.nextToken();
                break;
            }
            default: {
                throw this.syntaxError("function arguments expected");
            }
        }
        LuaC._assert(f.k == 12);
        int base = f.u.s.info;
        if (this.hasmultret(args.k)) {
            nparams = -1;
        } else {
            if (args.k != 0) {
                fs.exp2nextreg(args);
            }
            nparams = fs.freereg - (base + 1);
        }
        f.init(13, fs.codeABC(28, base, nparams + 1, 2));
        fs.fixline(line);
        fs.freereg = base + 1;
    }

    private void prefixexp(expdesc v) throws CompileException {
        switch (this.t.token) {
            case 40: {
                int line = this.linenumber;
                this.nextToken();
                this.expr(v);
                this.check_match(41, 40, line);
                this.fs.dischargevars(v);
                return;
            }
            case 286: {
                this.singlevar(v);
                return;
            }
        }
        throw this.syntaxError("unexpected symbol");
    }

    private void primaryexp(expdesc v) throws CompileException {
        FuncState fs = this.fs;
        this.prefixexp(v);
        block6: while (true) {
            switch (this.t.token) {
                case 46: {
                    this.field(v);
                    continue block6;
                }
                case 91: {
                    expdesc key = new expdesc();
                    fs.exp2anyreg(v);
                    this.yindex(key);
                    fs.indexed(v, key);
                    continue block6;
                }
                case 58: {
                    expdesc key = new expdesc();
                    this.nextToken();
                    this.checkname(key);
                    fs.self(v, key);
                    this.funcargs(v);
                    continue block6;
                }
                case 40: 
                case 123: 
                case 287: {
                    fs.exp2nextreg(v);
                    this.funcargs(v);
                    continue block6;
                }
            }
            break;
        }
    }

    private void simpleexp(expdesc v) throws CompileException {
        switch (this.t.token) {
            case 285: {
                v.init(5, 0);
                v.u.setNval(this.t.seminfo.r);
                break;
            }
            case 287: {
                this.codestring(v, this.t.seminfo.ts);
                break;
            }
            case 269: {
                v.init(1, 0);
                break;
            }
            case 275: {
                v.init(2, 0);
                break;
            }
            case 263: {
                v.init(3, 0);
                break;
            }
            case 279: {
                FuncState fs = this.fs;
                this.check_condition(fs.f.is_vararg != 0, "cannot use " + LexState.LUA_QL("...") + " outside a vararg function");
                fs.f.is_vararg &= 0xFFFFFFFB;
                v.init(14, fs.codeABC(37, 0, 1, 0));
                break;
            }
            case 123: {
                this.constructor(v);
                return;
            }
            case 265: {
                this.nextToken();
                this.body(v, false, this.linenumber);
                return;
            }
            default: {
                this.primaryexp(v);
                return;
            }
        }
        this.nextToken();
    }

    private int getunopr(int op) {
        switch (op) {
            case 270: {
                return 1;
            }
            case 45: {
                return 0;
            }
            case 35: {
                return 2;
            }
        }
        return 3;
    }

    private int getbinopr(int op) {
        switch (op) {
            case 43: {
                return 0;
            }
            case 45: {
                return 1;
            }
            case 42: {
                return 2;
            }
            case 47: {
                return 3;
            }
            case 37: {
                return 4;
            }
            case 94: {
                return 5;
            }
            case 278: {
                return 6;
            }
            case 283: {
                return 7;
            }
            case 280: {
                return 8;
            }
            case 60: {
                return 9;
            }
            case 282: {
                return 10;
            }
            case 62: {
                return 11;
            }
            case 281: {
                return 12;
            }
            case 257: {
                return 13;
            }
            case 271: {
                return 14;
            }
        }
        return 15;
    }

    private int subexpr(expdesc v, int limit) throws CompileException {
        this.enterlevel();
        int uop = this.getunopr(this.t.token);
        if (uop != 3) {
            this.nextToken();
            this.subexpr(v, 8);
            this.fs.prefix(uop, v);
        } else {
            this.simpleexp(v);
        }
        int op = this.getbinopr(this.t.token);
        while (op != 15 && LexState.priority[op].left > limit) {
            expdesc v2 = new expdesc();
            this.nextToken();
            this.fs.infix(op, v);
            int nextop = this.subexpr(v2, LexState.priority[op].right);
            this.fs.posfix(op, v, v2);
            op = nextop;
        }
        this.leavelevel();
        return op;
    }

    private void expr(expdesc v) throws CompileException {
        this.subexpr(v, 0);
    }

    private boolean block_follow(int token) {
        switch (token) {
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 284: {
                return true;
            }
        }
        return false;
    }

    private void block() throws CompileException {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        fs.enterblock(bl, false);
        this.chunk();
        LuaC._assert(bl.breaklist.i == -1);
        fs.leaveblock();
    }

    private void check_conflict(LHS_assign lh, expdesc v) throws CompileException {
        FuncState fs = this.fs;
        int extra = fs.freereg;
        boolean conflict = false;
        while (lh != null) {
            if (lh.v.k == 9) {
                if (lh.v.u.s.info == v.u.s.info) {
                    conflict = true;
                    lh.v.u.s.info = extra;
                }
                if (lh.v.u.s.aux == v.u.s.info) {
                    conflict = true;
                    lh.v.u.s.aux = extra;
                }
            }
            lh = lh.prev;
        }
        if (conflict) {
            fs.codeABC(0, fs.freereg, v.u.s.info, 0);
            fs.reserveregs(1);
        }
    }

    private void assignment(LHS_assign lh, int nvars) throws CompileException {
        expdesc e = new expdesc();
        this.check_condition(6 <= lh.v.k && lh.v.k <= 9, "syntax error");
        if (this.testnext(44)) {
            LHS_assign nv = new LHS_assign();
            nv.prev = lh;
            this.primaryexp(nv.v);
            if (nv.v.k == 6) {
                this.check_conflict(lh, nv.v);
            }
            this.assignment(nv, nvars + 1);
        } else {
            this.checknext(61);
            int nexps = this.explist1(e);
            if (nexps != nvars) {
                this.adjust_assign(nvars, nexps, e);
                if (nexps > nvars) {
                    this.fs.freereg -= nexps - nvars;
                }
            } else {
                this.fs.setoneret(e);
                this.fs.storevar(lh.v, e);
                return;
            }
        }
        e.init(12, this.fs.freereg - 1);
        this.fs.storevar(lh.v, e);
    }

    private int cond() throws CompileException {
        expdesc v = new expdesc();
        this.expr(v);
        if (v.k == 1) {
            v.k = 3;
        }
        this.fs.goiftrue(v);
        return v.f.i;
    }

    private void breakstat() throws CompileException {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = fs.bl;
        boolean upval = false;
        while (bl != null && !bl.isbreakable) {
            upval |= bl.upval;
            bl = bl.previous;
        }
        if (bl == null) {
            throw this.syntaxError("no loop to break");
        }
        if (upval) {
            fs.codeABC(35, bl.nactvar, 0, 0);
        }
        fs.concat(bl.breaklist, fs.jump());
    }

    private void whilestat(int line) throws CompileException {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        this.nextToken();
        int whileinit = fs.getlabel();
        int condexit = this.cond();
        fs.enterblock(bl, true);
        this.checknext(259);
        this.block();
        fs.patchlist(fs.jump(), whileinit);
        this.check_match(262, 277, line);
        fs.leaveblock();
        fs.patchtohere(condexit);
    }

    private void repeatstat(int line) throws CompileException {
        FuncState fs = this.fs;
        int repeat_init = fs.getlabel();
        FuncState.BlockCnt bl1 = new FuncState.BlockCnt();
        FuncState.BlockCnt bl2 = new FuncState.BlockCnt();
        fs.enterblock(bl1, true);
        fs.enterblock(bl2, false);
        this.nextToken();
        this.chunk();
        this.check_match(276, 272, line);
        int condexit = this.cond();
        if (!bl2.upval) {
            fs.leaveblock();
            fs.patchlist(condexit, repeat_init);
        } else {
            this.breakstat();
            fs.patchtohere(condexit);
            fs.leaveblock();
            fs.patchlist(fs.jump(), repeat_init);
        }
        fs.leaveblock();
    }

    private int exp1() throws CompileException {
        expdesc e = new expdesc();
        this.expr(e);
        int k = e.k;
        this.fs.exp2nextreg(e);
        return k;
    }

    private void forbody(int base, int line, int nvars, boolean isnum) throws CompileException {
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        FuncState fs = this.fs;
        this.adjustlocalvars(3);
        this.checknext(259);
        int prep = isnum ? fs.codeAsBx(32, base, -1) : fs.jump();
        fs.enterblock(bl, false);
        this.adjustlocalvars(nvars);
        fs.reserveregs(nvars);
        this.block();
        fs.leaveblock();
        fs.patchtohere(prep);
        int endfor = isnum ? fs.codeAsBx(31, base, -1) : fs.codeABC(33, base, 0, nvars);
        fs.fixline(line);
        fs.patchlist(isnum ? endfor : fs.jump(), prep + 1);
    }

    private void fornum(LuaString varname, int line) throws CompileException {
        FuncState fs = this.fs;
        int base = fs.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_INDEX, 0);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_LIMIT, 1);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STEP, 2);
        this.new_localvar(varname, 3);
        this.checknext(61);
        this.exp1();
        this.checknext(44);
        this.exp1();
        if (this.testnext(44)) {
            this.exp1();
        } else {
            fs.codeABx(1, fs.freereg, fs.numberK(LuaInteger.valueOf(1)));
            fs.reserveregs(1);
        }
        this.forbody(base, line, 1, true);
    }

    private void forlist(LuaString indexname) throws CompileException {
        FuncState fs = this.fs;
        expdesc e = new expdesc();
        int nvars = 0;
        int base = fs.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_GENERATOR, nvars++);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STATE, nvars++);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_CONTROL, nvars++);
        this.new_localvar(indexname, nvars++);
        while (this.testnext(44)) {
            this.new_localvar(this.str_checkname(), nvars++);
        }
        this.checknext(267);
        int line = this.linenumber;
        this.adjust_assign(3, this.explist1(e), e);
        fs.checkstack(3);
        this.forbody(base, line, nvars - 3, false);
    }

    private void forstat(int line) throws CompileException {
        FuncState fs = this.fs;
        FuncState.BlockCnt bl = new FuncState.BlockCnt();
        fs.enterblock(bl, true);
        this.nextToken();
        LuaString varname = this.str_checkname();
        switch (this.t.token) {
            case 61: {
                this.fornum(varname, line);
                break;
            }
            case 44: 
            case 267: {
                this.forlist(varname);
                break;
            }
            default: {
                throw this.syntaxError(LexState.LUA_QL("=") + " or " + LexState.LUA_QL("in") + " expected");
            }
        }
        this.check_match(262, 264, line);
        fs.leaveblock();
    }

    private int test_then_block() throws CompileException {
        this.nextToken();
        int condexit = this.cond();
        this.checknext(274);
        this.block();
        return condexit;
    }

    private void ifstat(int line) throws CompileException {
        FuncState fs = this.fs;
        IntPtr escapelist = new IntPtr(-1);
        int flist = this.test_then_block();
        while (this.t.token == 261) {
            fs.concat(escapelist, fs.jump());
            fs.patchtohere(flist);
            flist = this.test_then_block();
        }
        if (this.t.token == 260) {
            fs.concat(escapelist, fs.jump());
            fs.patchtohere(flist);
            this.nextToken();
            this.block();
        } else {
            fs.concat(escapelist, flist);
        }
        fs.patchtohere(escapelist.i);
        this.check_match(262, 266, line);
    }

    private void localfunc() throws CompileException {
        expdesc v = new expdesc();
        expdesc b = new expdesc();
        FuncState fs = this.fs;
        this.new_localvar(this.str_checkname(), 0);
        v.init(6, fs.freereg);
        fs.reserveregs(1);
        this.adjustlocalvars(1);
        this.body(b, false, this.linenumber);
        fs.storevar(v, b);
        fs.getlocvar((int)(fs.nactvar - 1)).startpc = fs.pc;
    }

    private void localstat() throws CompileException {
        int nexps;
        int nvars = 0;
        expdesc e = new expdesc();
        do {
            this.new_localvar(this.str_checkname(), nvars++);
        } while (this.testnext(44));
        if (this.testnext(61)) {
            nexps = this.explist1(e);
        } else {
            e.k = 0;
            nexps = 0;
        }
        this.adjust_assign(nvars, nexps, e);
        this.adjustlocalvars(nvars);
    }

    private boolean funcname(expdesc v) throws CompileException {
        boolean needself = false;
        this.singlevar(v);
        while (this.t.token == 46) {
            this.field(v);
        }
        if (this.t.token == 58) {
            needself = true;
            this.field(v);
        }
        return needself;
    }

    private void funcstat(int line) throws CompileException {
        expdesc v = new expdesc();
        expdesc b = new expdesc();
        this.nextToken();
        boolean needself = this.funcname(v);
        this.body(b, needself, line);
        this.fs.storevar(v, b);
        this.fs.fixline(line);
    }

    private void exprstat() throws CompileException {
        FuncState fs = this.fs;
        LHS_assign v = new LHS_assign();
        this.primaryexp(v.v);
        if (v.v.k == 13) {
            LuaC.SETARG_C(fs.getcodePtr(v.v), 1);
        } else {
            v.prev = null;
            this.assignment(v, 1);
        }
    }

    private void retstat() throws CompileException {
        int first;
        int nret;
        FuncState fs = this.fs;
        expdesc e = new expdesc();
        this.nextToken();
        if (this.block_follow(this.t.token) || this.t.token == 59) {
            nret = 0;
            first = 0;
        } else {
            nret = this.explist1(e);
            if (this.hasmultret(e.k)) {
                fs.setmultret(e);
                if (e.k == 13 && nret == 1) {
                    LuaC.SET_OPCODE(fs.getcodePtr(e), 29);
                    LuaC._assert(Lua.GETARG_A(fs.getcode(e)) == fs.nactvar);
                }
                first = fs.nactvar;
                nret = -1;
            } else if (nret == 1) {
                first = fs.exp2anyreg(e);
            } else {
                fs.exp2nextreg(e);
                first = fs.nactvar;
                LuaC._assert(nret == fs.freereg - first);
            }
        }
        fs.ret(first, nret);
    }

    private boolean statement() throws CompileException {
        int line = this.linenumber;
        switch (this.t.token) {
            case 266: {
                this.ifstat(line);
                return false;
            }
            case 277: {
                this.whilestat(line);
                return false;
            }
            case 259: {
                this.nextToken();
                this.block();
                this.check_match(262, 259, line);
                return false;
            }
            case 264: {
                this.forstat(line);
                return false;
            }
            case 272: {
                this.repeatstat(line);
                return false;
            }
            case 265: {
                this.funcstat(line);
                return false;
            }
            case 268: {
                this.nextToken();
                if (this.testnext(265)) {
                    this.localfunc();
                } else {
                    this.localstat();
                }
                return false;
            }
            case 273: {
                this.retstat();
                return true;
            }
            case 258: {
                this.nextToken();
                this.breakstat();
                return true;
            }
        }
        this.exprstat();
        return false;
    }

    void chunk() throws CompileException {
        boolean islast = false;
        this.enterlevel();
        while (!islast && !this.block_follow(this.t.token)) {
            islast = this.statement();
            this.testnext(59);
            LuaC._assert(this.fs.f.maxstacksize >= this.fs.freereg && this.fs.freereg >= this.fs.nactvar);
            this.fs.freereg = this.fs.nactvar;
        }
        this.leavelevel();
    }

    static {
        for (String RESERVED_LOCAL_VAR_KEYWORD : RESERVED_LOCAL_VAR_KEYWORDS) {
            RESERVED_LOCAL_VAR_KEYWORDS_TABLE.put(RESERVED_LOCAL_VAR_KEYWORD, Boolean.TRUE);
        }
        luaX_tokens = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while", "..", "...", "==", ">=", "<=", "~=", "<eof>", "<number>", "<name>", "<string>"};
        RESERVED = new Hashtable();
        for (int i = 0; i < 21; ++i) {
            LuaString ts = ValueFactory.valueOf(luaX_tokens[i]);
            RESERVED.put(ts, 257 + i);
        }
        priority = new Priority[]{new Priority(6, 6), new Priority(6, 6), new Priority(7, 7), new Priority(7, 7), new Priority(7, 7), new Priority(10, 9), new Priority(5, 4), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(2, 2), new Priority(1, 1)};
    }

    static class LHS_assign {
        LHS_assign prev;
        expdesc v = new expdesc();

        LHS_assign() {
        }
    }

    static class Priority {
        final byte left;
        final byte right;

        public Priority(int i, int j) {
            this.left = (byte)i;
            this.right = (byte)j;
        }
    }

    static class ConsControl {
        expdesc v = new expdesc();
        expdesc t;
        int nh;
        int na;
        int tostore;

        ConsControl() {
        }
    }

    static class expdesc {
        int k;
        final U u = new U();
        final IntPtr t = new IntPtr();
        final IntPtr f = new IntPtr();

        expdesc() {
        }

        void init(int k, int i) {
            this.f.i = -1;
            this.t.i = -1;
            this.k = k;
            this.u.s.info = i;
        }

        boolean hasjumps() {
            return this.t.i != this.f.i;
        }

        boolean isnumeral() {
            return this.k == 5 && this.t.i == -1 && this.f.i == -1;
        }

        public void setvalue(expdesc other) {
            this.k = other.k;
            this.u._nval = other.u._nval;
            this.u.s.info = other.u.s.info;
            this.u.s.aux = other.u.s.aux;
            this.t.i = other.t.i;
            this.f.i = other.f.i;
        }

        static class U {
            final S s = new S();
            private LuaValue _nval;

            U() {
            }

            public void setNval(LuaValue r) {
                this._nval = r;
            }

            public LuaValue nval() {
                return this._nval == null ? LuaInteger.valueOf(this.s.info) : this._nval;
            }

            static class S {
                int info;
                int aux;

                S() {
                }
            }
        }
    }

    private static class Token {
        int token;
        final SemInfo seminfo = new SemInfo();

        private Token() {
        }

        public void set(Token other) {
            this.token = other.token;
            this.seminfo.r = other.seminfo.r;
            this.seminfo.ts = other.seminfo.ts;
        }
    }

    private static class SemInfo {
        LuaValue r;
        LuaString ts;

        private SemInfo() {
        }
    }
}

