/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib;

import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.ErrorFactory;
import org.squiddev.cobalt.LuaError;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaState;
import org.squiddev.cobalt.LuaTable;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.ValueFactory;
import org.squiddev.cobalt.Varargs;
import org.squiddev.cobalt.function.LibFunction;
import org.squiddev.cobalt.function.TwoArgFunction;
import org.squiddev.cobalt.function.VarArgFunction;
import org.squiddev.cobalt.lib.LuaLibrary;

public class Bit32Lib
implements LuaLibrary {
    @Override
    public LuaValue add(LuaState state, LuaTable env) {
        LuaTable t2 = new LuaTable();
        LibFunction.bind(t2, Bit32LibV::new, new String[]{"band", "bnot", "bor", "btest", "bxor", "extract", "replace"});
        LibFunction.bind(t2, Bit32Lib2::new, new String[]{"arshift", "lrotate", "lshift", "rrotate", "rshift"});
        env.rawset("bit32", (LuaValue)t2);
        state.loadedPackages.rawset("bit32", (LuaValue)t2);
        return t2;
    }

    static LuaValue rotate(int x, int disp) {
        if (disp < 0) {
            disp = -disp & 0x1F;
            return Bit32Lib.bitsToValue(x >>> disp | x << 32 - disp);
        }
        return Bit32Lib.bitsToValue(x << (disp &= 0x1F) | x >>> 32 - disp);
    }

    static LuaValue shift(int x, int disp) {
        if (disp >= 32 || disp <= -32) {
            return Constants.ZERO;
        }
        if (disp >= 0) {
            return Bit32Lib.bitsToValue(x << disp);
        }
        return Bit32Lib.bitsToValue(x >>> -disp);
    }

    private static LuaValue bitsToValue(int x) {
        return x < 0 ? ValueFactory.valueOf((long)x & 0xFFFFFFFFL) : LuaInteger.valueOf(x);
    }

    public static final class Bit32Lib2
    extends TwoArgFunction {
        @Override
        public LuaValue call(LuaState state, LuaValue arg1, LuaValue arg2) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    int x = arg1.checkInteger();
                    int disp = arg2.checkInteger();
                    return disp >= 0 ? Bit32Lib.bitsToValue(x >> disp) : Bit32Lib.bitsToValue(x << -disp);
                }
                case 1: {
                    return Bit32Lib.rotate(arg1.checkInteger(), arg2.checkInteger());
                }
                case 2: {
                    return Bit32Lib.shift(arg1.checkInteger(), arg2.checkInteger());
                }
                case 3: {
                    return Bit32Lib.rotate(arg1.checkInteger(), -arg2.checkInteger());
                }
                case 4: {
                    return Bit32Lib.shift(arg1.checkInteger(), -arg2.checkInteger());
                }
            }
            return Constants.NIL;
        }
    }

    public static final class Bit32LibV
    extends VarArgFunction {
        @Override
        public Varargs invoke(LuaState state, Varargs args) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    int result = -1;
                    for (int i = 1; i <= args.count(); ++i) {
                        result &= args.arg(i).checkInteger();
                    }
                    return Bit32Lib.bitsToValue(result);
                }
                case 1: {
                    return Bit32Lib.bitsToValue(~args.arg(1).checkInteger());
                }
                case 2: {
                    int result = 0;
                    for (int i = 1; i <= args.count(); ++i) {
                        result |= args.arg(i).checkInteger();
                    }
                    return Bit32Lib.bitsToValue(result);
                }
                case 3: {
                    int bits = -1;
                    for (int i = 1; i <= args.count(); ++i) {
                        bits &= args.arg(i).checkInteger();
                    }
                    return ValueFactory.valueOf(bits != 0);
                }
                case 4: {
                    int result = 0;
                    for (int i = 1; i <= args.count(); ++i) {
                        result ^= args.arg(i).checkInteger();
                    }
                    return Bit32Lib.bitsToValue(result);
                }
                case 5: {
                    int field = args.arg(2).checkInteger();
                    int width = args.arg(3).optInteger(1);
                    if (field < 0) {
                        throw ErrorFactory.argError(2, "field cannot be negative");
                    }
                    if (width <= 0) {
                        throw ErrorFactory.argError(3, "width must be postive");
                    }
                    if (field + width > 32) {
                        throw new LuaError("trying to access non-existent bits");
                    }
                    return Bit32Lib.bitsToValue(args.arg(1).checkInteger() >>> field & -1 >>> 32 - width);
                }
                case 6: {
                    int n = args.arg(1).checkInteger();
                    int v = args.arg(2).checkInteger();
                    int field = args.arg(3).checkInteger();
                    int width = args.arg(4).optInteger(1);
                    if (field < 0) {
                        throw ErrorFactory.argError(3, "field cannot be negative");
                    }
                    if (width <= 0) {
                        throw ErrorFactory.argError(4, "width must be postive");
                    }
                    if (field + width > 32) {
                        throw new LuaError("trying to access non-existent bits");
                    }
                    int mask = -1 >>> 32 - width << field;
                    n = n & ~mask | v << field & mask;
                    return Bit32Lib.bitsToValue(n);
                }
            }
            return Constants.NIL;
        }
    }
}

