/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib.doubles;

import java.util.Arrays;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.squiddev.cobalt.lib.doubles.UnsignedValues;

public class DecimalRepBuf {
    private static final @UnknownVal @Signed int ASCII_ZERO = 48;
    private static final @UnknownVal @Signed int DECIMAL_OVERFLOW = 58;
    private final @UnknownVal @Unsigned char @UnknownVal @UnknownSignedness [] buffer;
    private @UnknownVal @UnknownSignedness boolean sign;
    private @UnknownVal @Signed int length;
    private @UnknownVal @Signed int pointPosition;

    public DecimalRepBuf(@UnknownVal @Signed int size) {
        this.buffer = new char[size];
        this.length = 0;
        this.pointPosition = 0;
    }

    public void addLength(@UnknownVal @Signed int size) {
        this.length += size;
    }

    public void append(@Unsigned @UnknownVal long digit) {
        this.doAppend(UnsignedValues.digitToChar(digit));
    }

    public void append(@Unsigned @UnknownVal int digit) {
        this.doAppend(UnsignedValues.digitToChar(digit));
    }

    public @UnknownVal @Unsigned char charAt(@UnknownVal @Signed int pos) {
        return this.buffer[pos];
    }

    public @UnknownVal @Unsigned char lastChar() {
        return this.buffer[this.length - 1];
    }

    public @UnknownVal @Signed int incrementLast() {
        int overflow = 0;
        int n = this.length - 1;
        this.buffer[n] = (char)(this.buffer[n] + '\u0001');
        for (int i = this.length - 1; i > 0 && this.buffer[i] == ':'; --i) {
            this.buffer[i] = 48;
            int n2 = i - 1;
            this.buffer[n2] = (char)(this.buffer[n2] + '\u0001');
        }
        if (this.buffer[0] == ':') {
            this.buffer[0] = 49;
            overflow = 1;
        }
        return overflow;
    }

    public void incrementLastNoOverflow() {
        if (this.buffer[this.length - 1] == '9') {
            throw new ArithmeticException("Last digit is '9' and so would overflow");
        }
        int n = this.length - 1;
        this.buffer[n] = (char)(this.buffer[n] + '\u0001');
    }

    public @UnknownVal @Signed int length() {
        return this.length;
    }

    public void reverseLast(@UnknownVal @Signed int start) {
        int i = start;
        for (int j = this.length - 1; i < j; ++i, --j) {
            char t2 = this.buffer[i];
            this.buffer[i] = this.buffer[j];
            this.buffer[j] = t2;
        }
    }

    public void clearBuf() {
        this.length = 0;
    }

    public void reset() {
        this.length = 0;
        this.pointPosition = 0;
    }

    public void roundUp() {
        if (this.length() == 0) {
            this.append(1);
            this.setPointPosition(1);
        } else {
            this.pointPosition += this.incrementLast();
        }
    }

    public void setCharAt(@UnknownVal @Signed int index, @Unsigned @UnknownVal int digit) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.buffer[index] = UnsignedValues.digitToChar(digit);
    }

    public @UnknownVal @UnknownSignedness CharSequence subSequence(final @UnknownVal @Signed int start, final @UnknownVal @Signed int end) {
        return new CharSequence(){

            @Override
            public int length() {
                return end - start;
            }

            @Override
            public char charAt(int index) {
                return DecimalRepBuf.this.buffer[start + index];
            }

            @Override
            public CharSequence subSequence(int st, int e) {
                return DecimalRepBuf.this.subSequence(start + st, start + e);
            }

            @Override
            public String toString() {
                return String.valueOf(DecimalRepBuf.this.buffer, start, end - start);
            }
        };
    }

    @SideEffectFree
    public @UnknownVal @UnknownSignedness String toString() {
        return String.valueOf(this.buffer, 0, this.length);
    }

    public void trimZeros() {
        int firstNonZero;
        while (this.length > 0 && this.buffer[this.length - 1] == '0') {
            --this.length;
        }
        for (firstNonZero = 0; firstNonZero < this.length && this.buffer[firstNonZero] == '0'; ++firstNonZero) {
        }
        if (firstNonZero != 0) {
            System.arraycopy(this.buffer, firstNonZero, this.buffer, 0, this.length - firstNonZero);
            this.length -= firstNonZero;
            this.pointPosition -= firstNonZero;
        }
    }

    public void truncateZeros(@UnknownVal @UnknownSignedness boolean exponential) {
        int stop;
        int n = stop = exponential ? 1 : Math.max(1, this.pointPosition);
        while (this.length > stop && this.buffer[this.length - 1] == '0') {
            --this.length;
        }
    }

    public void truncateAllZeros() {
        while (this.length > 0 && this.buffer[this.length - 1] == '0') {
            --this.length;
        }
    }

    public void zeroExtend(@UnknownVal @Signed int targetLength) {
        if (this.length < targetLength) {
            Arrays.fill(this.buffer, this.length, targetLength, '0');
            this.length = targetLength;
        }
    }

    private void doAppend(@UnknownVal @Unsigned char ch) {
        this.buffer[this.length++] = ch;
    }

    public @UnknownVal @Unsigned char @UnknownVal @UnknownSignedness [] getBuffer() {
        return this.buffer;
    }

    public @UnknownVal @UnknownSignedness boolean getSign() {
        return this.sign;
    }

    public void setSign(@UnknownVal @UnknownSignedness boolean sign) {
        this.sign = sign;
    }

    public @UnknownVal @Signed int getPointPosition() {
        return this.pointPosition;
    }

    void setPointPosition(@UnknownVal @Signed int point) {
        this.pointPosition = point;
    }
}

