/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.peripheral.IPeripheralTile;
import dan200.computercraft.api.turtle.event.TurtleAction;
import dan200.computercraft.api.turtle.event.TurtleEvent;
import dan200.computercraft.core.apis.http.options.Action;
import dan200.computercraft.core.apis.http.options.AddressRule;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.common.ComputerCraftBlocks;
import dan200.computercraft.shared.common.ComputerCraftItems;
import dan200.computercraft.shared.common.ComputerCraftPocketUpgrades;
import dan200.computercraft.shared.common.ComputerCraftTurtleUpgrades;
import dan200.computercraft.shared.common.DefaultBundledRedstoneProvider;
import dan200.computercraft.shared.computer.core.ClientComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.media.items.RecordMedia;
import dan200.computercraft.shared.network.client.ComputerDataClientMessage;
import dan200.computercraft.shared.network.client.ComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.OpenGuiComputerClientMessage;
import dan200.computercraft.shared.network.client.OpenGuiDiskDriveClientMessage;
import dan200.computercraft.shared.network.client.OpenGuiPrinterClientMessage;
import dan200.computercraft.shared.network.client.OpenGuiPrintoutClientMessage;
import dan200.computercraft.shared.network.client.OpenGuiTurtleClientMessage;
import dan200.computercraft.shared.network.client.TurtleBrainClientMessage;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.QueueEventServerMessage;
import dan200.computercraft.shared.network.server.RequestComputerMessage;
import dan200.computercraft.shared.peripheral.generic.methods.InventoryMethods;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.turtle.FurnaceRefuelHandler;
import dan200.computercraft.shared.turtle.SignInspectHandler;
import dan200.computercraft.shared.util.Config;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemDiscMusic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import turniplabs.halplibe.helper.network.NetworkHandler;
import turniplabs.halplibe.util.GameStartEntrypoint;

public final class ComputerCraft
implements ModInitializer,
GameStartEntrypoint {
    public static final String MOD_ID = "computercraft";
    public static final ClientComputerRegistry clientComputerRegistry = new ClientComputerRegistry();
    public static final ServerComputerRegistry serverComputerRegistry = new ServerComputerRegistry();
    public static final Logger log = LoggerFactory.getLogger((String)"computercraft");
    public static int startBlockID = 1800;
    public static int startItemID = 19000;
    public static int computerSpaceLimit = 1000000;
    public static int floppySpaceLimit = 125000;
    public static int maximumFilesOpen = 128;
    public static boolean disableLua51Features = false;
    public static String defaultComputerSettings = "";
    public static boolean debugEnable = true;
    public static boolean logComputerErrors = true;
    public static boolean commandRequireCreative = true;
    public static int computerThreads = 1;
    public static long maxMainGlobalTime = TimeUnit.MILLISECONDS.toNanos(10L);
    public static long maxMainComputerTime = TimeUnit.MILLISECONDS.toNanos(5L);
    public static boolean httpEnabled = true;
    public static boolean httpWebsocketEnabled = true;
    public static List<AddressRule> httpRules = Collections.unmodifiableList(Arrays.asList(AddressRule.parse("$private", null, Action.DENY.toPartial()), AddressRule.parse("*", null, Action.ALLOW.toPartial())));
    public static int httpMaxRequests = 16;
    public static int httpMaxWebsockets = 4;
    public static boolean enableCommandBlock = false;
    public static int modemRange = 64;
    public static int modemHighAltitudeRange = 384;
    public static int modemRangeDuringStorm = 64;
    public static int modemHighAltitudeRangeDuringStorm = 384;
    public static int maxNotesPerTick = 8;
    public static MonitorRenderer monitorRenderer = MonitorRenderer.BEST;
    public static double monitorDistanceSq = 4096.0;
    public static long monitorBandwidth = 1000000L;
    public static boolean turtlesNeedFuel = true;
    public static int turtleFuelLimit = 20000;
    public static int advancedTurtleFuelLimit = 100000;
    public static boolean turtlesObeyBlockProtection = true;
    public static boolean turtlesCanPush = true;
    public static EnumSet<TurtleAction> turtleDisabledActions = EnumSet.noneOf(TurtleAction.class);
    public static boolean turtlesCanUseSilkTouch = true;
    public static int computerTermWidth = 51;
    public static int computerTermHeight = 19;
    public static final int turtleTermWidth = 39;
    public static final int turtleTermHeight = 13;
    public static int pocketTermWidth = 26;
    public static int pocketTermHeight = 20;
    public static int monitorWidth = 8;
    public static int monitorHeight = 6;

    public void onInitialize() {
        ComputerCraftBlocks.RegisterBlocks();
        ComputerCraftItems.RegisterItems();
        NetworkHandler.registerNetworkMessage(ComputerActionServerMessage::new);
        NetworkHandler.registerNetworkMessage(QueueEventServerMessage::new);
        NetworkHandler.registerNetworkMessage(RequestComputerMessage::new);
        NetworkHandler.registerNetworkMessage(KeyEventServerMessage::new);
        NetworkHandler.registerNetworkMessage(MouseEventServerMessage::new);
        NetworkHandler.registerNetworkMessage(OpenGuiDiskDriveClientMessage::new);
        NetworkHandler.registerNetworkMessage(OpenGuiPrinterClientMessage::new);
        NetworkHandler.registerNetworkMessage(OpenGuiTurtleClientMessage::new);
        NetworkHandler.registerNetworkMessage(OpenGuiComputerClientMessage::new);
        NetworkHandler.registerNetworkMessage(OpenGuiPrintoutClientMessage::new);
        NetworkHandler.registerNetworkMessage(ComputerDataClientMessage::new);
        NetworkHandler.registerNetworkMessage(ComputerDeletedClientMessage::new);
        NetworkHandler.registerNetworkMessage(ComputerTerminalClientMessage::new);
        NetworkHandler.registerNetworkMessage(MonitorClientMessage::new);
        NetworkHandler.registerNetworkMessage(TurtleBrainClientMessage::new);
        ComputerCraftAPI.registerPeripheralProvider((world, pos, side) -> {
            TileEntity tile = world.getTileEntity(pos.x, pos.y, pos.z);
            return tile instanceof IPeripheralTile ? ((IPeripheralTile)tile).getPeripheral(side) : null;
        });
        ComputerCraftAPI.registerBundledRedstoneProvider(new DefaultBundledRedstoneProvider());
        ComputerCraftAPI.registerMediaProvider(stack -> {
            Item item = stack.getItem();
            if (item instanceof IMedia) {
                return (IMedia)item;
            }
            if (item instanceof ItemDiscMusic) {
                return RecordMedia.INSTANCE;
            }
            return null;
        });
        TurtleEvent.EVENT_BUS.register(FurnaceRefuelHandler.INSTANCE);
        TurtleEvent.EVENT_BUS.register(new TurtlePermissions());
        TurtleEvent.EVENT_BUS.register(new SignInspectHandler());
        ComputerCraftAPI.registerGenericSource(new InventoryMethods());
    }

    public void beforeGameStart() {
        if (Helper.isServerEnvironment()) {
            Config.serverStarting();
        } else {
            Config.clientStarted();
        }
    }

    public void afterGameStart() {
        ComputerCraftPocketUpgrades.registerPocketUpgrades();
        ComputerCraftTurtleUpgrades.registerTurtleUpgrades();
    }
}

