/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft;

import dan200.computercraft.Peripherals;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.GenericSource;
import dan200.computercraft.api.lua.ILuaAPIFactory;
import dan200.computercraft.api.media.IMediaProvider;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.wired.IWiredElement;
import dan200.computercraft.api.network.wired.IWiredNode;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.core.apis.ApiFactories;
import dan200.computercraft.core.asm.GenericMethod;
import dan200.computercraft.core.filesystem.FileMount;
import dan200.computercraft.core.filesystem.ResourceMount;
import dan200.computercraft.shared.BundledRedstone;
import dan200.computercraft.shared.MediaProviders;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.peripheral.modem.wired.TileCable;
import dan200.computercraft.shared.peripheral.modem.wired.TileWiredModemFull;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessNetwork;
import dan200.computercraft.shared.util.BlockPos;
import dan200.computercraft.shared.util.IDAssigner;
import dan200.computercraft.shared.util.ResourceManager;
import dan200.computercraft.shared.wired.WiredNode;
import java.io.File;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public final class ComputerCraftAPIImpl
implements ComputerCraftAPI.IComputerCraftAPI {
    public static final ComputerCraftAPIImpl INSTANCE = new ComputerCraftAPIImpl();
    static final ResourceManager manager = new ResourceManager();
    private String version;

    private ComputerCraftAPIImpl() {
    }

    public static InputStream getResourceFile(String domain, String subPath) {
        return manager.getResource(new ResourceManager.Identifier(domain, subPath)).getInputStream();
    }

    @Override
    @Nonnull
    public String getInstalledVersion() {
        if (this.version != null) {
            return this.version;
        }
        this.version = FabricLoader.getInstance().getModContainer("computercraft").map(x -> x.getMetadata().getVersion().toString()).orElse("unknown");
        return this.version;
    }

    @Override
    public int createUniqueNumberedSaveDir(@Nonnull World world, @Nonnull String parentSubPath) {
        return IDAssigner.getNextId(parentSubPath);
    }

    @Override
    public IWritableMount createSaveDirMount(@Nonnull World world, @Nonnull String subPath, long capacity) {
        try {
            return new FileMount(new File(IDAssigner.getWorldDir(), subPath), capacity);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public IMount createResourceMount(@Nonnull String domain, @Nonnull String subPath) {
        ResourceMount mount = ResourceMount.get(domain, subPath, manager);
        return mount.exists("") ? mount : null;
    }

    @Override
    public void registerPeripheralProvider(@Nonnull IPeripheralProvider provider) {
        Peripherals.register(provider);
    }

    @Override
    public void registerTurtleUpgrade(@Nonnull ITurtleUpgrade upgrade) {
        TurtleUpgrades.register(upgrade);
    }

    @Override
    public void registerBundledRedstoneProvider(@Nonnull IBundledRedstoneProvider provider) {
        BundledRedstone.register(provider);
    }

    @Override
    public int getBundledRedstoneOutput(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        return BundledRedstone.getDefaultOutput(world, pos, side);
    }

    @Override
    public void registerMediaProvider(@Nonnull IMediaProvider provider) {
        MediaProviders.register(provider);
    }

    @Override
    public void registerPocketUpgrade(@Nonnull IPocketUpgrade upgrade) {
        PocketUpgrades.register(upgrade);
    }

    @Override
    public void registerGenericSource(@Nonnull GenericSource source) {
        GenericMethod.register(source);
    }

    @Override
    @Nonnull
    public IPacketNetwork getWirelessNetwork() {
        return WirelessNetwork.getUniversal();
    }

    @Override
    public void registerAPIFactory(@Nonnull ILuaAPIFactory factory) {
        ApiFactories.register(factory);
    }

    @Override
    @Nonnull
    public IWiredNode createWiredNodeForElement(@Nonnull IWiredElement element) {
        return new WiredNode(element);
    }

    @Override
    @Nullable
    public IWiredElement getWiredElementAt(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Direction side) {
        TileEntity tile = world.getTileEntity(pos.x, pos.y, pos.z);
        if (tile instanceof TileCable) {
            return ((TileCable)tile).getElement(side);
        }
        if (tile instanceof TileWiredModemFull) {
            return ((TileWiredModemFull)tile).getElement();
        }
        return null;
    }
}

