/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.fabric.Helper;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralProvider;
import dan200.computercraft.shared.util.BlockPos;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;

public final class Peripherals {
    private static final Collection<IPeripheralProvider> providers = new LinkedHashSet<IPeripheralProvider>();

    private Peripherals() {
    }

    public static synchronized void register(@Nonnull IPeripheralProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        providers.add(provider);
    }

    @Nullable
    public static IPeripheral getPeripheral(World world, BlockPos pos, Direction side) {
        return pos.y < 256 && (Helper.isServerEnvironment() || Helper.isSinglePlayer()) ? Peripherals.getPeripheralAt(world, pos, side) : null;
    }

    @Nullable
    private static IPeripheral getPeripheralAt(World world, BlockPos pos, Direction side) {
        for (IPeripheralProvider peripheralProvider : providers) {
            try {
                IPeripheral peripheral = peripheralProvider.getPeripheral(world, pos, side);
                if (peripheral == null) continue;
                return peripheral;
            }
            catch (Exception e) {
                ComputerCraft.log.error("Peripheral provider " + peripheralProvider + " errored.", (Throwable)e);
            }
        }
        return GenericPeripheralProvider.getPeripheral(world, pos, side);
    }
}

