/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.IArguments;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ObjectArguments
implements IArguments {
    private static final IArguments EMPTY = new ObjectArguments(new Object[0]);
    private final List<Object> args;

    @Deprecated
    public ObjectArguments(IArguments arguments) {
        throw new IllegalStateException();
    }

    public ObjectArguments(Object ... args) {
        this.args = Arrays.asList(args);
    }

    public ObjectArguments(List<Object> args) {
        this.args = Objects.requireNonNull(args);
    }

    @Override
    public IArguments drop(int count) {
        if (count < 0) {
            throw new IllegalStateException("count cannot be negative");
        }
        if (count == 0) {
            return this;
        }
        if (count >= this.args.size()) {
            return EMPTY;
        }
        return new ObjectArguments(this.args.subList(count, this.args.size()));
    }

    @Override
    public Object[] getAll() {
        return this.args.toArray();
    }

    @Override
    public int count() {
        return this.args.size();
    }

    @Override
    @Nullable
    public Object get(int index) {
        return index >= this.args.size() ? null : this.args.get(index);
    }
}

