/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.client.blocks.BlockAORenderer;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import javax.annotation.Nonnull;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.item.IItemConvertible;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;

public abstract class AbstractTurtleUpgrade
implements ITurtleUpgrade {
    private final int id;
    private final TurtleUpgradeType type;
    private final ItemStack stack;

    protected AbstractTurtleUpgrade(int id, TurtleUpgradeType type, IItemConvertible item) {
        this(id, type, new ItemStack(item));
    }

    protected AbstractTurtleUpgrade(int id, TurtleUpgradeType type, ItemStack stack) {
        this.id = id;
        this.type = type;
        this.stack = stack;
    }

    protected static void drawUpgradeLeft(Tessellator tessellator, TileTurtle tileEntity, float angle) {
        new BlockAORenderer(AABB.getTemporaryBB((double)0.03125, (double)0.28125, (double)0.21875, (double)0.125, (double)0.78125, (double)0.71875)).setBottomUV(0.875, 0.875, 1.0, 0.125).setTopUV(0.1875, 0.125, 0.0, 0.875).setNorthUV(0.0, 0.125, 0.1875, 0.875).setSouthUV(0.8125, 0.125, 1.0, 0.875).setWestUV(0.125, 0.125, 0.875, 0.875).render(tessellator, tileEntity, angle, 1.0f, 1.0f, 1.0f);
    }

    protected static void drawUpgradeRight(Tessellator tessellator, TileTurtle tileEntity, float angle) {
        new BlockAORenderer(AABB.getTemporaryBB((double)0.875, (double)0.28125, (double)0.21875, (double)0.96875, (double)0.78125, (double)0.71875)).setBottomUV(1.0, 0.125, 0.875, 0.875).setTopUV(0.0, 0.875, 0.1875, 0.125).setNorthUV(0.8125, 0.125, 1.0, 0.875).setSouthUV(0.0, 0.125, 0.1875, 0.875).setEastUV(0.125, 0.125, 0.875, 0.875).render(tessellator, tileEntity, angle, 1.0f, 1.0f, 1.0f);
    }

    protected static void drawUpgradeLeft(Tessellator tessellator) {
        new BlockAORenderer(AABB.getTemporaryBB((double)0.03125, (double)0.28125, (double)0.21875, (double)0.125, (double)0.78125, (double)0.71875)).setBottomUV(0.875, 0.875, 1.0, 0.125).setTopUV(0.1875, 0.125, 0.0, 0.875).setNorthUV(0.0, 0.125, 0.1875, 0.875).setSouthUV(0.8125, 0.125, 1.0, 0.875).setWestUV(0.125, 0.125, 0.875, 0.875).render(tessellator, Side.NORTH);
    }

    protected static void drawUpgradeRight(Tessellator tessellator) {
        new BlockAORenderer(AABB.getTemporaryBB((double)0.875, (double)0.28125, (double)0.21875, (double)0.96875, (double)0.78125, (double)0.71875)).setBottomUV(1.0, 0.125, 0.875, 0.875).setTopUV(0.0, 0.875, 0.1875, 0.125).setNorthUV(0.8125, 0.125, 1.0, 0.875).setSouthUV(0.0, 0.125, 0.1875, 0.875).setEastUV(0.125, 0.125, 0.875, 0.875).render(tessellator, Side.NORTH);
    }

    @Override
    @Nonnull
    public final int getUpgradeID() {
        return this.id;
    }

    @Override
    @Nonnull
    public final TurtleUpgradeType getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public final ItemStack getCraftingItem() {
        return this.stack;
    }
}

