/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TurtleCommandResult {
    private static final TurtleCommandResult EMPTY_SUCCESS = new TurtleCommandResult(true, null, null);
    private static final TurtleCommandResult EMPTY_FAILURE = new TurtleCommandResult(false, null, null);
    private final boolean success;
    private final String errorMessage;
    private final Object[] results;

    private TurtleCommandResult(boolean success, String errorMessage, Object[] results) {
        this.success = success;
        this.errorMessage = errorMessage;
        this.results = results;
    }

    @Nonnull
    public static TurtleCommandResult success() {
        return EMPTY_SUCCESS;
    }

    @Nonnull
    public static TurtleCommandResult success(@Nullable Object[] results) {
        if (results == null || results.length == 0) {
            return EMPTY_SUCCESS;
        }
        return new TurtleCommandResult(true, null, results);
    }

    @Nonnull
    public static TurtleCommandResult failure() {
        return EMPTY_FAILURE;
    }

    @Nonnull
    public static TurtleCommandResult failure(@Nullable String errorMessage) {
        if (errorMessage == null) {
            return EMPTY_FAILURE;
        }
        return new TurtleCommandResult(false, errorMessage, null);
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public Object[] getResults() {
        return this.results;
    }
}

