/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle.event;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.event.TurtleAction;
import dan200.computercraft.api.turtle.event.TurtleActionEvent;
import dan200.computercraft.shared.util.BlockPos;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public abstract class TurtleBlockEvent
extends TurtleActionEvent {
    private final World world;
    private final BlockPos pos;

    protected TurtleBlockEvent(@Nonnull ITurtleAccess turtle, @Nonnull TurtleAction action, @Nonnull World world, @Nonnull BlockPos pos) {
        super(turtle, action);
        Objects.requireNonNull(world, "world cannot be null");
        Objects.requireNonNull(pos, "pos cannot be null");
        this.world = world;
        this.pos = pos;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public static class Inspect
    extends TurtleBlockEvent {
        private final int id;
        private final int metadata;
        private final Map<String, Object> data;

        public Inspect(@Nonnull ITurtleAccess turtle, @Nonnull World world, @Nonnull BlockPos pos, int id, int metadata, @Nonnull Map<String, Object> data) {
            super(turtle, TurtleAction.INSPECT, world, pos);
            Objects.requireNonNull(data, "data cannot be null");
            this.data = data;
            this.id = id;
            this.metadata = metadata;
        }

        public int getId() {
            return this.id;
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Nonnull
        public Map<String, Object> getData() {
            return this.data;
        }

        public void addData(@Nonnull Map<String, ?> newData) {
            Objects.requireNonNull(newData, "newData cannot be null");
            this.data.putAll(newData);
        }
    }

    public static class Place
    extends TurtleBlockEvent {
        private final ItemStack stack;

        public Place(@Nonnull ITurtleAccess turtle, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull ItemStack stack) {
            super(turtle, TurtleAction.PLACE, world, pos);
            Objects.requireNonNull(stack, "stack cannot be null");
            this.stack = stack;
        }

        @Nonnull
        public ItemStack getStack() {
            return this.stack;
        }
    }

    public static class Move
    extends TurtleBlockEvent {
        public Move(@Nonnull ITurtleAccess turtle, @Nonnull World world, @Nonnull BlockPos pos) {
            super(turtle, TurtleAction.MOVE, world, pos);
        }
    }

    public static class Dig
    extends TurtleBlockEvent {
        private final int block;
        private final ITurtleUpgrade upgrade;
        private final TurtleSide side;

        public Dig(@Nonnull ITurtleAccess turtle, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull int block, @Nonnull ITurtleUpgrade upgrade, @Nonnull TurtleSide side) {
            super(turtle, TurtleAction.DIG, world, pos);
            Objects.requireNonNull(Integer.valueOf(block), "block cannot be null");
            Objects.requireNonNull(upgrade, "upgrade cannot be null");
            Objects.requireNonNull(side, "side cannot be null");
            this.block = block;
            this.upgrade = upgrade;
            this.side = side;
        }

        @Nonnull
        public int getBlock() {
            return this.block;
        }

        @Nonnull
        public ITurtleUpgrade getUpgrade() {
            return this.upgrade;
        }

        @Nonnull
        public TurtleSide getSide() {
            return this.side;
        }
    }
}

