/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.gui.widgets.WidgetTerminal;
import dan200.computercraft.fabric.GLFWKeyboardManager;
import dan200.computercraft.fabric.GLFWMouseManager;
import dan200.computercraft.shared.computer.core.ClientComputer;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.Screen;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiComputer<T extends ContainerComputerBase>
extends Screen {
    public static final int MARGIN = 2;
    public static final int BORDER = 12;
    public static final int LIGHT_HEIGHT = 8;
    private static final int CORNER_TOP_Y = 28;
    private static final int CORNER_BOTTOM_Y = 40;
    private static final int CORNER_LEFT_X = 12;
    private static final int CORNER_RIGHT_X = 24;
    private static final int BORDER_RIGHT_X = 36;
    private static final int LIGHT_BORDER_Y = 56;
    private static final int LIGHT_CORNER_Y = 80;
    protected final ComputerFamily family;
    protected final ClientComputer computer;
    private final int termWidth;
    private final int termHeight;
    protected WidgetTerminal terminal;
    UUID glfwKeyCallbackId;
    UUID glfwCharCallbackId;
    UUID glfwScrollCallbackId;
    private int mouseButton = -1;

    public GuiComputer(T container, int termWidth, int termHeight) {
        this.family = ((ContainerComputerBase)container).getFamily();
        this.computer = ((ContainerComputerBase)container).getClientComputer();
        this.termWidth = termWidth;
        this.termHeight = termHeight;
        this.terminal = null;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(int mx, int my, float partialTick) {
        super.init();
        this.renderBackground();
        int termPxWidth = this.terminal.getWidth();
        int termPxHeight = this.terminal.getHeight();
        int wrapperX = (this.width - termPxWidth) / 2;
        int wrapperY = (this.height - termPxHeight) / 2;
        if (this.terminal != null) {
            this.terminal.draw(wrapperX, wrapperY);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (Objects.requireNonNull(this.family) == ComputerFamily.ADVANCED) {
            this.mc.textureManager.loadTexture("/assets/computercraft/textures/gui/corners_advanced.png").bind();
        } else {
            this.mc.textureManager.loadTexture("/assets/computercraft/textures/gui/corners_normal.png").bind();
        }
        if (this.mouseButton != -1) {
            this.terminal.mouseDragged(mx - wrapperX - 2, my - wrapperY - 2, this.mouseButton);
        }
        this.doRender(wrapperX - 2, wrapperY - 2, termPxWidth + 4, termPxHeight + 4, false);
    }

    public void doRender(int x, int y, int width, int height, boolean withLight) {
        int endX = x + width;
        int endY = y + height;
        this.renderCorner(x - 12, y - 12, 12, 28);
        this.renderLine(x - 12, y, 0, 28, 12, endY - y);
        this.renderLine(endX, y, 36, 28, 12, endY - y);
        this.renderLine(x, y - 12, 0, 0, endX - x, 12);
        this.renderCorner(x - 12, y - 12, 12, 28);
        this.renderCorner(endX, y - 12, 24, 28);
        if (withLight) {
            this.renderTexture(x, endY, 0, 56, endX - x, 20, 12, 20);
            this.renderTexture(x - 12, endY, 12, 80, 12, 20);
            this.renderTexture(endX, endY, 24, 80, 12, 20);
        } else {
            this.renderLine(x, endY, 0, 12, endX - x, 12);
            this.renderCorner(x - 12, endY, 12, 40);
            this.renderCorner(endX, endY, 24, 40);
        }
    }

    private void renderLine(int x, int y, int u, int v, int width, int height) {
        this.renderTexture(x, y, u, v, width, height, 12, 12);
    }

    private void renderCorner(int x, int y, int u, int v) {
        this.renderTexture(x, y, u, v, 12, 12, 12, 12);
    }

    private void renderTexture(int x, int y, int u, int v, int width, int height) {
        this.renderTexture(x, y, u, v, width, height, width, height);
    }

    private void renderTexture(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        this.drawTexturedModalRect(x, y, u, v, width, height, textureWidth, textureHeight);
    }

    protected void initTerminal() {
        super.init();
        this.terminal = new WidgetTerminal(this.mc, () -> this.computer, this.termWidth, this.termHeight, 2, 2, 2, 2);
    }

    public void init() {
        this.initTerminal();
        GLFWKeyboardManager.getInstance().removeKeyObserver(this.glfwKeyCallbackId);
        this.glfwKeyCallbackId = GLFWKeyboardManager.getInstance().addKeyObserver(this::glfwKeyCallback);
        GLFWKeyboardManager.getInstance().removeCharObserver(this.glfwCharCallbackId);
        this.glfwCharCallbackId = GLFWKeyboardManager.getInstance().addCharObserver(this::glfwCharCallback);
        GLFWMouseManager.getInstance().removeScrollObserver(this.glfwScrollCallbackId);
        this.glfwScrollCallbackId = GLFWMouseManager.getInstance().addScrollObserver(this::glfwScrollCallback);
    }

    public void removed() {
        GLFWKeyboardManager.getInstance().removeKeyObserver(this.glfwKeyCallbackId);
        GLFWKeyboardManager.getInstance().removeCharObserver(this.glfwCharCallbackId);
        GLFWMouseManager.getInstance().removeScrollObserver(this.glfwScrollCallbackId);
    }

    public void glfwKeyCallback(long window, int key, int scancode, int action, int mods) {
        if (action == 0) {
            this.terminal.keyReleased(key, scancode, mods);
            return;
        }
        this.terminal.keyPressed(key, scancode, mods);
    }

    public void glfwCharCallback(long window, int codepoint) {
        this.terminal.charTyped((char)codepoint);
    }

    public void glfwScrollCallback(long window, double xoffset, double yoffset) {
        int mx = Mouse.getEventX() * this.width / this.mc.resolution.getWidthScreenCoords();
        int my = this.height - Mouse.getEventY() * this.height / this.mc.resolution.getHeightScreenCoords() - 1;
        int termPxWidth = this.terminal.getWidth();
        int termPxHeight = this.terminal.getHeight();
        int wrapperX = (this.width - termPxWidth) / 2;
        int wrapperY = (this.height - termPxHeight) / 2;
        this.terminal.mouseScrolled(mx - wrapperX - 2, my - wrapperY - 2, yoffset);
    }

    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        int termPxWidth = this.terminal.getWidth();
        int termPxHeight = this.terminal.getHeight();
        int wrapperX = (this.width - termPxWidth) / 2;
        int wrapperY = (this.height - termPxHeight) / 2;
        this.mouseButton = buttonNum;
        this.terminal.mouseClicked(mx - wrapperX - 2, my - wrapperY - 2, buttonNum);
    }

    public void mouseReleased(int mx, int my, int buttonNum) {
        super.mouseReleased(mx, my, buttonNum);
        int termPxWidth = this.terminal.getWidth();
        int termPxHeight = this.terminal.getHeight();
        int wrapperX = (this.width - termPxWidth) / 2;
        int wrapperY = (this.height - termPxHeight) / 2;
        if (this.mouseButton != -1) {
            this.terminal.mouseDragged(mx - wrapperX - 2, my - wrapperY - 2, this.mouseButton);
        }
        if (buttonNum != -1) {
            this.mouseButton = -1;
            this.terminal.mouseReleased(mx - wrapperX - 2, my - wrapperY - 2, buttonNum);
        }
    }

    public void tick() {
        super.tick();
        this.terminal.update();
    }

    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.displayScreen(null);
        }
    }
}

