/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.fabric.GLFWMouseManager;
import dan200.computercraft.shared.media.items.ItemPrintout;
import java.util.UUID;
import net.minecraft.client.gui.Screen;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiPrintout
extends Screen {
    private final boolean book;
    private final int pages;
    private final TextBuffer[] text;
    private final TextBuffer[] colours;
    private int page;
    UUID glfwScrollCallbackId;

    public GuiPrintout(ItemStack stack) {
        String[] text = ItemPrintout.getText(stack);
        this.text = new TextBuffer[text.length];
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = new TextBuffer(text[i]);
        }
        String[] colours = ItemPrintout.getColours(stack);
        this.colours = new TextBuffer[colours.length];
        for (int i = 0; i < this.colours.length; ++i) {
            this.colours[i] = new TextBuffer(colours[i]);
        }
        this.page = 0;
        this.pages = Math.max(this.text.length / 21, 1);
        this.book = ((ItemPrintout)stack.getItem()).getType() == ItemPrintout.Type.BOOK;
    }

    public void init() {
        GLFWMouseManager.getInstance().removeScrollObserver(this.glfwScrollCallbackId);
        this.glfwScrollCallbackId = GLFWMouseManager.getInstance().addScrollObserver(this::glfwScrollCallback);
    }

    public void removed() {
        GLFWMouseManager.getInstance().removeScrollObserver(this.glfwScrollCallbackId);
    }

    public void glfwScrollCallback(long window, double xoffset, double yoffset) {
        if (yoffset < 0.0) {
            if (this.page < this.pages - 1) {
                ++this.page;
            }
            return;
        }
        if (yoffset > 0.0) {
            if (this.page > 0) {
                --this.page;
            }
            return;
        }
    }

    public void render(int mx, int my, float partialTick) {
        super.init();
        this.zLevel -= 1.0f;
        this.renderBackground();
        this.zLevel += 1.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.textureManager.loadTexture("/assets/computercraft/textures/gui/printout.png").bind();
        int x = (this.width - 172) / 2;
        int y = (this.height - 209) / 2;
        PrintoutRenderer.drawBorder(x, y, this.zLevel, this.page, this.pages, this.book);
        PrintoutRenderer.drawText(x + 13, y + 11, 0.02f, 21 * this.page, this.text, this.colours);
    }

    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        super.keyPressed(eventCharacter, eventKey, mx, my);
        if (eventKey == Keyboard.KEY_RIGHT) {
            if (this.page < this.pages - 1) {
                ++this.page;
            }
            return;
        }
        if (eventKey == Keyboard.KEY_LEFT && this.page > 0) {
            --this.page;
        }
    }
}

